/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import net.minecraft.command.ICommandSender;
import serverutils.ServerUtilities;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CmdTreeBase;
import serverutils.lib.data.Universe;
import serverutils.lib.util.FileUtils;
import serverutils.task.backup.BackupTask;

public class CmdBackup
extends CmdTreeBase {
    public CmdBackup() {
        super("backup");
        this.addSubcommand(new CmdBackupStart("start"));
        this.addSubcommand(new CmdBackupStop("stop"));
        this.addSubcommand(new CmdBackupGetSize("getsize"));
    }

    public static class CmdBackupStart
    extends CmdBase {
        public CmdBackupStart(String s) {
            super(s, CmdBase.Level.OP_OR_SP);
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            BackupTask task = new BackupTask(sender, args.length == 0 ? "" : args[0]);
            if (BackupTask.thread == null) {
                task.execute(Universe.get());
                sender.func_145747_a(ServerUtilities.lang("cmd.backup_manual_launch", sender.func_70005_c_()));
            } else {
                sender.func_145747_a(ServerUtilities.lang(sender, "cmd.backup_already_running", new Object[0]));
            }
        }
    }

    public static class CmdBackupStop
    extends CmdBase {
        public CmdBackupStop(String s) {
            super(s, CmdBase.Level.OP_OR_SP);
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            if (BackupTask.thread != null) {
                BackupTask.thread.interrupt();
                BackupTask.thread = null;
                sender.func_145747_a(ServerUtilities.lang(sender, "cmd.backup_stop", new Object[0]));
            } else {
                sender.func_145747_a(ServerUtilities.lang(sender, "cmd.backup_not_running", new Object[0]));
            }
        }
    }

    public static class CmdBackupGetSize
    extends CmdBase {
        public CmdBackupGetSize(String s) {
            super(s, CmdBase.Level.OP_OR_SP);
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            String sizeW = FileUtils.getSizeString(sender.func_130014_f_().func_72860_G().func_75765_b());
            String sizeT = FileUtils.getSizeString(BackupTask.BACKUP_FOLDER);
            sender.func_145747_a(ServerUtilities.lang(sender, "cmd.backup_size", sizeW, sizeT));
        }
    }
}

