/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import serverutils.ServerUtilities;
import serverutils.events.RegisterRankConfigEvent;
import serverutils.events.RegisterRankConfigHandlerEvent;
import serverutils.lib.config.ConfigNull;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.DefaultRankConfigHandler;
import serverutils.lib.config.IRankConfigHandler;
import serverutils.lib.config.RankConfigValueInfo;

public class RankConfigAPI {
    private static IRankConfigHandler handler = null;

    private static void setHandler(IRankConfigHandler h) {
        Preconditions.checkNotNull((Object)h, (Object)"Permission handler can't be null!");
        ServerUtilities.LOGGER.warn("Replacing " + handler.getClass().getName() + " with " + h.getClass().getName());
        handler = h;
    }

    public static IRankConfigHandler getHandler() {
        if (handler == null) {
            handler = DefaultRankConfigHandler.INSTANCE;
            new RegisterRankConfigHandlerEvent(RankConfigAPI::setHandler).post();
            new RegisterRankConfigEvent(handler::registerRankConfig).post();
        }
        return handler;
    }

    public static ConfigValue get(MinecraftServer server, GameProfile profile, String node) {
        Preconditions.checkNotNull((Object)profile, (Object)"GameProfile can't be null!");
        Preconditions.checkNotNull((Object)node, (Object)"Config node can't be null!");
        return RankConfigAPI.getHandler().getConfigValue(server, profile, node);
    }

    public static ConfigValue get(EntityPlayerMP player, String node) {
        Preconditions.checkNotNull((Object)player, (Object)"Player can't be null!");
        Preconditions.checkNotNull((Object)node, (Object)"Config node can't be null!");
        return RankConfigAPI.get(player.field_71133_b, player.func_146103_bH(), node);
    }

    public static ConfigValue getConfigValue(String node, boolean op) {
        RankConfigValueInfo info = RankConfigAPI.getHandler().getInfo(node);
        return info == null ? ConfigNull.INSTANCE : (op ? info.defaultOPValue : info.defaultValue);
    }
}

