/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.net;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleChannelHandlerWrapper;
import cpw.mods.fml.common.network.simpleimpl.SimpleIndexedCodec;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.MessageToClientHandler;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.MessageToServerHandler;

public class NetworkWrapper {
    private final SimpleIndexedCodec packetCodec = new SimpleIndexedCodec();
    private final FMLEmbeddedChannel serverChannels;
    private final FMLEmbeddedChannel clientChannels;
    private int nextDiscriminator = 0;

    private NetworkWrapper(String s) {
        EnumMap channels = NetworkRegistry.INSTANCE.newChannel(s, new ChannelHandler[]{this.packetCodec});
        this.serverChannels = (FMLEmbeddedChannel)channels.get(Side.SERVER);
        this.clientChannels = (FMLEmbeddedChannel)channels.get(Side.CLIENT);
    }

    public static NetworkWrapper newWrapper(String id) {
        if (id.length() > 20) {
            throw new IllegalArgumentException("Network wrapper " + id + " id isn't valid, must be <= 20 characters!");
        }
        return new NetworkWrapper(id);
    }

    public FMLEmbeddedChannel getChannel(Side s) {
        return s.isServer() ? this.serverChannels : this.clientChannels;
    }

    public void registerBlank() {
        ++this.nextDiscriminator;
    }

    public void register(MessageToClient m) {
        this.registerBlank();
        Class<?> clazz = m.getClass();
        this.packetCodec.addDiscriminator(this.nextDiscriminator, clazz);
        FMLEmbeddedChannel channel = this.getChannel(Side.CLIENT);
        String type = channel.findChannelHandlerNameForType(SimpleIndexedCodec.class);
        channel.pipeline().addAfter(type, clazz.getName(), (ChannelHandler)new SimpleChannelHandlerWrapper((IMessageHandler)MessageToClientHandler.INSTANCE, Side.CLIENT, clazz));
    }

    public void register(MessageToServer m) {
        this.registerBlank();
        Class<?> clazz = m.getClass();
        this.packetCodec.addDiscriminator(this.nextDiscriminator, clazz);
        FMLEmbeddedChannel channel = this.getChannel(Side.SERVER);
        String type = channel.findChannelHandlerNameForType(SimpleIndexedCodec.class);
        channel.pipeline().addAfter(type, clazz.getName(), (ChannelHandler)new SimpleChannelHandlerWrapper((IMessageHandler)MessageToServerHandler.INSTANCE, Side.SERVER, clazz));
    }
}

