/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.witch;

import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.witch.Entity_SpecialWitch;

public class EntityWindWitch
extends Entity_SpecialWitch {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "witch/wind.png")};
    public int teleportDelay;

    public EntityWindWitch(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.getSpecialData().isImmuneToFalling = true;
        this.field_70728_aV += 2;
    }

    @Override
    protected void initTypeAI() {
        this.setMeleeAI();
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, 2.0);
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 1.2);
        ItemStack itemStack = new ItemStack(Items.field_151041_m);
        float tension = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70146_Z.nextFloat() < 0.25f * tension) {
            try {
                EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)itemStack, (int)((int)(5.0f + tension * (float)this.field_70146_Z.nextInt(18))));
            }
            catch (Exception ex) {
                _SpecialMobs.console("Error applying enchantments! entity:" + this.toString());
                ex.printStackTrace();
            }
        }
        this.func_70062_b(0, itemStack);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.teleportDelay-- <= 0 && this.func_70638_az() != null && this.field_70146_Z.nextInt(20) == 0) {
            if (this.func_70638_az().func_70068_e((Entity)this) > 36.0) {
                this.func_82170_o(Potion.field_76441_p.field_76415_H);
                for (int i = 0; i < 16; ++i) {
                    if (!this.teleportToEntity((Entity)this.func_70638_az())) continue;
                    this.teleportDelay = 60;
                    break;
                }
            } else {
                this.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 30));
                for (int i = 0; i < 16; ++i) {
                    if (!this.teleportRandomly()) continue;
                    this.teleportDelay = 30;
                    break;
                }
            }
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (!this.field_70170_p.field_72995_K && damageSource.func_76346_g() != null) {
            if ((this.teleportDelay -= 15) <= 0 && (damageSource instanceof EntityDamageSourceIndirect || this.field_70146_Z.nextBoolean())) {
                double xI = this.field_70165_t;
                double yI = this.field_70163_u;
                double zI = this.field_70161_v;
                for (int i = 0; i < 64; ++i) {
                    if (!this.teleportRandomly()) continue;
                    this.teleportDelay = 30;
                    this.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 30));
                    if (damageSource instanceof EntityDamageSourceIndirect) {
                        return true;
                    }
                    boolean hit = super.func_70097_a(damageSource, damage);
                    if (this.func_110143_aJ() <= 0.0f) {
                        this.func_70107_b(xI, yI, zI);
                    }
                    return hit;
                }
            } else {
                this.func_82170_o(Potion.field_76441_p.field_76415_H);
            }
        }
        return super.func_70097_a(damageSource, damage);
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151008_G, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        ItemStack potion = new ItemStack((Item)Items.field_151068_bn, 1, 8206);
        EffectHelper.setItemName(potion, "Potion of Hiding", 15);
        EffectHelper.addPotionEffect(potion, Potion.field_76441_p, 1200, 0);
        EffectHelper.addPotionEffect(potion, Potion.field_76440_q, 1200, 0);
        this.func_70099_a(potion, 0.0f);
    }

    protected boolean teleportRandomly() {
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 20.0;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextInt(12) - 4);
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 20.0;
        return this.teleportTo(x, y, z);
    }

    protected boolean teleportToEntity(Entity entity) {
        double x = entity.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0;
        double y = entity.field_70163_u + (double)this.field_70146_Z.nextInt(8) - 2.0;
        double z = entity.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0;
        return this.teleportTo(x, y, z);
    }

    protected boolean teleportTo(double x, double y, double z) {
        double xI = this.field_70165_t;
        double yI = this.field_70163_u;
        double zI = this.field_70161_v;
        this.func_70107_b(x, y, z);
        if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() != 0 || this.field_70170_p.func_72953_d(this.field_70121_D)) {
            this.func_70107_b(xI, yI, zI);
            return false;
        }
        for (int i = 0; i < 128; ++i) {
            double posRelative = (double)i / 127.0;
            float vX = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float vY = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float vZ = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double dX = xI + (this.field_70165_t - xI) * posRelative + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double dY = yI + (this.field_70163_u - yI) * posRelative + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double dZ = zI + (this.field_70161_v - zI) * posRelative + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("smoke", dX, dY, dZ, (double)vX, (double)vY, (double)vZ);
        }
        return true;
    }
}

