/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import toast.specialMobs.SpecialDamageSource;
import toast.specialMobs.entity.cavespider.Entity_SpecialCaveSpider;
import toast.specialMobs.entity.spider.Entity_SpecialSpider;

public class EntitySpecialSpitball
extends Entity {
    public EntityLiving shootingEntity = null;
    private float damage;

    public EntitySpecialSpitball(World world) {
        super(world);
    }

    public EntitySpecialSpitball(World world, EntityLiving entity, Entity target, float speed, float spread) {
        super(world);
        this.shootingEntity = entity;
        this.func_70012_b(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() - 0.1, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = (target.field_70165_t - entity.field_70165_t) * 0.7;
        this.field_70181_x = (target.field_70163_u + (double)target.func_70047_e() - 0.7 - this.field_70163_u) * 0.7;
        this.field_70179_y = (target.field_70161_v - entity.field_70161_v) * 0.7;
        double vH = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        if (vH >= 1.0E-7) {
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            this.field_70125_A = (float)(-Math.atan2(this.field_70181_x, vH) * 180.0 / Math.PI);
            double dX = this.field_70159_w / vH;
            double dZ = this.field_70179_y / vH;
            this.func_70012_b(entity.field_70165_t + dX, this.field_70163_u, entity.field_70161_v + dZ, this.field_70177_z, this.field_70125_A);
            this.field_70129_M = 0.0f;
            this.calculateVelocity(this.field_70159_w, this.field_70181_x + vH * 0.2, this.field_70179_y, speed, spread);
        }
    }

    protected void func_70088_a() {
        this.func_70105_a(0.25f, 0.25f);
    }

    public boolean func_70112_a(double d) {
        double d1 = this.field_70121_D.func_72320_b() * 256.0;
        return d < d1 * d1;
    }

    public void calculateVelocity(double vX, double vY, double vZ, float v, float variance) {
        float vi = MathHelper.func_76133_a((double)(vX * vX + vY * vY + vZ * vZ));
        vX /= (double)vi;
        vY /= (double)vi;
        vZ /= (double)vi;
        vX += this.field_70146_Z.nextGaussian() * 0.0075 * (double)variance;
        vY += this.field_70146_Z.nextGaussian() * 0.0075 * (double)variance;
        vZ += this.field_70146_Z.nextGaussian() * 0.0075 * (double)variance;
        this.field_70159_w = vX *= (double)v;
        this.field_70181_x = vY *= (double)v;
        this.field_70179_y = vZ *= (double)v;
        float vH = MathHelper.func_76133_a((double)(vX * vX + vZ * vZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vX, vZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vY, vH) * 180.0 / Math.PI);
    }

    public void func_70016_h(double vX, double vY, double vZ) {
        this.field_70159_w = vX;
        this.field_70181_x = vY;
        this.field_70179_y = vZ;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float vH = MathHelper.func_76133_a((double)(vX * vX + vZ * vZ));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vX, vZ) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vY, vH) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.shootingEntity == null || this.shootingEntity.field_70128_L || this.func_70068_e((Entity)this.shootingEntity) > 1024.0) {
                this.func_70106_y();
            }
            Vec3 posVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 motionVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition object = this.field_70170_p.func_72933_a(posVec, motionVec);
            posVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            motionVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (object != null) {
                motionVec = Vec3.func_72443_a((double)object.field_72307_f.field_72450_a, (double)object.field_72307_f.field_72448_b, (double)object.field_72307_f.field_72449_c);
            }
            Entity entityHit = null;
            List entitiesInPath = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < entitiesInPath.size(); ++i) {
                double d1;
                AxisAlignedBB aabb;
                MovingObjectPosition object1;
                Entity entityInPath = (Entity)entitiesInPath.get(i);
                if (!entityInPath.func_70067_L() || entityInPath.func_70028_i((Entity)this.shootingEntity) || (object1 = (aabb = entityInPath.field_70121_D.func_72314_b(0.3, 0.3, 0.3)).func_72327_a(posVec, motionVec)) == null || !((d1 = posVec.func_72438_d(object1.field_72307_f)) < d)) continue;
                entityHit = entityInPath;
                d = d1;
            }
            if (entityHit != null) {
                object = new MovingObjectPosition(entityHit);
            }
            if (object != null) {
                this.onImpact(object);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float var16 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var16) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.func_70090_H()) {
            this.func_70106_y();
        }
        this.field_70159_w *= 0.99;
        this.field_70181_x *= 0.99;
        this.field_70179_y *= 0.99;
        this.field_70181_x -= (double)this.getGravityVelocity();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void onImpact(MovingObjectPosition object) {
        if (object.field_72308_g != null) {
            SpecialDamageSource damageSource = this.shootingEntity == null ? new SpecialDamageSource("generic", this, this) : new SpecialDamageSource("generic", this, (Entity)this.shootingEntity);
            damageSource.setProjectile().setDamageBypassesArmor().setMagicDamage().setDifficultyScaled().setHungerDamage(0.6f);
            if (object.field_72308_g.func_70097_a((DamageSource)damageSource, this.getDamage())) {
                if (this.shootingEntity instanceof Entity_SpecialSpider) {
                    ((Entity_SpecialSpider)this.shootingEntity).onTypeAttack(object.field_72308_g);
                } else if (this.shootingEntity instanceof Entity_SpecialCaveSpider) {
                    ((Entity_SpecialCaveSpider)this.shootingEntity).onTypeAttack(object.field_72308_g);
                }
            }
        }
        this.func_70106_y();
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float value) {
        this.damage = value;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public void func_70014_b(NBTTagCompound tag) {
    }

    public void func_70037_a(NBTTagCompound tag) {
    }
}

