/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.witch;

import java.lang.reflect.Field;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.lang3.reflect.FieldUtils;
import toast.specialMobs.EffectHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.witch.Entity_SpecialWitch;

public class EntityDominationWitch
extends Entity_SpecialWitch {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "witch/domination.png")};
    public int pullDelay;

    public EntityDominationWitch(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
    }

    @Override
    protected void initTypeAI() {
        this.setMeleeAI();
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 0.8);
    }

    public static boolean canAffectMind(EntityLivingBase entity) {
        if (entity.func_70644_a(Potion.field_76437_t)) {
            return true;
        }
        ItemStack helmet = entity.func_71124_b(4);
        return helmet == null || helmet.field_77990_d == null || !helmet.field_77990_d.func_74767_n("SM|MindProtect");
    }

    @Override
    public void func_70636_d() {
        EntityLivingBase target;
        double distanceSq;
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.pullDelay-- <= 0 && this.func_70638_az() != null && this.field_70146_Z.nextInt(20) == 0 && (distanceSq = (target = this.func_70638_az()).func_70068_e((Entity)this)) > 100.0 && distanceSq < 196.0 && EntityDominationWitch.canAffectMind(target) && this.func_70685_l((Entity)target)) {
            this.pullDelay = 80;
            double vX = this.field_70165_t - target.field_70165_t;
            double vY = this.field_70163_u - target.field_70163_u;
            double vZ = this.field_70161_v - target.field_70161_v;
            double v = Math.sqrt(distanceSq);
            double mult = 0.26;
            target.field_70159_w = vX * mult;
            target.field_70181_x = vY * mult + Math.sqrt(v) * 0.1;
            target.field_70179_y = vZ * mult;
            target.field_70122_E = false;
            if (target instanceof EntityPlayerMP) {
                try {
                    ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity((Entity)target));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void onTypeAttack(Entity target) {
        if (target instanceof EntityLivingBase) {
            EntityLivingBase livingTarget = (EntityLivingBase)target;
            PotionEffect stolenEffect = null;
            if (EntityDominationWitch.canAffectMind(livingTarget)) {
                for (PotionEffect effect : livingTarget.func_70651_bq()) {
                    try {
                        Field potionEffectField = FieldUtils.getDeclaredField(Potion.class, (String)"isBadEffect");
                        if (potionEffectField == null) {
                            potionEffectField = FieldUtils.getDeclaredField(Potion.class, (String)"field_76418_K");
                        }
                        if (potionEffectField == null) continue;
                        boolean tIsBadPotionEffect = false;
                        Object tFieldObject = FieldUtils.readField((Field)potionEffectField, (Object)Potion.field_76425_a[effect.func_76456_a()], (boolean)true);
                        if (tFieldObject != null) {
                            tIsBadPotionEffect = (Boolean)tFieldObject;
                        }
                        if (!tIsBadPotionEffect) continue;
                        stolenEffect = effect;
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (stolenEffect != null) {
                livingTarget.func_82170_o(stolenEffect.func_76456_a());
                int duration = Math.max(200, stolenEffect.func_76459_b());
                duration = (int)((double)duration * 1.3);
                this.func_70690_d(new PotionEffect(stolenEffect.func_76456_a(), duration, stolenEffect.func_76458_c()));
                livingTarget.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 110, Math.max(0, stolenEffect.func_76458_c())));
            } else {
                livingTarget.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 70, 0));
            }
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        int i = this.field_70146_Z.nextInt(3 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151062_by, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        int damage;
        if (superRare > 0) {
            damage = 0;
        } else {
            damage = Items.field_151169_ag.func_77612_l();
            damage = (int)(0.6f * (float)damage + 0.3f * (float)this.field_70146_Z.nextInt(damage));
        }
        ItemStack drop = new ItemStack((Item)Items.field_151169_ag, 1, damage);
        EffectHelper.setItemName(drop, "Helmet of Mind Protection", 13);
        EffectHelper.addItemText(drop, "\u00a77Protects against");
        EffectHelper.addItemText(drop, "\u00a77domination witches");
        drop.func_77966_a(Enchantment.field_77347_r, this.field_70146_Z.nextInt(3) + 1);
        drop.field_77990_d.func_74757_a("SM|MindProtect", true);
        this.func_70099_a(drop, 0.0f);
    }
}

