/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import toast.specialMobs.CommonProxy;
import toast.specialMobs.DataWatcherHelper;
import toast.specialMobs.EnchantmentSpecial;
import toast.specialMobs.EventHandler;
import toast.specialMobs.Properties;
import toast.specialMobs.TickHandler;
import toast.specialMobs.entity.EntityLavaMonster;
import toast.specialMobs.entity.EntitySpecialFishHook;
import toast.specialMobs.entity.EntitySpecialSpitball;
import toast.specialMobs.entity.SpawnLavaMonster;
import toast.specialMobs.entity.creeper.EntityEnderCreeper;
import toast.specialMobs.entity.creeper.EntityFireCreeper;
import toast.specialMobs.entity.ghast.EntityMiniGhast;
import toast.specialMobs.network.MessageExplosion;
import toast.specialMobs.network.MessageTexture;

@Mod(modid="SpecialMobs", name="Special Mobs", version="3.3.8")
public class _SpecialMobs {
    public static final String MODID = "SpecialMobs";
    public static final String VERSION = "3.3.8";
    public static final boolean debug = false;
    @SidedProxy(clientSide="toast.specialMobs.client.ClientProxy", serverSide="toast.specialMobs.CommonProxy")
    public static CommonProxy proxy;
    public static final Random random;
    public static SimpleNetworkWrapper CHANNEL;
    public static final String NAMESPACE;
    public static final String TEXTURE_PATH;
    public static final String[] MONSTER_KEY;
    public static final String[][] MONSTER_TYPES;
    public static final int[] MONSTER_KEY_COLORS;
    public static final int[][] MONSTER_TYPE_COLORS;

    private void registerMobs() {
        int eggId;
        DataWatcherHelper.init();
        int id = 0;
        boolean makeSpawnEggs = Properties.getBoolean("_general", "spawn_eggs");
        Method eggIdClaimer = null;
        if (makeSpawnEggs) {
            try {
                eggIdClaimer = EntityRegistry.class.getDeclaredMethod("validateAndClaimId", Integer.TYPE);
                eggIdClaimer.setAccessible(true);
            }
            catch (Exception ex) {
                _SpecialMobs.console("Error claiming spawn egg ID! Spawn eggs will probably be overwritten.");
                ex.printStackTrace();
            }
        }
        Method advGeneticsAddAbility = null;
        String[][] advGeneticsAbilities = null;
        try {
            Class<?> regHelper = Class.forName("com.advGenetics.API.RegistrationHelper");
            _SpecialMobs.console("Detected Advanced Genetics API, attempting to register mobs to it...");
            try {
                advGeneticsAddAbility = regHelper.getDeclaredMethod("addEntityToAbility", String.class, Class.class);
            }
            catch (Exception ex) {
                _SpecialMobs.console("Error finding Advanced Genetics registry!");
                ex.printStackTrace();
            }
            if (advGeneticsAddAbility != null) {
                advGeneticsAbilities = new String[][]{{"fireballs"}, {"climb", "poison"}, {"selfexplode"}, {"deathenderchest", "teleport"}, {"fireballsexplode"}, {"lavaswim"}, new String[0], {"infinity"}, {"slimy"}, {"climb"}, {"potionthrower"}, {"resistance"}};
                for (String ability : advGeneticsAbilities[_SpecialMobs.monsterKey("Enderman")]) {
                    try {
                        advGeneticsAddAbility.invoke(null, ability, EntityEnderCreeper.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception regHelper) {
            // empty catch block
        }
        for (int i = 0; i < MONSTER_KEY.length; ++i) {
            Class<?> entityClass;
            try {
                entityClass = Class.forName("toast.specialMobs.entity." + MONSTER_KEY[i].toLowerCase() + ".Entity_Special" + MONSTER_KEY[i]);
                EntityRegistry.registerModEntity(entityClass, (String)("Special" + MONSTER_KEY[i]), (int)id++, (Object)this, (int)80, (int)3, (boolean)true);
                if (advGeneticsAddAbility != null && advGeneticsAbilities != null) {
                    for (String ability : advGeneticsAbilities[i]) {
                        try {
                            advGeneticsAddAbility.invoke(null, ability, entityClass);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                _SpecialMobs.debugException("@" + MONSTER_KEY[i] + ": class not found!");
            }
            for (int j = 0; j < MONSTER_TYPES[i].length; ++j) {
                String name = MONSTER_TYPES[i][j] + MONSTER_KEY[i];
                try {
                    entityClass = Class.forName("toast.specialMobs.entity." + MONSTER_KEY[i].toLowerCase() + ".Entity" + name);
                    EntityRegistry.registerModEntity(entityClass, (String)name, (int)id++, (Object)this, (int)80, (int)3, (boolean)true);
                    if (makeSpawnEggs) {
                        eggId = EntityRegistry.findGlobalUniqueEntityId();
                        try {
                            if (eggIdClaimer != null) {
                                eggId = (Integer)eggIdClaimer.invoke((Object)EntityRegistry.instance(), eggId);
                            }
                        }
                        catch (Exception ability) {
                            // empty catch block
                        }
                        EntityList.field_75623_d.put(eggId, entityClass);
                        EntityList.field_75627_a.put(eggId, new EntityList.EntityEggInfo(eggId, MONSTER_KEY_COLORS[i], MONSTER_TYPE_COLORS[i][j]));
                    }
                    if (advGeneticsAddAbility == null || advGeneticsAbilities == null) continue;
                    for (String ability : advGeneticsAbilities[i]) {
                        try {
                            advGeneticsAddAbility.invoke(null, ability, entityClass);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    _SpecialMobs.debugException("@" + name + ": class not found!");
                }
            }
        }
        EntityRegistry.registerModEntity(EntitySpecialFishHook.class, (String)"SMFishHook", (int)id++, (Object)this, (int)64, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntitySpecialSpitball.class, (String)"SMSpitball", (int)id++, (Object)this, (int)64, (int)5, (boolean)true);
        DataWatcherHelper.verify();
        int spawnWeight = Properties.getInt("_extra_spawning", "end_ender_creeper");
        if (spawnWeight > 0) {
            EntityRegistry.addSpawn(EntityEnderCreeper.class, (int)spawnWeight, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76779_k});
        }
        if ((spawnWeight = Properties.getInt("_extra_spawning", "nether_fire_creeper")) > 0) {
            EntityRegistry.addSpawn(EntityFireCreeper.class, (int)spawnWeight, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76778_j});
        }
        if ((spawnWeight = Properties.getInt("_extra_spawning", "overworld_ghast_mount")) > 0) {
            EntityRegistry.addSpawn(EntityMiniGhast.class, (int)spawnWeight, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b, BiomeGenBase.field_76776_l, BiomeGenBase.field_76772_c, BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s, BiomeGenBase.field_76770_e, BiomeGenBase.field_76783_v, BiomeGenBase.field_76767_f, BiomeGenBase.field_76785_t, BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u, BiomeGenBase.field_76780_h, BiomeGenBase.field_76781_i, BiomeGenBase.field_76777_m, BiomeGenBase.field_76774_n, BiomeGenBase.field_76775_o, BiomeGenBase.field_76787_r, BiomeGenBase.field_76782_w, BiomeGenBase.field_76792_x});
        }
        EntityRegistry.registerModEntity(EntityLavaMonster.class, (String)"LavaMonster", (int)id++, (Object)this, (int)80, (int)3, (boolean)true);
        if (makeSpawnEggs) {
            eggId = EntityRegistry.findGlobalUniqueEntityId();
            try {
                Method method = EntityRegistry.class.getDeclaredMethod("validateAndClaimId", Integer.TYPE);
                method.setAccessible(true);
                eggId = (Integer)method.invoke((Object)EntityRegistry.instance(), eggId);
            }
            catch (Exception ex) {
                _SpecialMobs.console("Error claiming spawn egg ID! Spawn egg will probably be overwritten. @" + ex.getClass().getName());
            }
            EntityList.field_75623_d.put(eggId, EntityLavaMonster.class);
            EntityList.field_75627_a.put(eggId, new EntityList.EntityEggInfo(eggId, 0xFF0000, 0xFCFC00));
        }
        new SpawnLavaMonster();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        _SpecialMobs.debugConsole("Loading in debug mode!");
        Properties.init(new Configuration(event.getSuggestedConfigurationFile()));
        int id = 0;
        CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("SM|EX");
        if (event.getSide() == Side.CLIENT) {
            CHANNEL.registerMessage(MessageExplosion.Handler.class, MessageExplosion.class, id++, Side.CLIENT);
            CHANNEL.registerMessage(MessageTexture.Handler.class, MessageTexture.class, id++, Side.CLIENT);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EnchantmentSpecial.init();
        new EventHandler();
        new TickHandler();
        this.registerMobs();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public static int monsterKey(String key) {
        if (key == null) {
            return -1;
        }
        if (key.startsWith("SpecialMobs.Special")) {
            key = key.substring(MODID.length() + 8);
        }
        return Arrays.binarySearch(MONSTER_KEY, key);
    }

    public static int[] monsterType(String key, String type) {
        int i = _SpecialMobs.monsterKey(key);
        return new int[]{i, Arrays.binarySearch(MONSTER_TYPES[i], type)};
    }

    public static String cap(String string) {
        int length = string.length();
        if (length <= 0) {
            return "";
        }
        if (length == 1) {
            return string.toUpperCase();
        }
        return Character.toString(Character.toUpperCase(string.charAt(0))) + string.substring(1);
    }

    public static String decap(String string) {
        int length = string.length();
        if (length <= 0) {
            return "";
        }
        if (length == 1) {
            return string.toLowerCase();
        }
        return Character.toString(Character.toLowerCase(string.charAt(0))) + string.substring(1);
    }

    public static String localizeName(String name) {
        if (name.equals("PigZombie")) {
            return "Zombie Pigman";
        }
        if (name.length() > 1) {
            for (int i = 1; i < name.length(); ++i) {
                if (!Character.isUpperCase(name.charAt(i))) continue;
                return name.substring(0, i) + " " + _SpecialMobs.localizeName(name.substring(i));
            }
        }
        return name;
    }

    public static void console(String message) {
        System.out.println("[SpecialMobs] " + message);
    }

    public static void debugConsole(String message) {
    }

    public static void debugException(String message) {
        _SpecialMobs.console("[ERROR] " + message);
    }

    static {
        random = new Random();
        NAMESPACE = MODID.toLowerCase() + ":";
        TEXTURE_PATH = NAMESPACE + "textures/entity/";
        MONSTER_KEY = new String[]{"Blaze", "CaveSpider", "Creeper", "Enderman", "Ghast", "PigZombie", "Silverfish", "Skeleton", "Slime", "Spider", "Witch", "Zombie"};
        MONSTER_TYPES = new String[][]{{"Cinder", "Conflagration", "Ember", "Hellfire", "Inferno", "Jolt", "Smolder", "Wildfire"}, {"Baby", "Flying", "Mother", "Tough", "Web", "Witch"}, {"Armor", "Dark", "Death", "Dirt", "Doom", "Drowning", "Ender", "Fire", "Gravel", "Gravity", "Jumping", "Lightning", "Mini", "Splitting"}, {"Blinding", "Cursed", "Icy", "Lightning", "Mini", "Mirage", "Thief"}, {"Baby", "Faint", "Fighter", "King", "Mini", "Queen", "Unholy"}, {"Brutish", "Fishing", "Giant", "Hungry", "Plague", "Vampire"}, {"Blinding", "Fishing", "Flying", "Poison", "Tough"}, {"Brutish", "Fire", "Gatling", "Giant", "Ninja", "Poison", "Sniper", "Spitfire", "Thief"}, {"Blackberry", "Blueberry", "Caramel", "Grape", "Lemon", "Strawberry", "Watermelon"}, {"Baby", "Desert", "Flying", "Ghost", "Giant", "Hungry", "Mother", "Pale", "Poison", "Small", "Tough", "Web", "Witch"}, {"Domination", "Rage", "Shadows", "Undead", "Wilds", "Wind"}, {"Brutish", "Fire", "Fishing", "Giant", "Hungry", "Plague"}};
        MONSTER_KEY_COLORS = new int[]{16167425, 803406, 894731, 0x161616, 0xF9F9F9, 15373203, 0x6E6E6E, 0xC1C1C1, 5349438, 3419431, 0x340000, 44975};
        MONSTER_TYPE_COLORS = new int[][]{{16761035, 16775294, 0, 0xDDDDDD, 15814400, 4824238, 0, 16051762}, {16761035, 6523058, 0xB300B3, 9349134, 0xE7E7E7, 0xDD0E0E}, {12817718, 16383802, 0xCD0000, 7886139, 0x494949, 2966004, 13369594, 14760214, 9472132, 0x220022, 8216727, 4824238, 16761035, 6266146}, {0xFFFFFF, 11214109, 7509404, 0x4BB4B5, 16761035, 12762244, 326144}, {16761035, 8570995, 8000256, 15254810, 0xBCBCBC, 13503231, 8046420}, {16775294, 2966004, 5009705, 11212056, 0x8AA838, 0}, {0, 2966004, 6523058, 7838824, 0xDD0E0E}, {16775294, 14424576, 0xFFFF0B, 0x494949, 0x333366, 7838824, 4744992, 14424576, 0}, {0x331133, 7760828, 10318655, 0xB333B3, 15132769, 12478827, 14644857}, {16761035, 15130028, 6523058, 8570995, 11013646, 7969893, 0xB300B3, 14603462, 803406, 11013646, 9349134, 0xE7E7E7, 0xDD0E0E}, {16775294, 9643043, 0, 7969893, 11013646, 6523058}, {16775294, 14424576, 2966004, 7969893, 11212056, 0x8AA838}};
    }
}

