/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.cavespider;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.Properties;
import toast.specialMobs.entity.EntitySpecialSpitball;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialCaveSpider
extends EntityCaveSpider
implements ISpecialMob,
IRangedAttackMob {
    private static final double HOSTILE_CHANCE = Properties.getDouble("_mob_stats", "hostile_cavespiders");
    private static final double SPIT_CHANCE = Properties.getDouble("_mob_stats", "spit_chance_cavespider");
    private static final UUID stopModifierUUID = UUID.fromString("70A57A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier stopModifier = new AttributeModifier(stopModifierUUID, "Attacking speed boost", -1.0, 2).func_111168_a(false);
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/spider/cave_spider.png"), new ResourceLocation("textures/entity/spider_eyes.png")};
    public boolean isHostile;
    public boolean fakeDarkness;
    public int spitDelay = 0;
    public byte sightDelay = (byte)20;
    private SpecialMobData specialData;

    public Entity_SpecialCaveSpider(World world) {
        super(world);
        this.getSpecialData().resetRenderScale(0.7f);
        this.getSpecialData().immuneToPotions.add(Potion.field_76436_u.field_76415_H);
        this.getSpecialData().isImmuneToWebs = true;
    }

    protected void func_70088_a() {
        this.specialData = new SpecialMobData((EntityLiving)this, TEXTURES);
        super.func_70088_a();
        if (this.field_70146_Z.nextDouble() < SPIT_CHANCE) {
            this.setRangedAI(15, 40, 10.0f);
        }
    }

    protected void setRangedAI(int minDelay, int maxDelay, float range) {
        SpecialMobData data = this.getSpecialData();
        data.arrowRefireMin = (short)minDelay;
        data.arrowRefireMax = (short)maxDelay;
        data.arrowRange = range;
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        if (this.field_70146_Z.nextDouble() < HOSTILE_CHANCE) {
            this.isHostile = true;
        }
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    public void func_70636_d() {
        if (this.spitDelay > 0) {
            --this.spitDelay;
        }
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    protected void func_70626_be() {
        super.func_70626_be();
        if (this.isHostile && !this.func_70781_l()) {
            this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + (float)this.field_70146_Z.nextGaussian() * 20.0f));
        }
    }

    protected Entity func_70782_k() {
        if (this.isHostile) {
            this.fakeDarkness = true;
        }
        return super.func_70782_k();
    }

    protected void func_70785_a(Entity target, float distance) {
        boolean stopped;
        IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        boolean bl = stopped = attribute.func_111127_a(stopModifierUUID) != null;
        if (this.getSpecialData().arrowRange > 0.0f) {
            if (!this.field_70170_p.field_72995_K && this.spitDelay <= 0 && distance < this.getSpecialData().arrowRange) {
                boolean shouldStop;
                if (target instanceof EntityLivingBase && this.spitDelay <= 0) {
                    float damage = distance / this.getSpecialData().arrowRange;
                    this.spitDelay = (int)(damage * (float)(this.getSpecialData().arrowRefireMax - this.getSpecialData().arrowRefireMin) + (float)this.getSpecialData().arrowRefireMin);
                    damage = Math.max(0.1f, Math.min(1.0f, damage));
                    this.func_82196_d((EntityLivingBase)target, damage);
                }
                if (this.sightDelay > 0) {
                    this.sightDelay = (byte)(this.sightDelay - 1);
                }
                boolean bl2 = shouldStop = this.sightDelay <= 0;
                if (stopped != shouldStop) {
                    if (shouldStop) {
                        attribute.func_111121_a(stopModifier);
                    } else {
                        attribute.func_111124_b(stopModifier);
                    }
                }
            } else {
                this.sightDelay = (byte)20;
            }
        } else {
            if (stopped) {
                attribute.func_111124_b(stopModifier);
            }
            if (this.isHostile) {
                this.fakeDarkness = true;
            }
            super.func_70785_a(target, distance);
        }
    }

    public void func_82196_d(EntityLivingBase target, float range) {
        EntitySpecialSpitball spitball = new EntitySpecialSpitball(this.field_70170_p, (EntityLiving)this, (Entity)target, 1.6f, this.getTypeArrowSpread());
        spitball.setDamage(range * this.getSpecialData().arrowDamage + (float)this.field_70146_Z.nextGaussian() * 0.25f + (float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f);
        this.func_85030_a("mob.slimeattack", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)spitball);
    }

    protected float getTypeArrowSpread() {
        return this.getSpecialData().arrowSpread - (float)this.field_70170_p.field_73013_u.func_151525_a() * (this.getSpecialData().arrowSpread / 4.0f + 0.5f);
    }

    public float func_70013_c(float partialTick) {
        if (this.fakeDarkness) {
            this.fakeDarkness = false;
            return 0.0f;
        }
        return super.func_70013_c(partialTick);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)new EntityCaveSpider(this.field_70170_p));
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    public void onTypeAttack(Entity target) {
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (this.isHostile) {
            saveTag.func_74757_a("SMAnger", true);
        }
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
        this.getSpecialData().writeToNBT(saveTag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("SMAnger")) {
            this.isHostile = saveTag.func_74767_n("SMAnger");
        } else if (tag.func_74764_b("SMAnger")) {
            this.isHostile = tag.func_74767_n("SMAnger");
        }
        this.getSpecialData().readFromNBT(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.field_70178_ae = this.getSpecialData().isImmuneToFire;
    }

    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + this.getSpecialData().armor);
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning) {
            super.func_70015_d(time);
        }
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing;
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs) {
            super.func_70110_aj();
        }
    }

    protected void func_70069_a(float distance) {
        if (!this.getSpecialData().isImmuneToFalling) {
            super.func_70069_a(distance);
        }
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates;
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater;
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }
}

