/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs;

import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;
import toast.specialMobs.Properties;
import toast.specialMobs._SpecialMobs;

public abstract class RandomHelper {
    public static final int[] totalMonsterWeights = RandomHelper.buildTotalMonsterWeights();

    public static EntityLiving nextMonster(int key, World world) {
        return RandomHelper.nextEntity(key, world, "monster", _SpecialMobs.MONSTER_KEY[key], _SpecialMobs.MONSTER_TYPES[key], Properties.monsterWeights()[key], totalMonsterWeights[key]);
    }

    public static EntityLiving nextEntity(int key, World world, String category, String mobKey, String[] types, int[] weights, int totalWeight) {
        int choice = _SpecialMobs.random.nextInt(totalWeight);
        int i = weights.length;
        while (i-- > 0) {
            if ((choice -= weights[i]) >= 0) continue;
            if (i == 0) {
                return Properties.monsterVanilla()[key] ? null : (EntityLiving)EntityList.func_75620_a((String)("SpecialMobs.Special" + mobKey), (World)world);
            }
            return (EntityLiving)EntityList.func_75620_a((String)("SpecialMobs." + types[--i] + mobKey), (World)world);
        }
        _SpecialMobs.debugException("Weighting error: " + category + " (" + key + ")!");
        return null;
    }

    private static int[] buildTotalMonsterWeights() {
        int[] totalWeights = new int[_SpecialMobs.MONSTER_KEY.length];
        int[][] weights = Properties.monsterWeights();
        int i = weights.length;
        while (i-- > 0) {
            int j = weights[i].length;
            while (j-- > 0) {
                int n = i;
                totalWeights[n] = totalWeights[n] + weights[i][j];
            }
        }
        return totalWeights;
    }
}

