/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.TaskRetrieval;
import codechicken.nei.recipe.GuiCraftingRecipe;
import cpw.mods.fml.common.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class PanelTaskRetrieval
extends CanvasMinimum {
    private final TaskRetrieval task;
    private final IGuiRect initialRect;

    public PanelTaskRetrieval(IGuiRect rect, TaskRetrieval task) {
        super(rect);
        this.task = task;
        this.initialRect = rect;
    }

    public void initPanel() {
        super.initPanel();
        int listW = this.initialRect.getWidth();
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int[] progress = this.task.getUsersProgress(uuid);
        boolean isComplete = this.task.isComplete(uuid);
        String sCon = (this.task.consume ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + QuestTranslation.translate((String)(this.task.consume ? "gui.yes" : "gui.no"), (Object[])new Object[0]);
        this.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, 0, 0, listW, 16, 0), QuestTranslation.translate((String)"bq_standard.btn.consume", (Object[])new Object[]{sCon})).setColor(PresetColor.TEXT_MAIN.getColor()));
        for (int i = 0; i < this.task.requiredItems.size(); ++i) {
            BigItemStack stack = this.task.requiredItems.get(i);
            if (stack == null) continue;
            PanelItemSlot slot = new PanelItemSlot((IGuiRect)new GuiRectangle(0, i * 32 + 16, 28, 28, 0), -1, stack, false, true);
            if (BQ_Standard.hasNEI) {
                slot.setCallback(value -> this.lookupRecipe(value.getBaseStack()));
            }
            this.addPanel((IGuiPanel)slot);
            StringBuilder sb = new StringBuilder();
            sb.append(stack.getBaseStack().func_82833_r());
            if (stack.hasOreDict()) {
                sb.append(" (").append(stack.getOreDict()).append(")");
            }
            sb.append("\n").append(progress[i]).append("/").append(stack.stackSize).append("\n");
            if (isComplete || progress[i] >= stack.stackSize) {
                sb.append(EnumChatFormatting.GREEN).append(QuestTranslation.translate((String)"betterquesting.tooltip.complete", (Object[])new Object[0]));
            } else {
                sb.append(EnumChatFormatting.RED).append(QuestTranslation.translate((String)"betterquesting.tooltip.incomplete", (Object[])new Object[0]));
            }
            PanelTextBox text = new PanelTextBox((IGuiRect)new GuiRectangle(32, i * 32 + 16, listW - 28, 28, 0), sb.toString());
            text.setColor(PresetColor.TEXT_MAIN.getColor());
            this.addPanel((IGuiPanel)text);
        }
        this.recalcSizes();
    }

    @Optional.Method(modid="NotEnoughItems")
    private void lookupRecipe(ItemStack stack) {
        GuiCraftingRecipe.openRecipeGui((String)"item", (Object[])new Object[]{stack});
    }
}

