/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import bq_standard.client.gui.rewards.PanelRewardQuestCompletion;
import bq_standard.rewards.factory.FactoryRewardQuestCompletion;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class RewardQuestCompletion
implements IReward {
    public int questNum = -1;

    public ResourceLocation getFactoryID() {
        return FactoryRewardQuestCompletion.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.reward.questcompletion";
    }

    public boolean canClaim(EntityPlayer player, DBEntry<IQuest> quest) {
        return true;
    }

    public void claimReward(EntityPlayer player, DBEntry<IQuest> quest) {
        if (this.questNum == -1) {
            return;
        }
        IQuest targetQuest = (IQuest)((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getValue(this.questNum);
        if (targetQuest == null) {
            return;
        }
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (!targetQuest.isComplete(uuid)) {
            targetQuest.setComplete(uuid, System.currentTimeMillis());
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.questNum = nbt.func_74762_e("quest");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("quest", this.questNum);
        return nbt;
    }

    public IGuiPanel getRewardGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelRewardQuestCompletion(rect, this);
    }

    public GuiScreen getRewardEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }
}

