/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.OreIngredient;
import betterquesting.api2.utils.ParticipantInfo;
import bq_standard.client.gui.tasks.PanelTaskCrafting;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.ITaskItemInput;
import bq_standard.tasks.base.TaskProgressableBase;
import bq_standard.tasks.factory.FactoryTaskCrafting;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.IntSupplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class TaskCrafting
extends TaskProgressableBase<int[]>
implements ITaskItemInput {
    public final List<BigItemStack> requiredItems = new ArrayList<BigItemStack>();
    public boolean partialMatch = true;
    public boolean ignoreNBT = true;
    public boolean allowAnvil = false;
    public boolean allowSmelt = true;
    public boolean allowCraft = true;

    public void readFromNBT(NBTTagCompound nbt) {
        this.partialMatch = nbt.func_74767_n("partialMatch");
        this.ignoreNBT = nbt.func_74767_n("ignoreNBT");
        if (nbt.func_74764_b("allowCraft")) {
            this.allowCraft = nbt.func_74767_n("allowCraft");
        }
        if (nbt.func_74764_b("allowSmelt")) {
            this.allowSmelt = nbt.func_74767_n("allowSmelt");
        }
        if (nbt.func_74764_b("allowAnvil")) {
            this.allowAnvil = nbt.func_74767_n("allowAnvil");
        }
        this.requiredItems.clear();
        NBTTagList iList = nbt.func_150295_c("requiredItems", 10);
        for (int i = 0; i < iList.func_74745_c(); ++i) {
            this.requiredItems.add(JsonHelper.JsonToItemStack((NBTTagCompound)iList.func_150305_b(i)));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("partialMatch", this.partialMatch);
        nbt.func_74757_a("ignoreNBT", this.ignoreNBT);
        nbt.func_74757_a("allowCraft", this.allowCraft);
        nbt.func_74757_a("allowSmelt", this.allowSmelt);
        nbt.func_74757_a("allowAnvil", this.allowAnvil);
        NBTTagList itemArray = new NBTTagList();
        for (BigItemStack stack : this.requiredItems) {
            itemArray.func_74742_a((NBTBase)JsonHelper.ItemStackToJson((BigItemStack)stack, (NBTTagCompound)new NBTTagCompound()));
        }
        nbt.func_74782_a("requiredItems", (NBTBase)itemArray);
        return nbt;
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.crafting";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskCrafting.INSTANCE.getRegistryName();
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> context) {
        return new PanelTaskCrafting(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }

    @Override
    public int[] getUsersProgress(UUID uuid) {
        int[] progress = (int[])this.userProgress.get(uuid);
        return progress == null || progress.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : progress;
    }

    @Override
    public int[] readUserProgressFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("data", 9)) {
            int[] data = new int[this.requiredItems.size()];
            List dJson = NBTConverter.getTagList((NBTTagList)nbt.func_150295_c("data", 3));
            for (int i = 0; i < data.length && i < dJson.size(); ++i) {
                try {
                    data[i] = ((NBTBase.NBTPrimitive)dJson.get(i)).func_150287_d();
                    continue;
                }
                catch (Exception e) {
                    BQ_Standard.logger.log(Level.ERROR, "Incorrect task progress format", (Throwable)e);
                }
            }
            return data;
        }
        int[] data = nbt.func_74759_k("data");
        int[] progress = new int[this.requiredItems.size()];
        System.arraycopy(data, 0, progress, 0, Math.min(data.length, progress.length));
        return progress;
    }

    @Override
    public void writeUserProgressToNBT(NBTTagCompound nbt, int[] progress) {
        nbt.func_74783_a("data", progress);
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        pInfo.ALL_UUIDS.forEach(uuid -> {
            if (this.isComplete((UUID)uuid)) {
                return;
            }
            int[] tmp = this.getUsersProgress((UUID)uuid);
            for (int i = 0; i < this.requiredItems.size(); ++i) {
                BigItemStack rStack = this.requiredItems.get(i);
                if (tmp[i] >= rStack.stackSize) continue;
                return;
            }
            this.setComplete((UUID)uuid);
        });
        pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
    }

    public void onItemCraft(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack stack, IntSupplier realStackSizeSupplier) {
        if (!this.allowCraft) {
            return;
        }
        this.onItemInternal(pInfo, quest, stack, realStackSizeSupplier);
    }

    public void onItemSmelt(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack stack) {
        if (!this.allowSmelt) {
            return;
        }
        this.onItemInternal(pInfo, quest, stack);
    }

    public void onItemAnvil(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack stack) {
        if (!this.allowAnvil) {
            return;
        }
        this.onItemInternal(pInfo, quest, stack);
    }

    private void onItemInternal(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack stack) {
        this.onItemInternal(pInfo, quest, stack, null);
    }

    private void onItemInternal(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack stack, IntSupplier realStackSizeSupplier) {
        if (stack == null || stack.field_77994_a <= 0 && realStackSizeSupplier == null) {
            return;
        }
        List progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        boolean changed = false;
        int realStackSizeCache = realStackSizeSupplier == null ? Math.max(0, stack.field_77994_a) : -1;
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            int realStackSize;
            BigItemStack rStack = this.requiredItems.get(i);
            int index = i;
            if (!ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((OreIngredient)rStack.getOreIngredient(), (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
            if (realStackSizeCache < 0) {
                realStackSize = realStackSizeSupplier.getAsInt();
                if (realStackSize <= 0) {
                    return;
                }
                realStackSizeCache = realStackSize;
            } else {
                realStackSize = realStackSizeCache;
            }
            progress.stream().filter(e -> ((int[])e.func_76340_b())[index] < rStack.stackSize).forEach(e -> {
                ((int[])e.func_76340_b())[index] = Math.min(((int[])e.func_76340_b())[index] + realStackSize, rStack.stackSize);
            });
            changed = true;
        }
        if (changed) {
            this.setBulkProgress(progress);
            this.detect(pInfo, quest);
        }
    }

    public List<String> getTextsForSearch() {
        ArrayList<String> texts = new ArrayList<String>();
        for (BigItemStack bigStack : this.requiredItems) {
            ItemStack stack = bigStack.getBaseStack();
            texts.add(stack.func_82833_r());
            if (!bigStack.hasOreDict()) continue;
            texts.add(bigStack.getOreDict());
        }
        return texts;
    }

    @Override
    public List<BigItemStack> getItemInputs() {
        return this.requiredItems;
    }
}

