/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.IFluidTask;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.client.gui.tasks.PanelTaskFluid;
import bq_standard.tasks.ITaskInventory;
import bq_standard.tasks.base.TaskProgressableBase;
import bq_standard.tasks.factory.FactoryTaskFluid;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TaskFluid
extends TaskProgressableBase<int[]>
implements ITaskInventory,
IFluidTask,
IItemTask {
    public final List<FluidStack> requiredFluids = new ArrayList<FluidStack>();
    public boolean ignoreNbt = true;
    public boolean consume = true;
    public boolean groupDetect = false;
    public boolean autoConsume = false;

    public void readFromNBT(NBTTagCompound nbt) {
        this.ignoreNbt = nbt.func_74767_n("ignoreNBT");
        this.consume = nbt.func_74767_n("consume");
        this.groupDetect = nbt.func_74767_n("groupDetect");
        this.autoConsume = nbt.func_74767_n("autoConsume");
        this.requiredFluids.clear();
        NBTTagList fList = nbt.func_150295_c("requiredFluids", 10);
        for (int i = 0; i < fList.func_74745_c(); ++i) {
            this.requiredFluids.add(JsonHelper.JsonToFluidStack((NBTTagCompound)fList.func_150305_b(i)));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("ignoreNBT", this.ignoreNbt);
        nbt.func_74757_a("consume", this.consume);
        nbt.func_74757_a("groupDetect", this.groupDetect);
        nbt.func_74757_a("autoConsume", this.autoConsume);
        NBTTagList itemArray = new NBTTagList();
        for (FluidStack stack : this.requiredFluids) {
            itemArray.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("requiredFluids", (NBTBase)itemArray);
        return nbt;
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.fluid";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskFluid.INSTANCE.getRegistryName();
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskFluid(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }

    @Override
    public int[] getUsersProgress(UUID uuid) {
        int[] progress = (int[])this.userProgress.get(uuid);
        return progress == null || progress.length != this.requiredFluids.size() ? new int[this.requiredFluids.size()] : progress;
    }

    @Override
    public int[] readUserProgressFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("data", 9)) {
            int[] data = new int[this.requiredFluids.size()];
            List dNbt = NBTConverter.getTagList((NBTTagList)nbt.func_150295_c("data", 3));
            for (int i = 0; i < data.length && i < dNbt.size(); ++i) {
                data[i] = ((NBTBase.NBTPrimitive)dNbt.get(i)).func_150287_d();
            }
            return data;
        }
        int[] data = nbt.func_74759_k("data");
        int[] progress = new int[this.requiredFluids.size()];
        System.arraycopy(data, 0, progress, 0, Math.min(data.length, progress.length));
        return progress;
    }

    @Override
    public void writeUserProgressToNBT(NBTTagCompound nbt, int[] progress) {
        nbt.func_74783_a("data", progress);
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        List<Object> invoList;
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        Detector detector = new Detector(this, this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        if (this.consume) {
            invoList = Collections.singletonList(pInfo.PLAYER.field_71071_by);
        } else {
            invoList = new ArrayList();
            pInfo.ACTIVE_PLAYERS.forEach(p -> invoList.add(p.field_71071_by));
        }
        for (InventoryPlayer inventoryPlayer : invoList) {
            IntStream.range(0, inventoryPlayer.func_70302_i_()).forEachOrdered(i -> {
                ItemStack stack = invo.func_70301_a(i);
                detector.run(stack, (drain, drainAmount) -> TaskFluid.getFluid(invo, i, drain, drainAmount));
            });
        }
        if (detector.updated) {
            this.setBulkProgress(detector.progress);
        }
        this.checkAndComplete(pInfo, quest, detector.updated);
    }

    private void checkAndComplete(ParticipantInfo pInfo, DBEntry<IQuest> quest, boolean resync) {
        List<Tuple2<UUID, Tuple2>> progress = this.getBulkProgress(this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        boolean updated = resync;
        block0: for (Tuple2 tuple2 : progress) {
            for (int j = 0; j < this.requiredFluids.size(); ++j) {
                if (((int[])tuple2.func_76340_b())[j] < this.requiredFluids.get((int)j).amount) continue block0;
            }
            updated = true;
            if (this.consume) {
                this.setComplete((UUID)tuple2.func_76341_a());
                continue;
            }
            progress.forEach(pair -> this.setComplete((UUID)pair.func_76341_a()));
            break;
        }
        if (updated) {
            if (this.consume) {
                pInfo.markDirty(Collections.singletonList(quest.getID()));
            } else {
                pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
            }
        }
    }

    private static FluidStack getFluid(InventoryPlayer invo, int slot, boolean drain, int amount) {
        ItemStack stack = invo.func_70301_a(slot);
        if (stack == null || stack.field_77994_a <= 0 || amount <= 0) {
            return null;
        }
        if ((stack = stack.func_77946_l()).func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)stack.func_77973_b();
            if (fluidContainerItem.getFluid(stack) == null) {
                return null;
            }
            FluidStack fluid = fluidContainerItem.getFluid(stack).copy();
            fluid.amount = 0;
            while (0 < stack.field_77994_a && 0 < amount) {
                ItemStack oneSizedStack = stack.func_77946_l();
                oneSizedStack.field_77994_a = 1;
                FluidStack removed = fluidContainerItem.drain(oneSizedStack, amount, drain);
                if (removed == null || 0 >= removed.amount) break;
                fluid.amount += removed.amount;
                amount -= removed.amount;
                --stack.field_77994_a;
                if (!drain) continue;
                invo.func_70298_a(slot, 1);
                if (invo.func_70441_a(oneSizedStack)) continue;
                invo.field_70458_d.func_71019_a(oneSizedStack, false);
            }
            return fluid;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        int unitFluidAmount = fluid.amount;
        int emptyContainerCount = 1;
        while (fluid.amount < amount && emptyContainerCount < stack.field_77994_a) {
            ++emptyContainerCount;
            fluid.amount += unitFluidAmount;
        }
        if (drain) {
            while (emptyContainerCount > 0) {
                ItemStack emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)stack);
                invo.func_70298_a(slot, 1);
                if (!invo.func_70441_a(emptyContainer)) {
                    invo.field_70458_d.func_71019_a(emptyContainer, false);
                }
                --emptyContainerCount;
            }
        }
        return fluid;
    }

    public boolean canAcceptFluid(UUID owner, DBEntry<IQuest> quest, FluidStack fluid) {
        if (owner == null || fluid == null || fluid.getFluid() == null || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return false;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = this.requiredFluids.get(j).copy();
            if (this.ignoreNbt) {
                rStack.tag = null;
            }
            if (progress[j] >= rStack.amount || !rStack.equals((Object)fluid)) continue;
            return true;
        }
        return false;
    }

    public FluidStack submitFluid(UUID owner, DBEntry<IQuest> quest, FluidStack input) {
        if (owner == null || input == null || input.amount <= 0 || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return input;
        }
        Detector detector = new Detector(this, Collections.singletonList(owner));
        FluidStack fluid = input.copy();
        detector.run(fluid, remaining -> {
            int removed = Math.min(fluid.amount, remaining);
            FluidStack removedFluid = fluid.copy();
            removedFluid.amount = removed;
            fluid.amount -= removed;
            return removedFluid;
        });
        if (detector.updated) {
            this.setBulkProgress(detector.progress);
        }
        return 0 < fluid.amount ? fluid : null;
    }

    public void retrieveFluids(ParticipantInfo pInfo, DBEntry<IQuest> quest, FluidStack[] fluids) {
        if (this.consume || this.isComplete(pInfo.UUID)) {
            return;
        }
        Detector detector = new Detector(this, this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        for (FluidStack fluid : fluids) {
            detector.run(fluid, remaining -> null);
        }
        if (detector.updated) {
            this.setBulkProgress(detector.progress);
        }
        this.checkAndComplete(pInfo, quest, detector.updated);
    }

    public boolean canAcceptItem(UUID owner, DBEntry<IQuest> quest, ItemStack item) {
        if (owner == null || item == null || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return false;
        }
        if (item.func_77973_b() instanceof IFluidContainerItem) {
            return this.canAcceptFluid(owner, quest, ((IFluidContainerItem)item.func_77973_b()).getFluid(item));
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)item)) {
            return this.canAcceptFluid(owner, quest, FluidContainerRegistry.getFluidForFilledItem((ItemStack)item));
        }
        return false;
    }

    public ItemStack submitItem(UUID owner, DBEntry<IQuest> quest, ItemStack input) {
        if (owner == null || input == null || input.field_77994_a != 1 || !this.consume || this.isComplete(owner)) {
            return input;
        }
        Detector detector = new Detector(this, Collections.singletonList(owner));
        ItemStack[] wrapper = new ItemStack[]{input.func_77946_l()};
        detector.run(wrapper[0], (drain, drainAmount) -> {
            if (wrapper[0].func_77973_b() instanceof IFluidContainerItem) {
                return ((IFluidContainerItem)wrapper[0].func_77973_b()).drain(wrapper[0], drainAmount.intValue(), drain.booleanValue());
            }
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)wrapper[0]);
            if (drain.booleanValue() && fluid != null) {
                wrapper[0] = FluidContainerRegistry.drainFluidContainer((ItemStack)wrapper[0]);
            }
            return fluid;
        });
        if (detector.updated) {
            this.setBulkProgress(detector.progress);
        }
        return wrapper[0];
    }

    public void retrieveItems(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack[] stacks) {
        if (this.consume || this.isComplete(pInfo.UUID)) {
            return;
        }
        Detector detector = new Detector(this, this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        IntStream.range(0, stacks.length).forEachOrdered(i -> {
            ItemStack stack = stacks[i];
            detector.run(stack, (drain, drainAmount) -> {
                FluidStack fluid;
                if (stack.func_77973_b() instanceof IFluidContainerItem) {
                    ItemStack oneSizedStack = stack.func_77946_l();
                    fluid = ((IFluidContainerItem)stack.func_77973_b()).getFluid(oneSizedStack);
                } else {
                    fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                }
                if (fluid == null) {
                    return null;
                }
                int unitFluidAmount = fluid.amount;
                int stackSize = stack.field_77994_a;
                for (int j = 0; j < stackSize && drainAmount > fluid.amount; ++j) {
                    fluid.amount += Math.min(drainAmount - fluid.amount, unitFluidAmount);
                }
                return fluid;
            });
        });
        if (detector.updated) {
            this.setBulkProgress(detector.progress);
        }
        this.checkAndComplete(pInfo, quest, detector.updated);
    }

    @Override
    public void onInventoryChange(@Nonnull DBEntry<IQuest> quest, @Nonnull ParticipantInfo pInfo) {
        if (!this.consume || this.autoConsume) {
            this.detect(pInfo, quest);
        }
    }

    static class Detector {
        public boolean updated = false;
        public final TaskFluid task;
        public final List<Tuple2<UUID, int[]>> progress;

        public Detector(TaskFluid task, @Nonnull List<UUID> uuids) {
            this.task = task;
            this.progress = task.getBulkProgress(uuids);
            if (!task.consume) {
                if (task.groupDetect) {
                    this.progress.forEach(value -> Arrays.fill((int[])value.func_76340_b(), 0));
                } else {
                    for (int i = 0; i < task.requiredFluids.size(); ++i) {
                        int r = task.requiredFluids.get((int)i).amount;
                        for (Tuple2<UUID, int[]> value2 : this.progress) {
                            int n = ((int[])value2.func_76340_b())[i];
                            if (n == 0 || n >= r) continue;
                            ((int[])value2.func_76340_b())[i] = 0;
                            this.updated = true;
                        }
                    }
                }
            }
        }

        public void run(ItemStack stack, BiFunction<Boolean, Integer, FluidStack> fluidGetter) {
            if (stack == null || stack.field_77994_a <= 0) {
                return;
            }
            if (!(stack.func_77973_b() instanceof IFluidContainerItem) && !FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                return;
            }
            for (int i = 0; i < this.task.requiredFluids.size(); ++i) {
                FluidStack sample;
                FluidStack rStack = this.task.requiredFluids.get(i);
                FluidStack drainOG = rStack.copy();
                if (this.task.ignoreNbt) {
                    drainOG.tag = null;
                }
                if (!drainOG.isFluidEqual(sample = fluidGetter.apply(false, drainOG.amount))) continue;
                for (Tuple2<UUID, int[]> value : this.progress) {
                    FluidStack fluid;
                    if (((int[])value.func_76340_b())[i] >= rStack.amount) continue;
                    int remaining = rStack.amount - ((int[])value.func_76340_b())[i];
                    FluidStack drain = rStack.copy();
                    drain.amount = remaining;
                    if (this.task.ignoreNbt) {
                        drain.tag = null;
                    }
                    if (drain.amount <= 0 || (fluid = fluidGetter.apply(this.task.consume, drain.amount)) == null || fluid.amount <= 0) continue;
                    int[] nArray = (int[])value.func_76340_b();
                    int n = i;
                    nArray[n] = nArray[n] + fluid.amount;
                    this.updated = true;
                }
            }
        }

        public void run(FluidStack fluid, IntFunction<FluidStack> consumer) {
            if (fluid == null || fluid.amount <= 0) {
                return;
            }
            for (int i = 0; i < this.task.requiredFluids.size(); ++i) {
                FluidStack rStack = this.task.requiredFluids.get(i);
                FluidStack drainOG = rStack.copy();
                if (this.task.ignoreNbt) {
                    drainOG.tag = null;
                }
                if (!drainOG.isFluidEqual(fluid)) continue;
                for (Tuple2<UUID, int[]> value : this.progress) {
                    if (((int[])value.func_76340_b())[i] >= rStack.amount) continue;
                    int remaining = rStack.amount - ((int[])value.func_76340_b())[i];
                    if (this.task.consume) {
                        FluidStack removed = consumer.apply(remaining);
                        if (removed == null || removed.amount <= 0) continue;
                        int[] nArray = (int[])value.func_76340_b();
                        int n = i;
                        nArray[n] = nArray[n] + removed.amount;
                        this.updated = true;
                        continue;
                    }
                    FluidStack drain = rStack.copy();
                    drain.amount = remaining;
                    if (this.task.ignoreNbt) {
                        drain.tag = null;
                    }
                    if (drain.amount <= 0) continue;
                    FluidStack tFluid = fluid.copy();
                    tFluid.amount = Math.min(tFluid.amount, drain.amount);
                    if (tFluid.amount <= 0) continue;
                    int[] nArray = (int[])value.func_76340_b();
                    int n = i;
                    nArray[n] = nArray[n] + tFluid.amount;
                    this.updated = true;
                }
            }
        }
    }
}

