/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_standard.client.gui.editors.tasks.GuiEditTaskMeeting;
import bq_standard.client.gui.tasks.PanelTaskMeeting;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.base.TaskBase;
import bq_standard.tasks.factory.FactoryTaskMeeting;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class TaskMeeting
extends TaskBase
implements ITaskTickable {
    public String idName = "Villager";
    public int range = 4;
    public int amount = 1;
    public boolean ignoreNBT = true;
    public boolean subtypes = true;
    public NBTTagCompound targetTags = new NBTTagCompound();

    public void readFromNBT(NBTTagCompound json) {
        this.idName = json.func_150297_b("target", 8) ? json.func_74779_i("target") : "Villager";
        this.range = json.func_74762_e("range");
        this.amount = json.func_74762_e("amount");
        this.subtypes = json.func_74767_n("subtypes");
        this.ignoreNBT = json.func_74767_n("ignoreNBT");
        this.targetTags = json.func_74775_l("targetNBT");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74778_a("target", this.idName);
        json.func_74768_a("range", this.range);
        json.func_74768_a("amount", this.amount);
        json.func_74757_a("subtypes", this.subtypes);
        json.func_74757_a("ignoreNBT", this.ignoreNBT);
        json.func_74782_a("targetNBT", (NBTBase)this.targetTags);
        return json;
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.meeting";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskMeeting.INSTANCE.getRegistryName();
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return new GuiEditTaskMeeting(parent, quest, this);
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskMeeting(rect, this);
    }

    public void detect(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (!pInfo.PLAYER.func_70089_S()) {
            return;
        }
        List list = pInfo.PLAYER.field_70170_p.func_72839_b((Entity)pInfo.PLAYER, pInfo.PLAYER.field_70121_D.func_72314_b((double)this.range, (double)this.range, (double)this.range));
        Class target = (Class)EntityList.field_75625_b.get(this.idName);
        if (target == null) {
            return;
        }
        int n = 0;
        for (Entity entity : list) {
            Class<?> subject = entity.getClass();
            String subjectID = EntityList.func_75621_b((Entity)entity);
            if (subjectID == null || this.subtypes && !target.isAssignableFrom(subject) || !this.subtypes && !subjectID.equals(this.idName)) continue;
            if (!this.ignoreNBT) {
                NBTTagCompound subjectTags = new NBTTagCompound();
                entity.func_70039_c(subjectTags);
                if (!ItemComparison.CompareNBTTag((NBTBase)this.targetTags, (NBTBase)subjectTags, (boolean)true)) continue;
            }
            if (++n < this.amount) continue;
            pInfo.ALL_UUIDS.forEach(uuid -> {
                if (!this.isComplete((UUID)uuid)) {
                    this.setComplete((UUID)uuid);
                }
            });
            pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
            return;
        }
    }

    @Override
    public void tickTask(@Nonnull ParticipantInfo pInfo, @Nonnull DBEntry<IQuest> quest) {
        if (pInfo.PLAYER.field_70173_aa % 60 == 0) {
            this.detect(pInfo, quest);
        }
    }

    public List<String> getTextsForSearch() {
        return Collections.singletonList(this.idName);
    }
}

