/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_standard.XPHelper;
import bq_standard.client.gui.tasks.PanelTaskXP;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.base.TaskProgressableBase;
import bq_standard.tasks.factory.FactoryTaskXP;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class TaskXP
extends TaskProgressableBase<Long>
implements ITaskTickable {
    public boolean levels = true;
    public int amount = 30;
    public boolean consume = true;

    public void readFromNBT(NBTTagCompound nbt) {
        this.amount = nbt.func_150297_b("amount", 99) ? nbt.func_74762_e("amount") : 30;
        this.levels = nbt.func_74767_n("isLevels");
        this.consume = nbt.func_74767_n("consume");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("amount", this.amount);
        nbt.func_74757_a("isLevels", this.levels);
        nbt.func_74757_a("consume", this.consume);
        return nbt;
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.xp";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskXP.INSTANCE.getRegistryName();
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskXP(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }

    @Override
    public Long getUsersProgress(UUID uuid) {
        Long n = (Long)this.userProgress.get(uuid);
        return n == null ? 0L : n;
    }

    @Override
    public Long readUserProgressFromNBT(NBTTagCompound nbt) {
        return nbt.func_74763_f("value");
    }

    @Override
    public void writeUserProgressToNBT(NBTTagCompound nbt, Long progress) {
        nbt.func_74772_a("value", progress.longValue());
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        long progress = this.getUsersProgress(pInfo.UUID);
        long rawXP = this.levels ? XPHelper.getLevelXP(this.amount) : (long)this.amount;
        long plrXP = XPHelper.getPlayerXP(pInfo.PLAYER);
        long remaining = rawXP - progress;
        long cost = Math.min(remaining, plrXP);
        boolean changed = false;
        if (this.consume && cost != 0L) {
            this.setUserProgress(pInfo.UUID, progress += cost);
            XPHelper.addXP(pInfo.PLAYER, -cost);
            changed = true;
        } else if (!this.consume && progress != plrXP) {
            this.setUserProgress(pInfo.UUID, plrXP);
            changed = true;
        }
        long totalXP = this.getUsersProgress(pInfo.UUID);
        if (totalXP >= rawXP) {
            this.setComplete(pInfo.UUID);
            changed = true;
        }
        if (changed) {
            pInfo.markDirty(Collections.singletonList(quest.getID()));
        }
    }

    @Override
    public void tickTask(@Nonnull ParticipantInfo pInfo, @Nonnull DBEntry<IQuest> quest) {
        long nxtProg;
        if (this.consume || pInfo.PLAYER.field_70173_aa % 60 != 0) {
            return;
        }
        long curProg = this.getUsersProgress(pInfo.UUID);
        if (curProg != (nxtProg = XPHelper.getPlayerXP(pInfo.PLAYER))) {
            this.setUserProgress(pInfo.UUID, XPHelper.getPlayerXP(pInfo.PLAYER));
            pInfo.markDirty(Collections.singletonList(quest.getID()));
        }
        long rawXP = this.levels ? XPHelper.getLevelXP(this.amount) : (long)this.amount;
        long totalXP = this.getUsersProgress(pInfo.UUID);
        if (totalXP >= rawXP) {
            this.setComplete(pInfo.UUID);
        }
    }
}

