/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks.base;

import betterquesting.api2.utils.DirtyPlayerMarker;
import betterquesting.api2.utils.Tuple2;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.base.TaskBase;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.Level;

public abstract class TaskProgressableBase<T>
extends TaskBase {
    protected final TreeMap<UUID, T> userProgress = new TreeMap();

    protected void setUserProgress(UUID uuid, T progress) {
        this.userProgress.put(uuid, progress);
        DirtyPlayerMarker.markDirty((UUID)uuid);
    }

    public abstract T getUsersProgress(UUID var1);

    @Override
    public void resetUser(@Nullable UUID uuid) {
        HashSet<UUID> dirtyPlayers = new HashSet<UUID>();
        if (uuid == null) {
            dirtyPlayers.addAll(this.completeUsers);
            dirtyPlayers.addAll(this.userProgress.keySet());
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            if (this.completeUsers.remove(uuid)) {
                dirtyPlayers.add(uuid);
            }
            if (this.userProgress.containsKey(uuid)) {
                this.userProgress.remove(uuid);
                dirtyPlayers.add(uuid);
            }
        }
        DirtyPlayerMarker.markDirty(dirtyPlayers);
    }

    protected List<Tuple2<UUID, T>> getBulkProgress(@Nonnull List<UUID> uuids) {
        return uuids.stream().map(uuid -> new Tuple2(uuid, this.getUsersProgress((UUID)uuid))).collect(Collectors.toList());
    }

    protected void setBulkProgress(@Nonnull List<Tuple2<UUID, T>> ProgressList) {
        ProgressList.forEach(entry -> this.setUserProgress((UUID)entry.func_76341_a(), entry.func_76340_b()));
    }

    public abstract T readUserProgressFromNBT(NBTTagCompound var1);

    public abstract void writeUserProgressToNBT(NBTTagCompound var1, T var2);

    @Override
    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        super.readProgressFromNBT(nbt, merge);
        if (!merge) {
            this.userProgress.clear();
        }
        NBTTagList ProgressNBTList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < ProgressNBTList.func_74745_c(); ++n) {
            try {
                NBTTagCompound progressNBT = ProgressNBTList.func_150305_b(n);
                UUID uuid = UUID.fromString(progressNBT.func_74779_i("uuid"));
                T progress = this.readUserProgressFromNBT(progressNBT);
                this.userProgress.put(uuid, progress);
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        super.writeProgressToNBT(nbt, users);
        NBTTagList ProgressNBTList = new NBTTagList();
        this.userProgress.forEach((uuid, progress) -> {
            if (users == null || users.contains(uuid)) {
                NBTTagCompound progressNBT = new NBTTagCompound();
                progressNBT.func_74778_a("uuid", uuid.toString());
                this.writeUserProgressToNBT(progressNBT, progress);
                ProgressNBTList.func_74742_a((NBTBase)progressNBT);
            }
        });
        nbt.func_74782_a("userProgress", (NBTBase)ProgressNBTList);
        return nbt;
    }
}

