/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.OreIngredient;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.client.gui.tasks.PanelTaskRetrieval;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.ITaskInventory;
import bq_standard.tasks.factory.FactoryTaskRetrieval;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class TaskRetrieval
implements ITaskInventory,
IItemTask {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public final List<BigItemStack> requiredItems = new ArrayList<BigItemStack>();
    private final TreeMap<UUID, int[]> userProgress = new TreeMap();
    public boolean partialMatch = true;
    public boolean ignoreNBT = true;
    public boolean consume = false;
    public boolean groupDetect = false;
    public boolean autoConsume = false;

    public String getUnlocalisedName() {
        return "bq_standard.task.retrieval";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskRetrieval.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    @Override
    public void onInventoryChange(@Nonnull DBEntry<IQuest> quest, @Nonnull ParticipantInfo pInfo) {
        if (!this.consume || this.autoConsume) {
            this.detect(pInfo, quest);
        }
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        List<Object> invoList;
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        List<Tuple2<UUID, int[]>> progress = this.getBulkProgress(this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        boolean updated = false;
        if (!this.consume) {
            if (this.groupDetect) {
                progress.forEach(value -> Arrays.fill((int[])value.func_76340_b(), 0));
            } else {
                for (int i = 0; i < this.requiredItems.size(); ++i) {
                    int r = this.requiredItems.get((int)i).stackSize;
                    for (Tuple2<UUID, int[]> value2 : progress) {
                        int n = ((int[])value2.func_76340_b())[i];
                        if (n == 0 || n >= r) continue;
                        ((int[])value2.func_76340_b())[i] = 0;
                        updated = true;
                    }
                }
            }
        }
        if (this.consume) {
            invoList = Collections.singletonList(pInfo.PLAYER.field_71071_by);
        } else {
            invoList = new ArrayList();
            pInfo.ACTIVE_PLAYERS.forEach(p -> invoList.add(p.field_71071_by));
        }
        for (InventoryPlayer inventoryPlayer : invoList) {
            for (int i = 0; i < inventoryPlayer.func_70302_i_(); ++i) {
                ItemStack stack = inventoryPlayer.func_70301_a(i);
                if (stack == null || stack.field_77994_a <= 0) continue;
                int[] remCounts = new int[progress.size()];
                Arrays.fill(remCounts, stack.field_77994_a);
                for (int j = 0; j < this.requiredItems.size(); ++j) {
                    BigItemStack rStack = this.requiredItems.get(j);
                    if (!ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((OreIngredient)rStack.getOreIngredient(), (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
                    for (int n = 0; n < progress.size(); ++n) {
                        Tuple2<UUID, int[]> value3 = progress.get(n);
                        if (((int[])value3.func_76340_b())[j] >= rStack.stackSize) continue;
                        int remaining = rStack.stackSize - ((int[])value3.func_76340_b())[j];
                        if (this.consume) {
                            ItemStack removed = inventoryPlayer.func_70298_a(i, remaining);
                            int[] nArray = (int[])value3.func_76340_b();
                            int n2 = j;
                            nArray[n2] = nArray[n2] + removed.field_77994_a;
                        } else {
                            int temp = Math.min(remaining, remCounts[n]);
                            int n3 = n;
                            remCounts[n3] = remCounts[n3] - temp;
                            int[] nArray = (int[])value3.func_76340_b();
                            int n4 = j;
                            nArray[n4] = nArray[n4] + temp;
                        }
                        updated = true;
                    }
                }
            }
        }
        if (updated) {
            this.setBulkProgress(progress);
        }
        this.checkAndComplete(pInfo, quest, updated);
    }

    private void checkAndComplete(ParticipantInfo pInfo, DBEntry<IQuest> quest, boolean resync) {
        List<Tuple2<UUID, int[]>> progress = this.getBulkProgress(this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        boolean updated = resync;
        block0: for (Tuple2<UUID, int[]> value : progress) {
            for (int j = 0; j < this.requiredItems.size(); ++j) {
                if (((int[])value.func_76340_b())[j] < this.requiredItems.get((int)j).stackSize) continue block0;
            }
            updated = true;
            if (this.consume) {
                this.setComplete((UUID)value.func_76341_a());
                continue;
            }
            progress.forEach(pair -> this.setComplete((UUID)pair.func_76341_a()));
            break;
        }
        if (updated) {
            if (this.consume) {
                pInfo.markDirty(Collections.singletonList(quest.getID()));
            } else {
                pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("partialMatch", this.partialMatch);
        nbt.func_74757_a("ignoreNBT", this.ignoreNBT);
        nbt.func_74757_a("consume", this.consume);
        nbt.func_74757_a("groupDetect", this.groupDetect);
        nbt.func_74757_a("autoConsume", this.autoConsume);
        NBTTagList itemArray = new NBTTagList();
        for (BigItemStack stack : this.requiredItems) {
            itemArray.func_74742_a((NBTBase)JsonHelper.ItemStackToJson((BigItemStack)stack, (NBTTagCompound)new NBTTagCompound()));
        }
        nbt.func_74782_a("requiredItems", (NBTBase)itemArray);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.partialMatch = nbt.func_74767_n("partialMatch");
        this.ignoreNBT = nbt.func_74767_n("ignoreNBT");
        this.consume = nbt.func_74767_n("consume");
        this.groupDetect = nbt.func_74767_n("groupDetect");
        this.autoConsume = nbt.func_74767_n("autoConsume");
        this.requiredItems.clear();
        NBTTagList iList = nbt.func_150295_c("requiredItems", 10);
        for (int i = 0; i < iList.func_74745_c(); ++i) {
            this.requiredItems.add(JsonHelper.JsonToItemStack((NBTTagCompound)iList.func_150305_b(i)));
        }
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                int[] data = new int[this.requiredItems.size()];
                List dNbt = NBTConverter.getTagList((NBTTagList)pTag.func_150295_c("data", 3));
                for (int i = 0; i < data.length && i < dNbt.size(); ++i) {
                    data[i] = ((NBTBase.NBTPrimitive)dNbt.get(i)).func_150287_d();
                }
                this.userProgress.put(uuid, data);
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                int[] data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    NBTTagList pArray = new NBTTagList();
                    for (int i : data) {
                        pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                    }
                    pJson.func_74782_a("data", (NBTBase)pArray);
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                NBTTagList pArray = new NBTTagList();
                for (int i : data) {
                    pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                }
                pJson.func_74782_a("data", (NBTBase)pArray);
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskRetrieval(rect, this);
    }

    public boolean canAcceptItem(UUID owner, DBEntry<IQuest> quest, ItemStack stack) {
        if (owner == null || stack == null || stack.field_77994_a <= 0 || !this.consume || this.isComplete(owner) || this.requiredItems.size() <= 0) {
            return false;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredItems.size(); ++j) {
            BigItemStack rStack = this.requiredItems.get(j);
            if (progress[j] >= rStack.stackSize || !ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((OreIngredient)rStack.getOreIngredient(), (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
            return true;
        }
        return false;
    }

    public ItemStack submitItem(UUID owner, DBEntry<IQuest> quest, ItemStack input) {
        if (owner == null || input == null || !this.consume || this.isComplete(owner)) {
            return input;
        }
        ItemStack stack = input.func_77946_l();
        int[] progress = this.getUsersProgress(owner);
        boolean updated = false;
        for (int j = 0; j < this.requiredItems.size(); ++j) {
            BigItemStack rStack = this.requiredItems.get(j);
            if (progress[j] >= rStack.stackSize) continue;
            int remaining = rStack.stackSize - progress[j];
            if (!ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((OreIngredient)rStack.getOreIngredient(), (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
            int removed = Math.min(stack.field_77994_a, remaining);
            stack.field_77994_a -= removed;
            int n = j;
            progress[n] = progress[n] + removed;
            updated = true;
            if (stack.field_77994_a > 0) continue;
            stack = null;
            break;
        }
        if (updated) {
            this.setUserProgress(owner, progress);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }

    private void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID uuid) {
        int[] progress = this.userProgress.get(uuid);
        return progress == null || progress.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : progress;
    }

    private List<Tuple2<UUID, int[]>> getBulkProgress(@Nonnull List<UUID> uuids) {
        if (uuids.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Tuple2<UUID, int[]>> list = new ArrayList<Tuple2<UUID, int[]>>();
        uuids.forEach(key -> list.add(new Tuple2(key, (Object)this.getUsersProgress((UUID)key))));
        return list;
    }

    private void setBulkProgress(@Nonnull List<Tuple2<UUID, int[]>> list) {
        list.forEach(entry -> this.setUserProgress((UUID)entry.func_76341_a(), (int[])entry.func_76340_b()));
    }
}

