/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.commands;

import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import bq_standard.network.handlers.NetLootSync;
import bq_standard.rewards.loot.LootRegistry;
import com.google.gson.JsonObject;
import java.io.File;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class BQS_Commands
extends CommandBase {
    public String func_71517_b() {
        return "bqs_loot";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bqs_loot default [save|load], /bqs_loot delete [all|<loot_id>]";
    }

    public int func_82362_a() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args[0].equalsIgnoreCase("default")) {
            if (args[1].equalsIgnoreCase("save")) {
                NBTTagCompound jsonQ = new NBTTagCompound();
                LootRegistry.INSTANCE.writeToNBT(jsonQ, null);
                JsonHelper.WriteToFile((File)new File(MinecraftServer.func_71276_C().func_71209_f("config/betterquesting/"), "DefaultLoot.json"), (JsonObject)NBTConverter.NBTtoJSON_Compound((NBTTagCompound)jsonQ, (JsonObject)new JsonObject(), (boolean)true));
                sender.func_145747_a((IChatComponent)new ChatComponentText("Loot database set as global default"));
                return;
            } else {
                if (!args[1].equalsIgnoreCase("load")) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                File f1 = new File("config/betterquesting/DefaultLoot.json");
                if (f1.exists()) {
                    NBTTagCompound j1 = NBTConverter.JSONtoNBT_Object((JsonObject)JsonHelper.ReadFromFile((File)f1), (NBTTagCompound)new NBTTagCompound(), (boolean)true);
                    LootRegistry.INSTANCE.readFromNBT(j1, false);
                    NetLootSync.sendSync(null);
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Reloaded default loot database"));
                    return;
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "No default loot currently set"));
                }
            }
            return;
        }
        if (!args[0].equalsIgnoreCase("delete")) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        if (args[1].equalsIgnoreCase("all")) {
            LootRegistry.INSTANCE.reset();
            NetLootSync.sendSync(null);
            sender.func_145747_a((IChatComponent)new ChatComponentText("Deleted all loot groups"));
            return;
        }
        try {
            int idx = Integer.parseInt(args[1]);
            if (LootRegistry.INSTANCE.removeID(idx)) {
                NetLootSync.sendSync(null);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Deleted loot group with ID " + idx));
                return;
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Unable to find loot group with ID " + idx));
            }
            return;
        }
        catch (Exception e) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }
}

