/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.handlers;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.events.BQLivingUpdateEvent;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_standard.handlers.ConfigHandler;
import bq_standard.handlers.LootSaveLoad;
import bq_standard.handlers.PlayerContainerListener;
import bq_standard.network.handlers.NetLootSync;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.TaskBlockBreak;
import bq_standard.tasks.TaskCrafting;
import bq_standard.tasks.TaskHunt;
import bq_standard.tasks.TaskInteractEntity;
import bq_standard.tasks.TaskInteractItem;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.Validate;

public class EventHandler {
    private static final ArrayDeque<FutureTask> serverTasks = new ArrayDeque();
    private static Thread serverThread = null;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.entityPlayer == null || event.entityPlayer instanceof FakePlayer || event.entityPlayer.field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ParticipantInfo pInfo = new ParticipantInfo(player);
        Block block = player.field_70170_p.func_147439_a(event.x, event.y, event.z);
        int meta = player.field_70170_p.func_72805_g(event.x, event.y, event.z);
        boolean isHit = event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK;
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractItem)) continue;
                ((TaskInteractItem)task.getValue()).onInteract(pInfo, (DBEntry<IQuest>)entry, player.func_70694_bm(), block, meta, event.x, event.y, event.z, isHit);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityAttack(AttackEntityEvent event) {
        if (event.entityPlayer == null || event.entityPlayer instanceof FakePlayer || event.target == null || event.entityPlayer.field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ParticipantInfo pInfo = new ParticipantInfo(player);
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractEntity)) continue;
                ((TaskInteractEntity)task.getValue()).onInteract(pInfo, (DBEntry<IQuest>)entry, player.func_70694_bm(), event.target, true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.entityPlayer == null || event.entityPlayer instanceof FakePlayer || event.target == null || event.entityPlayer.field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ParticipantInfo pInfo = new ParticipantInfo(player);
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractEntity)) continue;
                ((TaskInteractEntity)task.getValue()).onInteract(pInfo, (DBEntry<IQuest>)entry, player.func_70694_bm(), event.target, false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result;
        if (event.player == null || event.player instanceof FakePlayer || event.player.field_70170_p.field_72995_K) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo(event.player);
        ItemStack refStack = event.crafting.func_77946_l();
        if (event.craftMatrix instanceof InventoryCrafting && (result = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)event.craftMatrix, event.player.field_70170_p)) != null) {
            refStack.field_77994_a = result.field_77994_a;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemCraft(pInfo, (DBEntry<IQuest>)entry, refStack);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player == null || event.player instanceof FakePlayer || event.player.field_70170_p.field_72995_K) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo(event.player);
        ItemStack refStack = event.smelting.func_77946_l();
        if (refStack.field_77994_a <= 0) {
            refStack.field_77994_a = 1;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemSmelt(pInfo, (DBEntry<IQuest>)entry, refStack);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemAnvil(AnvilRepairEvent event) {
        if (event.entityPlayer == null || event.entityPlayer instanceof FakePlayer || event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo(event.entityPlayer);
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemAnvil(pInfo, (DBEntry<IQuest>)entry, event.output.func_77946_l());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityKilled(LivingDeathEvent event) {
        if (event.source == null || !(event.source.func_76346_g() instanceof EntityPlayer) || event.source.func_76346_g() instanceof FakePlayer || event.source.func_76346_g().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
        ParticipantInfo pInfo = new ParticipantInfo(player);
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskHunt)) continue;
                ((TaskHunt)task.getValue()).onKilledByPlayer(pInfo, (DBEntry<IQuest>)entry, event.entityLiving, event.source);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null || event.getPlayer() instanceof FakePlayer || event.getPlayer().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo(event.getPlayer());
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskBlockBreak)) continue;
                ((TaskBlockBreak)task.getValue()).onBlockBreak(pInfo, (DBEntry<IQuest>)entry, event.block, event.blockMetadata, event.x, event.y, event.z);
            }
        }
    }

    @SubscribeEvent
    public void onEntityLiving(BQLivingUpdateEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer) || event.entityLiving.field_70170_p.field_72995_K || event.entityLiving.field_70173_aa % 20 != 0 || ((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        ParticipantInfo pInfo = new ParticipantInfo(player);
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof ITaskTickable)) continue;
                ((ITaskTickable)task.getValue()).tickTask(pInfo, (DBEntry<IQuest>)entry);
            }
        }
    }

    @SubscribeEvent
    public void onEntityCreated(EntityJoinWorldEvent event) {
        if (!(event.entity instanceof EntityPlayer) || event.entity.field_70170_p.field_72995_K) {
            return;
        }
        PlayerContainerListener.refreshListener((EntityPlayer)event.entity);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("bq_standard")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            NetLootSync.sendSync((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K && LootSaveLoad.INSTANCE.worldDir != null && event.world.field_73011_w.field_76574_g == 0) {
            LootSaveLoad.INSTANCE.SaveLoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ListenableFuture<T> scheduleServerTask(Callable<T> task) {
        Validate.notNull(task);
        ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(task);
        ArrayDeque<FutureTask> arrayDeque = serverTasks;
        synchronized (arrayDeque) {
            serverTasks.add((FutureTask)listenablefuturetask);
            return listenablefuturetask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (serverThread == null) {
            serverThread = Thread.currentThread();
        }
        ArrayDeque<FutureTask> arrayDeque = serverTasks;
        synchronized (arrayDeque) {
            while (!serverTasks.isEmpty()) {
                serverTasks.poll().run();
            }
        }
    }
}

