/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.OreIngredient;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.client.gui.tasks.PanelTaskCrafting;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskCrafting;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class TaskCrafting
implements ITask {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public final List<BigItemStack> requiredItems = new ArrayList<BigItemStack>();
    public final TreeMap<UUID, int[]> userProgress = new TreeMap();
    public boolean partialMatch = true;
    public boolean ignoreNBT = true;
    public boolean allowAnvil = false;
    public boolean allowSmelt = true;
    public boolean allowCraft = true;

    public ResourceLocation getFactoryID() {
        return FactoryTaskCrafting.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.crafting";
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        pInfo.ALL_UUIDS.forEach(uuid -> {
            if (this.isComplete((UUID)uuid)) {
                return;
            }
            int[] tmp = this.getUsersProgress((UUID)uuid);
            for (int i = 0; i < this.requiredItems.size(); ++i) {
                BigItemStack rStack = this.requiredItems.get(i);
                if (tmp[i] >= rStack.stackSize) continue;
                return;
            }
            this.setComplete((UUID)uuid);
        });
        pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
    }

    public void onItemCraft(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack stack) {
        if (!this.allowCraft) {
            return;
        }
        this.onItemInternal(pInfo, quest, stack);
    }

    public void onItemSmelt(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack stack) {
        if (!this.allowSmelt) {
            return;
        }
        this.onItemInternal(pInfo, quest, stack);
    }

    public void onItemAnvil(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack stack) {
        if (!this.allowAnvil) {
            return;
        }
        this.onItemInternal(pInfo, quest, stack);
    }

    private void onItemInternal(ParticipantInfo pInfo, DBEntry<IQuest> quest, ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        List<Tuple2<UUID, int[]>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        boolean changed = false;
        for (int i = 0; i < this.requiredItems.size(); ++i) {
            BigItemStack rStack = this.requiredItems.get(i);
            int index = i;
            if (!ItemComparison.StackMatch((ItemStack)rStack.getBaseStack(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch) && !ItemComparison.OreDictionaryMatch((OreIngredient)rStack.getOreIngredient(), (NBTTagCompound)rStack.GetTagCompound(), (ItemStack)stack, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) continue;
            progress.forEach(entry -> {
                if (((int[])entry.func_76340_b())[index] >= rStack.stackSize) {
                    return;
                }
                ((int[])entry.func_76340_b())[index] = Math.min(((int[])entry.func_76340_b())[index] + stack.field_77994_a, rStack.stackSize);
            });
            changed = true;
        }
        if (changed) {
            this.setBulkProgress(progress);
            this.detect(pInfo, quest);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("partialMatch", this.partialMatch);
        nbt.func_74757_a("ignoreNBT", this.ignoreNBT);
        nbt.func_74757_a("allowCraft", this.allowCraft);
        nbt.func_74757_a("allowSmelt", this.allowSmelt);
        nbt.func_74757_a("allowAnvil", this.allowAnvil);
        NBTTagList itemArray = new NBTTagList();
        for (BigItemStack stack : this.requiredItems) {
            itemArray.func_74742_a((NBTBase)JsonHelper.ItemStackToJson((BigItemStack)stack, (NBTTagCompound)new NBTTagCompound()));
        }
        nbt.func_74782_a("requiredItems", (NBTBase)itemArray);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.partialMatch = nbt.func_74767_n("partialMatch");
        this.ignoreNBT = nbt.func_74767_n("ignoreNBT");
        if (nbt.func_74764_b("allowCraft")) {
            this.allowCraft = nbt.func_74767_n("allowCraft");
        }
        if (nbt.func_74764_b("allowSmelt")) {
            this.allowSmelt = nbt.func_74767_n("allowSmelt");
        }
        if (nbt.func_74764_b("allowAnvil")) {
            this.allowAnvil = nbt.func_74767_n("allowAnvil");
        }
        this.requiredItems.clear();
        NBTTagList iList = nbt.func_150295_c("requiredItems", 10);
        for (int i = 0; i < iList.func_74745_c(); ++i) {
            this.requiredItems.add(JsonHelper.JsonToItemStack((NBTTagCompound)iList.func_150305_b(i)));
        }
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            UUID uuid;
            NBTTagCompound pTag = pList.func_150305_b(n);
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            int[] data = new int[this.requiredItems.size()];
            List dJson = NBTConverter.getTagList((NBTTagList)pTag.func_150295_c("data", 3));
            for (int i = 0; i < data.length && i < dJson.size(); ++i) {
                try {
                    data[i] = ((NBTBase.NBTPrimitive)dJson.get(i)).func_150287_d();
                    continue;
                }
                catch (Exception e) {
                    BQ_Standard.logger.log(Level.ERROR, "Incorrect task progress format", (Throwable)e);
                }
            }
            this.userProgress.put(uuid, data);
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                int[] data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    NBTTagList pArray = new NBTTagList();
                    for (int i : data) {
                        pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                    }
                    pJson.func_74782_a("data", (NBTBase)pArray);
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                NBTTagList pArray = new NBTTagList();
                for (int i : data) {
                    pArray.func_74742_a((NBTBase)new NBTTagInt(i));
                }
                pJson.func_74782_a("data", (NBTBase)pArray);
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> context) {
        return new PanelTaskCrafting(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }

    private void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID uuid) {
        int[] progress = this.userProgress.get(uuid);
        return progress == null || progress.length != this.requiredItems.size() ? new int[this.requiredItems.size()] : progress;
    }

    private List<Tuple2<UUID, int[]>> getBulkProgress(@Nonnull List<UUID> uuids) {
        if (uuids.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Tuple2<UUID, int[]>> list = new ArrayList<Tuple2<UUID, int[]>>();
        uuids.forEach(key -> list.add(new Tuple2(key, (Object)this.getUsersProgress((UUID)key))));
        return list;
    }

    private void setBulkProgress(@Nonnull List<Tuple2<UUID, int[]>> list) {
        list.forEach(entry -> this.setUserProgress((UUID)entry.func_76341_a(), (int[])entry.func_76340_b()));
    }
}

