/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.components;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import stevesaddons.components.EnergyFacingHolder;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.SlotInventoryHolder;

public class RFBufferElement {
    private FlowComponent component;
    private SlotInventoryHolder inventoryHolder;
    private List<EnergyFacingHolder> holders;
    private Iterator<EnergyFacingHolder> iterator;

    public RFBufferElement(FlowComponent owner, SlotInventoryHolder inventoryHolder, EnergyFacingHolder target) {
        this(owner, inventoryHolder);
        this.addTarget(target);
    }

    private RFBufferElement(FlowComponent owner, SlotInventoryHolder inventoryHolder) {
        this.component = owner;
        this.inventoryHolder = inventoryHolder;
        this.holders = new ArrayList<EnergyFacingHolder>();
    }

    private void addTarget(EnergyFacingHolder energyHolder) {
        this.holders.add(energyHolder);
    }

    public List<EnergyFacingHolder> getSubElements() {
        return this.holders;
    }

    public EnergyFacingHolder getSubElement() {
        return this.iterator.hasNext() ? this.iterator.next() : null;
    }

    public void removeSubElement() {
        this.iterator.remove();
    }

    public void releaseSubElements() {
        this.iterator = null;
    }

    public int getMaxExtract() {
        int result = 0;
        for (EnergyFacingHolder holder : this.holders) {
            result += holder.extract(Integer.MAX_VALUE, true);
        }
        return result;
    }

    public int removeRF(int amount) {
        int removeEach = amount / this.holders.size();
        int result = amount;
        Iterator<EnergyFacingHolder> itr = this.holders.iterator();
        while (itr.hasNext()) {
            EnergyFacingHolder holder = itr.next();
            int removed = holder.extract(removeEach, false);
            if (removed < removeEach) {
                itr.remove();
            }
            result -= removed;
        }
        if (result > 0 && this.holders.size() > 0) {
            return this.removeRF(result);
        }
        return amount - result;
    }
}

