/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.interfaces;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import stevesaddons.interfaces.GuiTextEntry;
import stevesaddons.interfaces.GuiTextField;
import stevesaddons.interfaces.GuiVerticalScrollBar;
import stevesaddons.interfaces.IVerticalScrollContainer;
import stevesaddons.items.ItemLabeler;
import stevesaddons.network.MessageHandler;
import stevesaddons.network.message.LabelSyncMessage;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class GuiLabeler
extends GuiScreen
implements IVerticalScrollContainer,
INEIGuiHandler {
    private static Comparator<GuiTextEntry> ALPHABETICAL_ORDER = new Comparator<GuiTextEntry>(){

        @Override
        public int compare(GuiTextEntry o1, GuiTextEntry o2) {
            if (o1.isEditing) {
                return 1;
            }
            int res = String.CASE_INSENSITIVE_ORDER.compare(o1.getText(), o2.getText());
            return res == 0 ? o1.getText().compareTo(o2.getText()) : res;
        }
    };
    public static final ResourceLocation TEXTURE = new ResourceLocation("stevesaddons", "textures/gui/GuiLabeler.png");
    private static final int GUI_WIDTH = 140;
    private static final int GUI_HEIGHT = 200;
    private static final int SCROLL_Y = 25;
    public static final int SCROLL_X = 9;
    private static final int SCROLL_Y_MAX = 169;
    private static final int SCROLL_X_MAX = 103;
    private static final int ENTRY_HEIGHT = 16;
    private List<GuiTextEntry> strings = new ArrayList<GuiTextEntry>();
    private List<GuiTextEntry> displayStrings;
    private GuiTextEntry selected = null;
    private ItemStack stack;
    private GuiTextField searchBar;
    private GuiVerticalScrollBar scrollBar;
    private EntityPlayer player;
    public int mouseX = 0;
    public int mouseY = 0;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;

    public GuiLabeler(ItemStack stack, EntityPlayer player) {
        this.stack = stack;
        for (String string : ItemLabeler.getSavedStrings(stack)) {
            this.strings.add(GuiLabeler.getGuiTextEntry(string));
        }
        this.xSize = 140;
        this.ySize = 200;
        this.scrollBar = new GuiVerticalScrollBar(this, 107, 25, 144);
        this.searchBar = new GuiTextField(110, 12, 9, 10);
        this.searchBar.setText(ItemLabeler.getLabel(stack));
        this.searchBar.fixCursorPos();
        this.displayStrings = this.getSearchedStrings();
        this.player = player;
    }

    public static GuiTextEntry getGuiTextEntry(String string) {
        return new GuiTextEntry(string, 16, 94);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(p_73863_3_, p_73863_1_, p_73863_2_);
    }

    protected void drawGuiContainerBackgroundLayer(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GL11.glPushMatrix();
        int x = this.guiLeft;
        int y = this.guiTop;
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiLabeler.bindTexture(TEXTURE);
        this.func_73729_b(0, 0, 0, 0, 140, 200);
        this.scrollBar.draw();
        this.searchBar.draw();
        GuiLabeler.func_73734_a((int)8, (int)24, (int)104, (int)170, (int)-10000537);
        GuiLabeler.func_73734_a((int)9, (int)25, (int)103, (int)169, (int)-6447715);
        this.drawDisplayStrings();
        GL11.glPopMatrix();
    }

    private int getListViewSize() {
        return 9;
    }

    private void drawDisplayStrings() {
        int i = 0;
        int startIndex = Math.round((float)(this.displayStrings.size() - this.getListViewSize()) * this.scrollBar.getScrollValue());
        for (GuiTextEntry entry : this.displayStrings) {
            entry.setY(25 + (i - startIndex) * 16);
            entry.isVisible = entry.y >= 25 && entry.y + entry.height <= 169;
            entry.draw();
            ++i;
        }
    }

    protected void func_73869_a(char character, int keyCode) {
        boolean reset = false;
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (keyCode == 28) {
            if (!this.isEditing() && this.isNewEntry(this.searchBar.getText())) {
                this.strings.add(GuiLabeler.getGuiTextEntry(this.searchBar.getText()));
                Collections.sort(this.strings, ALPHABETICAL_ORDER);
            }
            reset = true;
        }
        this.searchBar.keyTyped(character, keyCode);
        if (this.isEditing()) {
            this.selected.setText(this.searchBar.getText());
        }
        if (reset) {
            this.searchBar.setText("");
            this.searchBar.fixCursorPos();
            if (this.selected != null) {
                if (this.selected.getText().isEmpty()) {
                    this.strings.remove((Object)this.selected);
                } else {
                    this.selected.isEditing = false;
                    this.selected.isSelected = false;
                }
                this.selected = null;
            }
        }
        this.displayStrings = this.getSearchedStrings();
        this.scrollBar.setYPos(0);
    }

    private boolean isEditing() {
        return this.selected != null && this.selected.isEditing;
    }

    private boolean isNewEntry(String string) {
        if (string.isEmpty()) {
            return false;
        }
        for (GuiTextEntry entry : this.displayStrings) {
            if (!string.equals(entry.getText())) continue;
            return false;
        }
        return true;
    }

    public static void bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
    }

    public List<GuiTextEntry> getSearchedStrings() {
        ArrayList<GuiTextEntry> result = new ArrayList<GuiTextEntry>();
        Pattern pattern = Pattern.compile(Pattern.quote(this.searchBar.getText()), 2);
        for (GuiTextEntry entry : this.strings) {
            if (!pattern.matcher(entry.getText()).find()) continue;
            result.add(entry);
        }
        return result;
    }

    public void func_146281_b() {
        ArrayList<String> save = new ArrayList<String>();
        for (GuiTextEntry entry : this.strings) {
            if (save.contains(entry.getText())) continue;
            save.add(entry.getText());
        }
        this.searchBar.close();
        ItemLabeler.saveStrings(this.stack, save);
        ItemLabeler.setLabel(this.stack, this.searchBar.getText());
        MessageHandler.INSTANCE.sendToServer((IMessage)new LabelSyncMessage(this.stack, this.player));
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.mouseX = i - (this.field_146294_l - this.xSize) / 2;
        this.mouseY = j - (this.field_146295_m - this.ySize) / 2;
        if (this.isScrollBarActive()) {
            this.scrollBar.handleMouseInput();
        }
        if (Mouse.getEventButtonState() && this.mouseX >= 9 && this.mouseX <= 103 && this.mouseY >= 25 && this.mouseY <= 169) {
            for (GuiTextEntry entry : this.displayStrings) {
                entry.handleMouseInput(this.mouseX, this.mouseY);
                if (!entry.isSelected) continue;
                this.selected = entry;
                this.searchBar.setText(entry.getText());
                this.searchBar.fixCursorPos();
            }
            this.displayStrings = this.getSearchedStrings();
        }
    }

    @Override
    public boolean isScrollBarActive() {
        return this.displayStrings.size() > this.getListViewSize();
    }

    @Override
    public int getScreenWidth() {
        return this.field_146294_l;
    }

    @Override
    public int getScreenHeight() {
        return this.field_146295_m;
    }

    @Override
    public int getGuiWidth() {
        return this.xSize;
    }

    @Override
    public int getGuiHeight() {
        return this.ySize;
    }

    @Override
    public int getScrollAmount() {
        return 5;
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer guiContainer, VisiblityData visiblityData) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return x + w >= this.guiLeft && x <= this.guiLeft + this.field_146294_l && y + h >= this.guiTop && y <= this.guiTop + this.field_146295_m;
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gui, int mouseX, int mouseY, ItemStack draggedStack, int button) {
        return false;
    }
}

