/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Interfaces;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.Containers.ContainerDetector;
import vswe.stevescarts.Helpers.DetectorType;
import vswe.stevescarts.Helpers.DropDownMenu;
import vswe.stevescarts.Helpers.DropDownMenuPages;
import vswe.stevescarts.Helpers.LogicObject;
import vswe.stevescarts.Helpers.ModuleState;
import vswe.stevescarts.Helpers.OperatorObject;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiBase;
import vswe.stevescarts.ModuleData.ModuleData;
import vswe.stevescarts.TileEntities.TileEntityDetector;

@SideOnly(value=Side.CLIENT)
public class GuiDetector
extends GuiBase {
    private ArrayList<DropDownMenu> menus;
    private DropDownMenuPages modulesMenu;
    private DropDownMenu statesMenu;
    private DropDownMenu flowMenu;
    public static ResourceLocation texture = ResourceHelper.getResource("/gui/detector.png");
    public static ResourceLocation moduleTexture = ResourceHelper.getResourceFromPath("/atlas/items.png");
    public static ResourceLocation stateTexture = ResourceHelper.getResource("/gui/states.png");
    public static ResourceLocation dropdownTexture = ResourceHelper.getResource("/gui/detector2.png");
    public LogicObject currentObject;
    TileEntityDetector detector;
    InventoryPlayer invPlayer;

    public GuiDetector(InventoryPlayer invPlayer, TileEntityDetector detector) {
        super(new ContainerDetector((IInventory)invPlayer, detector));
        this.invPlayer = invPlayer;
        this.setXSize(255);
        this.setYSize(202);
        this.detector = detector;
        Iterator<LogicObject> iterator = detector.mainObj.getChilds().iterator();
        if (iterator.hasNext()) {
            LogicObject child = iterator.next();
            child.setParent(null);
        }
        detector.recalculateTree();
        this.menus = new ArrayList();
        this.modulesMenu = new DropDownMenuPages(0, 2);
        this.menus.add(this.modulesMenu);
        this.statesMenu = new DropDownMenu(1);
        this.menus.add(this.statesMenu);
        this.flowMenu = new DropDownMenu(2);
        this.menus.add(this.flowMenu);
    }

    @Override
    public void drawGuiForeground(int x, int y) {
        GL11.glDisable((int)2896);
        this.getFontRenderer().func_78276_b(DetectorType.getTypeFromMeta(this.detector.func_145832_p()).getName(), 8, 6, 0x404040);
        if (this.modulesMenu.getScroll() != 0) {
            int modulePosId = 0;
            for (ModuleData module : ModuleData.getModules()) {
                if (!module.getIsValid()) continue;
                int[] target = this.modulesMenu.getContentRect(modulePosId);
                if (!this.drawMouseOver(module.getName(), x, y, target)) {
                    ++modulePosId;
                    continue;
                }
                break;
            }
        } else if (this.statesMenu.getScroll() != 0) {
            int statesPosId = 0;
            for (ModuleState state : ModuleState.getStateList()) {
                int[] target = this.statesMenu.getContentRect(statesPosId);
                if (!this.drawMouseOver(state.getName(), x, y, target)) {
                    ++statesPosId;
                    continue;
                }
                break;
            }
        } else if (this.flowMenu.getScroll() != 0) {
            int flowPosId = 0;
            for (OperatorObject operator : OperatorObject.getOperatorList(this.detector.func_145832_p())) {
                if (!operator.inTab()) continue;
                int[] target = this.flowMenu.getContentRect(flowPosId);
                if (!this.drawMouseOver(operator.getName(), x, y, target)) {
                    ++flowPosId;
                    continue;
                }
                break;
            }
        } else {
            this.drawMouseOverFromObject(this.detector.mainObj, x, y);
        }
        GL11.glEnable((int)2896);
    }

    private boolean drawMouseOverFromObject(LogicObject obj, int x, int y) {
        if (this.drawMouseOver(obj.getName(), x, y, obj.getRect())) {
            return true;
        }
        for (LogicObject child : obj.getChilds()) {
            if (!this.drawMouseOverFromObject(child, x, y)) continue;
            return true;
        }
        return false;
    }

    private boolean drawMouseOver(String str, int x, int y, int[] rect) {
        if (rect != null && this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), rect)) {
            this.drawMouseOver(str, x - this.getGuiLeft(), y - this.getGuiTop());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawGuiBackground(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        ResourceHelper.bindResource(texture);
        this.func_73729_b(j, k, 0, 0, this.xSize, this.ySize);
        this.detector.mainObj.draw(this, x -= this.getGuiLeft(), y -= this.getGuiTop());
        DropDownMenu.update(this, x, y, this.menus);
        this.flowMenu.drawMain(this, x, y);
        ResourceHelper.bindResource(texture);
        int flowPosId = 0;
        for (OperatorObject operatorObject : OperatorObject.getOperatorList(this.detector.func_145832_p())) {
            if (!operatorObject.inTab()) continue;
            int[] src = this.getOperatorTexture(operatorObject.getID());
            this.flowMenu.drawContent(this, flowPosId, src[0], src[1]);
            ++flowPosId;
        }
        this.statesMenu.drawMain(this, x, y);
        ResourceHelper.bindResource(stateTexture);
        int statePosId = 0;
        for (ModuleState state : ModuleState.getStateList()) {
            int[] src = this.getModuleTexture(state.getID());
            this.statesMenu.drawContent(this, statePosId, src[0], src[1]);
            ++statePosId;
        }
        this.modulesMenu.drawMain(this, x, y);
        ResourceHelper.bindResource(moduleTexture);
        boolean bl = false;
        for (ModuleData module : ModuleData.getModules()) {
            void var8_12;
            if (!module.getIsValid()) continue;
            this.modulesMenu.drawContent(this, (int)var8_12, module.getIcon());
            ++var8_12;
        }
        this.flowMenu.drawHeader(this);
        this.statesMenu.drawHeader(this);
        this.modulesMenu.drawHeader(this);
        if (this.currentObject != null) {
            this.currentObject.draw(this, -500, -500, x, y);
        }
    }

    public int[] getOperatorTexture(byte operatorId) {
        int x = operatorId % 11;
        int y = operatorId / 11;
        return new int[]{36 + x * 20, this.ySize + y * 11};
    }

    public int[] getModuleTexture(byte moduleId) {
        int srcX = moduleId % 16 * 16;
        int srcY = moduleId / 16 * 16;
        return new int[]{srcX, srcY};
    }

    private int[] getOperatorRect(int posId) {
        return new int[]{20 + posId * 30, 20, 20, 11};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mouseClick(int x, int y, int button) {
        super.mouseClick(x, y, button);
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        if (button == 0) {
            if (GuiDetector.func_146272_n()) {
                if (this.currentObject == null) {
                    this.pickupObject(x, y, this.detector.mainObj);
                }
            } else {
                int modulePosId = 0;
                for (ModuleData moduleData : ModuleData.getModules()) {
                    if (!moduleData.getIsValid()) continue;
                    int[] target = this.modulesMenu.getContentRect(modulePosId);
                    if (this.inRect(x, y, target)) {
                        this.currentObject = new LogicObject(0, moduleData.getID());
                        return;
                    }
                    ++modulePosId;
                }
                int statePosId = 0;
                for (ModuleState state : ModuleState.getStateList()) {
                    int[] target = this.statesMenu.getContentRect(statePosId);
                    if (this.inRect(x, y, target)) {
                        this.currentObject = new LogicObject(2, state.getID());
                        return;
                    }
                    ++statePosId;
                }
                boolean bl = false;
                for (OperatorObject operator : OperatorObject.getOperatorList(this.detector.func_145832_p())) {
                    void var6_10;
                    if (!operator.inTab()) continue;
                    int[] target = this.flowMenu.getContentRect((int)var6_10);
                    if (this.inRect(x, y, target)) {
                        this.currentObject = new LogicObject(1, operator.getID());
                        return;
                    }
                    ++var6_10;
                }
                for (DropDownMenu menu : this.menus) {
                    menu.onClick(this, x, y);
                }
            }
        } else if (button == 1 && this.currentObject == null) {
            this.removeObject(x, y, this.detector.mainObj);
        }
    }

    @Override
    public void mouseMoved(int x, int y, int button) {
        super.mouseMoved(x, y, button);
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        if (button != -1 && this.currentObject != null) {
            this.dropOnObject(x, y, this.detector.mainObj, this.currentObject);
            this.currentObject = null;
        }
    }

    private boolean removeObject(int x, int y, LogicObject object) {
        if (this.inRect(x, y, object.getRect()) && object.canBeRemoved()) {
            object.setParent(this.detector, null);
            return true;
        }
        for (LogicObject child : object.getChilds()) {
            if (!this.removeObject(x, y, child)) continue;
            return true;
        }
        return false;
    }

    private boolean pickupObject(int x, int y, LogicObject object) {
        if (this.inRect(x, y, object.getRect()) && object.canBeRemoved()) {
            this.currentObject = object;
            object.setParent(this.detector, null);
            return true;
        }
        for (LogicObject child : object.getChilds()) {
            if (!this.pickupObject(x, y, child)) continue;
            return true;
        }
        return false;
    }

    private boolean dropOnObject(int x, int y, LogicObject object, LogicObject drop) {
        if (this.inRect(x, y, object.getRect())) {
            if (object.hasRoomForChild() && object.isChildValid(drop)) {
                drop.setParent(this.detector, object);
            }
            return true;
        }
        for (LogicObject child : object.getChilds()) {
            if (!this.dropOnObject(x, y, child, drop)) continue;
            return true;
        }
        return false;
    }
}

