/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Carts;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.MovingSoundMinecart;
import net.minecraft.client.audio.MovingSoundMinecartRiding;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import vswe.stevescarts.Blocks.ModBlocks;
import vswe.stevescarts.Containers.ContainerMinecart;
import vswe.stevescarts.Helpers.ActivatorOption;
import vswe.stevescarts.Helpers.CartVersion;
import vswe.stevescarts.Helpers.CompWorkModule;
import vswe.stevescarts.Helpers.DataWatcherLockable;
import vswe.stevescarts.Helpers.DetectorType;
import vswe.stevescarts.Helpers.GuiAllocationHelper;
import vswe.stevescarts.Helpers.ModuleCountPair;
import vswe.stevescarts.Helpers.TransferHandler;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Items.ModItems;
import vswe.stevescarts.Models.Cart.ModelCartbase;
import vswe.stevescarts.ModuleData.ModuleData;
import vswe.stevescarts.Modules.Addons.ModuleCreativeSupplies;
import vswe.stevescarts.Modules.Engines.ModuleElectricBase;
import vswe.stevescarts.Modules.Engines.ModuleEngine;
import vswe.stevescarts.Modules.IActivatorModule;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.Modules.Storages.Chests.ModuleChest;
import vswe.stevescarts.Modules.Storages.Chests.ModuleTrainStorage;
import vswe.stevescarts.Modules.Storages.Tanks.ModuleTank;
import vswe.stevescarts.Modules.Workers.ModuleWorker;
import vswe.stevescarts.Modules.Workers.Tools.ModuleTool;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.TileEntities.TileEntityCartAssembler;

public class MinecartModular
extends EntityMinecart
implements IInventory,
IEntityAdditionalSpawnData,
IFluidHandler {
    public int disabledX;
    public int disabledY;
    public int disabledZ;
    protected boolean wasDisabled;
    public double pushX;
    public double pushZ;
    public double temppushX;
    public double temppushZ;
    protected boolean engineFlag = false;
    private int motorRotation;
    public boolean cornerFlip;
    private int fixedMeta = -1;
    private int fixedMX;
    private int fixedMY;
    private int fixedMZ;
    private byte[] moduleLoadingData;
    private ForgeChunkManager.Ticket cartTicket;
    private int wrongRender;
    private boolean oldRender;
    private float lastRenderYaw;
    private double lastMotionX;
    private double lastMotionZ;
    private int workingTime;
    private ModuleWorker workingComponent;
    public TileEntityCartAssembler placeholderAsssembler;
    public boolean isPlaceholder;
    public int keepAlive;
    public static final int MODULAR_SPACE_WIDTH = 443;
    public static final int MODULAR_SPACE_HEIGHT = 168;
    protected int modularSpaceHeight;
    public boolean canScrollModules;
    private ArrayList<ModuleCountPair> moduleCounts;
    public static final int[][][] railDirectionCoordinates = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private ArrayList<ModuleBase> modules;
    private ArrayList<ModuleWorker> workModules;
    private ArrayList<ModuleEngine> engineModules;
    private ArrayList<ModuleTank> tankModules;
    private ModuleCreativeSupplies creativeSupplies;
    public Random field_70146_Z = new Random();
    protected String name;
    public byte cartVersion;
    private int scrollY;
    @SideOnly(value=Side.CLIENT)
    private MovingSound sound;
    @SideOnly(value=Side.CLIENT)
    private MovingSound soundRiding;
    @SideOnly(value=Side.CLIENT)
    private int keepSilent;

    public ArrayList<ModuleBase> getModules() {
        return this.modules;
    }

    public ArrayList<ModuleWorker> getWorkers() {
        return this.workModules;
    }

    public ArrayList<ModuleEngine> getEngines() {
        return this.engineModules;
    }

    public ArrayList<ModuleTank> getTanks() {
        return this.tankModules;
    }

    public ArrayList<ModuleCountPair> getModuleCounts() {
        return this.moduleCounts;
    }

    public MinecartModular(World world, double x, double y, double z, NBTTagCompound info, String name) {
        super(world, x, y, z);
        this.overrideDatawatcher();
        this.cartVersion = info.func_74771_c("CartVersion");
        this.loadModules(info);
        this.name = name;
        for (int i = 0; i < this.modules.size(); ++i) {
            if (!this.modules.get(i).hasExtraData() || !info.func_74764_b("Data" + i)) continue;
            this.modules.get(i).setExtraData(info.func_74771_c("Data" + i));
        }
    }

    public MinecartModular(World world) {
        super(world);
        this.overrideDatawatcher();
    }

    public MinecartModular(World world, TileEntityCartAssembler assembler, byte[] data) {
        this(world);
        this.setPlaceholder(assembler);
        this.loadPlaceholderModules(data);
    }

    private void overrideDatawatcher() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70180_af = new DataWatcherLockable((Entity)this);
            this.field_70180_af.func_75682_a(0, (Object)0);
            this.field_70180_af.func_75682_a(1, (Object)300);
            this.func_70088_a();
        }
    }

    private void loadPlaceholderModules(byte[] data) {
        if (this.modules == null) {
            this.modules = new ArrayList();
            this.doLoadModules(data);
        } else {
            int i;
            ArrayList<Byte> modulesToAdd = new ArrayList<Byte>();
            ArrayList<Byte> oldModules = new ArrayList<Byte>();
            for (i = 0; i < this.moduleLoadingData.length; ++i) {
                oldModules.add(this.moduleLoadingData[i]);
            }
            for (i = 0; i < data.length; ++i) {
                boolean found = false;
                for (int j = 0; j < oldModules.size(); ++j) {
                    if (data[i] != (Byte)oldModules.get(j)) continue;
                    found = true;
                    oldModules.remove(j);
                    break;
                }
                if (found) continue;
                modulesToAdd.add(data[i]);
            }
            Iterator i2 = oldModules.iterator();
            block3: while (i2.hasNext()) {
                byte id = (Byte)i2.next();
                for (int i3 = 0; i3 < this.modules.size(); ++i3) {
                    if (id != this.modules.get(i3).getModuleId()) continue;
                    this.modules.remove(i3);
                    continue block3;
                }
            }
            byte[] newModuleData = new byte[modulesToAdd.size()];
            for (int i4 = 0; i4 < modulesToAdd.size(); ++i4) {
                newModuleData[i4] = (Byte)modulesToAdd.get(i4);
            }
            this.doLoadModules(newModuleData);
        }
        this.initModules();
        this.moduleLoadingData = data;
    }

    private void loadModules(NBTTagCompound info) {
        NBTTagByteArray moduleIDTag = (NBTTagByteArray)info.func_74781_a("Modules");
        if (moduleIDTag == null) {
            return;
        }
        this.moduleLoadingData = this.field_70170_p.field_72995_K ? moduleIDTag.func_150292_c() : CartVersion.updateCart(this, moduleIDTag.func_150292_c());
        this.loadModules(this.moduleLoadingData);
    }

    public void updateSimulationModules(byte[] bytes) {
        if (!this.isPlaceholder) {
            System.out.println("You're stupid! This is not a placeholder cart.");
        } else {
            this.loadPlaceholderModules(bytes);
        }
    }

    protected void loadModules(byte[] bytes) {
        this.modules = new ArrayList();
        this.doLoadModules(bytes);
        this.initModules();
    }

    private void doLoadModules(byte[] bytes) {
        for (byte id : bytes) {
            try {
                ModuleBase moduleObject;
                Class<? extends ModuleBase> moduleClass = ModuleData.getList().get(id).getModuleClass();
                Constructor<? extends ModuleBase> moduleConstructor = moduleClass.getConstructor(MinecartModular.class);
                ModuleBase module = moduleObject = moduleConstructor.newInstance(new Object[]{this});
                module.setModuleId(id);
                this.modules.add(module);
            }
            catch (Exception e) {
                System.out.println("Failed to load module with ID " + id + "! More info below.");
                e.printStackTrace();
            }
        }
    }

    private void initModules() {
        this.moduleCounts = new ArrayList();
        for (ModuleBase module : this.modules) {
            ModuleData data = ModuleData.getList().get(module.getModuleId());
            boolean found = false;
            for (ModuleCountPair count : this.moduleCounts) {
                if (!count.isContainingData(data)) continue;
                count.increase();
                found = true;
                break;
            }
            if (found) continue;
            this.moduleCounts.add(new ModuleCountPair(data));
        }
        for (ModuleBase module : this.modules) {
            module.preInit();
        }
        this.workModules = new ArrayList();
        this.engineModules = new ArrayList();
        this.tankModules = new ArrayList();
        boolean x = false;
        boolean y = false;
        boolean maxH = false;
        int guidata = 0;
        int datawatcher = 0;
        int packets = 0;
        if (this.field_70170_p.field_72995_K) {
            this.generateModels();
        }
        for (ModuleBase module : this.modules) {
            if (module instanceof ModuleWorker) {
                this.workModules.add((ModuleWorker)module);
                continue;
            }
            if (module instanceof ModuleEngine) {
                this.engineModules.add((ModuleEngine)module);
                continue;
            }
            if (module instanceof ModuleTank) {
                this.tankModules.add((ModuleTank)module);
                continue;
            }
            if (!(module instanceof ModuleCreativeSupplies)) continue;
            this.creativeSupplies = (ModuleCreativeSupplies)module;
        }
        CompWorkModule sorter = new CompWorkModule();
        Collections.sort(this.workModules, sorter);
        if (!this.isPlaceholder) {
            ArrayList<GuiAllocationHelper> lines = new ArrayList<GuiAllocationHelper>();
            int slots = 0;
            for (ModuleBase module : this.modules) {
                if (module.hasGui()) {
                    boolean foundLine = false;
                    for (GuiAllocationHelper line : lines) {
                        if (line.width + module.guiWidth() > 443) continue;
                        module.setX(line.width);
                        line.width += module.guiWidth();
                        line.maxHeight = Math.max(line.maxHeight, module.guiHeight());
                        line.modules.add(module);
                        foundLine = true;
                        break;
                    }
                    if (!foundLine) {
                        GuiAllocationHelper line = new GuiAllocationHelper();
                        module.setX(0);
                        line.width = module.guiWidth();
                        line.maxHeight = module.guiHeight();
                        line.modules.add(module);
                        lines.add(line);
                    }
                    module.setGuiDataStart(guidata);
                    guidata += module.numberOfGuiData();
                    if (module.hasSlots()) {
                        slots = module.generateSlots(slots);
                    }
                }
                module.setDataWatcherStart(datawatcher);
                datawatcher += module.numberOfDataWatchers();
                if (module.numberOfDataWatchers() > 0) {
                    module.initDw();
                }
                module.setPacketStart(packets);
                packets += module.totalNumberOfPackets();
            }
            int currentY = 0;
            for (GuiAllocationHelper line : lines) {
                for (ModuleBase module : line.modules) {
                    module.setY(currentY);
                }
                currentY += line.maxHeight;
            }
            if (currentY > 168) {
                this.canScrollModules = true;
            }
            this.modularSpaceHeight = currentY;
        }
        for (ModuleBase module : this.modules) {
            module.init();
        }
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            for (int var1 = 0; var1 < this.func_70302_i_(); ++var1) {
                this.func_70299_a(var1, null);
            }
        }
        super.func_70106_y();
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.onDeath();
            }
        }
        this.dropChunkLoading();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(Minecraft minecraft) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.renderOverlay(minecraft);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    public void updateFuel() {
        ModuleEngine engine;
        int consumption = this.getConsumption();
        if (consumption > 0 && (engine = this.getCurrentEngine()) != null) {
            engine.consumeFuel(consumption);
            if (!this.isPlaceholder && this.field_70170_p.field_72995_K && this.hasFuel() && !this.isDisabled()) {
                engine.smoke();
            }
        }
        if (this.hasFuel()) {
            if (!this.engineFlag) {
                this.pushX = this.temppushX;
                this.pushZ = this.temppushZ;
            }
        } else if (this.engineFlag) {
            this.temppushX = this.pushX;
            this.temppushZ = this.pushZ;
            this.pushZ = 0.0;
            this.pushX = 0.0;
        }
        this.setEngineBurning(this.hasFuel() && !this.isDisabled());
    }

    public boolean isEngineBurning() {
        return this.isCartFlag(0);
    }

    public void setEngineBurning(boolean on) {
        this.setCartFlag(0, on);
    }

    private boolean isCartFlag(int id) {
        return (this.field_70180_af.func_75683_a(16) & 1 << id) != 0;
    }

    private void setCartFlag(int id, boolean val) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        byte data = (byte)(this.field_70180_af.func_75683_a(16) & ~(1 << id) | (val ? 1 : 0) << id);
        this.field_70180_af.func_75692_b(16, (Object)data);
    }

    public ModuleEngine getCurrentEngine() {
        if (this.modules == null) {
            return null;
        }
        for (ModuleBase module : this.modules) {
            if (!module.stopEngines()) continue;
            return null;
        }
        int consumption = this.getConsumption(true);
        ArrayList<ModuleEngine> priority = new ArrayList<ModuleEngine>();
        int mostImportant = -1;
        for (ModuleEngine engine : this.engineModules) {
            if (!engine.hasFuel(consumption) || mostImportant != -1 && mostImportant < engine.getPriority()) continue;
            if (engine.getPriority() < mostImportant) {
                priority.clear();
            }
            mostImportant = engine.getPriority();
            priority.add(engine);
        }
        if (priority.size() > 0) {
            if (this.motorRotation >= priority.size()) {
                this.motorRotation = 0;
            }
            this.motorRotation = (this.motorRotation + 1) % priority.size();
            return (ModuleEngine)priority.get(this.motorRotation);
        }
        return null;
    }

    public int getConsumption() {
        return this.getConsumption(!this.isDisabled() && this.isEngineBurning());
    }

    public int getConsumption(boolean isMoving) {
        int consumption;
        int n = consumption = isMoving ? 1 : 0;
        if (this.modules != null && !this.isPlaceholder) {
            for (ModuleBase module : this.modules) {
                consumption += module.getConsumption(isMoving);
            }
        }
        return consumption;
    }

    public float func_70047_e() {
        return 0.9f;
    }

    public double func_70042_X() {
        if (this.modules != null && this.field_70153_n != null) {
            for (ModuleBase module : this.modules) {
                float offset = module.mountedOffset(this.field_70153_n);
                if (offset == 0.0f) continue;
                return offset;
            }
        }
        return super.func_70042_X();
    }

    public ItemStack getCartItem() {
        if (this.modules != null) {
            ItemStack cart = ModuleData.createModularCart(this);
            if (this.name != null && !this.name.equals("") && !this.name.equals(ModItems.carts.getName())) {
                cart.func_151001_c(this.name);
            }
            return cart;
        }
        return new ItemStack((Item)ModItems.carts);
    }

    public void func_94095_a(DamageSource dmg) {
        this.func_70106_y();
        if (this.dropOnDeath()) {
            this.func_70099_a(this.getCartItem(), 0.0f);
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack itemstack = this.func_70301_a(i);
                if (itemstack == null) continue;
                float f = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                float f1 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                float f2 = this.field_70146_Z.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = this.field_70146_Z.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)f, this.field_70163_u + (double)f1, this.field_70161_v + (double)f2, new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.field_70146_Z.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.field_70146_Z.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.field_70146_Z.nextGaussian() * f3;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                }
            }
        }
    }

    public boolean dropOnDeath() {
        if (this.isPlaceholder) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (module.dropOnDeath()) continue;
                return false;
            }
        }
        return true;
    }

    public float getMaxCartSpeedOnRail() {
        float maxSpeed = super.getMaxCartSpeedOnRail();
        float engineMulitplier = 1.0f;
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                float tempMax = module.getMaxSpeed();
                if (!(tempMax < maxSpeed)) continue;
                maxSpeed = tempMax;
            }
        }
        if (this.getCurrentEngine() != null) {
            engineMulitplier += (float)(0.1 * (double)this.getCurrentEngine().getEngineTier());
        }
        return Math.min(super.getMaxCartSpeedOnRail(), maxSpeed * engineMulitplier);
    }

    public boolean isPoweredCart() {
        return this.engineModules.size() > 0;
    }

    public int func_94097_p() {
        return -1;
    }

    public int func_94087_l() {
        return -1;
    }

    public float[] getColor() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                float[] color = module.getColor();
                if (color[0] == 1.0f && color[1] == 1.0f && color[2] == 1.0f) continue;
                return color;
            }
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public int getYTarget() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                int yTarget = module.getYTarget();
                if (yTarget == -1) continue;
                return yTarget;
            }
        }
        return (int)this.field_70163_u;
    }

    public ModuleBase getInterfaceThief() {
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                if (!module.doStealInterface()) continue;
                return module;
            }
        }
        return null;
    }

    public boolean func_70097_a(DamageSource dmg, float par2) {
        if (this.isPlaceholder) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.getModules()) {
                if (module.receiveDamage(dmg, par2)) continue;
                return false;
            }
        }
        return super.func_70097_a(dmg, par2);
    }

    public void func_96095_a(int x, int y, int z, boolean active) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.activatedByRail(x, y, z, active);
            }
        }
    }

    public void moveMinecartOnRail(int x, int y, int z, double acceleration) {
        boolean forceUnDisable;
        super.moveMinecartOnRail(x, y, z, acceleration);
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.moveMinecartOnRail(x, y, z);
            }
        }
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        Block blockBelow = this.field_70170_p.func_147439_a(x, y - 1, z);
        int metaBelow = this.field_70170_p.func_72805_g(x, y - 1, z);
        int m = ((BlockRailBase)block).getBasicRailMetadata((IBlockAccess)this.field_70170_p, (EntityMinecart)this, x, y, z);
        this.cornerFlip = (m == 6 || m == 7) && this.field_70159_w < 0.0 || (m == 8 || m == 9) && this.field_70159_w > 0.0;
        if (block != ModBlocks.ADVANCED_DETECTOR.getBlock() && this.isDisabled()) {
            this.releaseCart();
        }
        boolean canBeDisabled = block == ModBlocks.ADVANCED_DETECTOR.getBlock() && (blockBelow != ModBlocks.DETECTOR_UNIT.getBlock() || !DetectorType.getTypeFromMeta(metaBelow).canInteractWithCart() || DetectorType.getTypeFromMeta(metaBelow).shouldStopCart());
        boolean bl = forceUnDisable = this.wasDisabled && this.disabledX == x && this.disabledY == y && this.disabledZ == z;
        if (!forceUnDisable && this.wasDisabled) {
            this.wasDisabled = false;
        }
        boolean bl2 = canBeDisabled = forceUnDisable ? false : canBeDisabled;
        if (canBeDisabled && !this.isDisabled()) {
            this.setIsDisabled(true);
            if (this.pushX != 0.0 || this.pushZ != 0.0) {
                this.temppushX = this.pushX;
                this.temppushZ = this.pushZ;
                this.pushZ = 0.0;
                this.pushX = 0.0;
            }
            this.disabledX = x;
            this.disabledY = y;
            this.disabledZ = z;
        }
        if (this.fixedMX != x || this.fixedMY != y || this.fixedMZ != z) {
            this.fixedMeta = -1;
            this.fixedMY = -1;
        }
    }

    public int getRailMeta(int x, int y, int z) {
        boolean flag;
        ModuleBase module;
        ModuleBase.RAILDIRECTION dir = ModuleBase.RAILDIRECTION.DEFAULT;
        Iterator<ModuleBase> iterator = this.getModules().iterator();
        while (iterator.hasNext() && (dir = (module = iterator.next()).getSpecialRailDirection(x, y, z)) == ModuleBase.RAILDIRECTION.DEFAULT) {
        }
        if (dir == ModuleBase.RAILDIRECTION.DEFAULT) {
            return -1;
        }
        int Yaw = (int)(this.field_70177_z % 180.0f);
        if (Yaw < 0) {
            Yaw += 180;
        }
        boolean bl = flag = Yaw >= 45 && Yaw <= 135;
        if (this.fixedMeta == -1) {
            switch (dir) {
                case FORWARD: {
                    if (flag) {
                        this.fixedMeta = 0;
                        break;
                    }
                    this.fixedMeta = 1;
                    break;
                }
                case LEFT: {
                    if (flag) {
                        if (this.field_70179_y > 0.0) {
                            this.fixedMeta = 9;
                            break;
                        }
                        if (!(this.field_70179_y <= 0.0)) break;
                        this.fixedMeta = 7;
                        break;
                    }
                    if (this.field_70159_w > 0.0) {
                        this.fixedMeta = 8;
                        break;
                    }
                    if (!(this.field_70159_w < 0.0)) break;
                    this.fixedMeta = 6;
                    break;
                }
                case RIGHT: {
                    if (flag) {
                        if (this.field_70179_y > 0.0) {
                            this.fixedMeta = 8;
                            break;
                        }
                        if (!(this.field_70179_y <= 0.0)) break;
                        this.fixedMeta = 6;
                        break;
                    }
                    if (this.field_70159_w > 0.0) {
                        this.fixedMeta = 7;
                        break;
                    }
                    if (!(this.field_70159_w < 0.0)) break;
                    this.fixedMeta = 9;
                    break;
                }
                case NORTH: {
                    if (flag) {
                        if (!(this.field_70179_y > 0.0)) break;
                        this.fixedMeta = 0;
                        break;
                    }
                    if (this.field_70159_w > 0.0) {
                        this.fixedMeta = 7;
                        break;
                    }
                    if (!(this.field_70159_w < 0.0)) break;
                    this.fixedMeta = 6;
                    break;
                }
                default: {
                    this.fixedMeta = -1;
                }
            }
            if (this.fixedMeta == -1) {
                return -1;
            }
            this.fixedMX = x;
            this.fixedMY = y;
            this.fixedMZ = z;
        }
        return this.fixedMeta;
    }

    public void resetRailDirection() {
        this.fixedMeta = -1;
    }

    public void turnback() {
        this.pushX *= -1.0;
        this.pushZ *= -1.0;
        this.temppushX *= -1.0;
        this.temppushZ *= -1.0;
        this.field_70159_w *= -1.0;
        this.field_70181_x *= -1.0;
        this.field_70179_y *= -1.0;
    }

    public void releaseCart() {
        this.wasDisabled = true;
        this.setIsDisabled(false);
        this.pushX = this.temppushX;
        this.pushZ = this.temppushZ;
    }

    public void func_70296_d() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                module.onInventoryChanged();
            }
        }
    }

    public int func_70302_i_() {
        int slotCount = 0;
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                slotCount += module.getInventorySize();
            }
        }
        return slotCount;
    }

    protected void func_145821_a(int par1, int par2, int par3, double par4, double par6, Block par8, int par9) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
            float move = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            ((EntityLivingBase)this.field_70153_n).field_70701_bs = 0.0f;
            super.func_145821_a(par1, par2, par3, par4, par6, par8, par9);
            ((EntityLivingBase)this.field_70153_n).field_70701_bs = move;
        } else {
            super.func_145821_a(par1, par2, par3, par4, par6, par8, par9);
        }
        double d2 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (d2 > 1.0E-4 && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.001) {
            d2 = MathHelper.func_76133_a((double)d2);
            this.pushX /= d2;
            this.pushZ /= d2;
            if (this.pushX * this.field_70159_w + this.pushZ * this.field_70179_y < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                this.pushX = this.field_70159_w;
                this.pushZ = this.field_70179_y;
            }
        }
        if (StevesCarts.isRailcraftLoaded) {
            for (ModuleBase module : this.modules) {
                if (!(module instanceof ModuleElectricBase)) continue;
                ((ModuleElectricBase)module).getChargeHandler().tickOnTrack(par1, par2, par3);
            }
        }
    }

    protected void func_94101_h() {
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        boolean bl = this.engineFlag = d0 > 1.0E-4;
        if (this.isDisabled()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        } else if (this.engineFlag) {
            d0 = MathHelper.func_76133_a((double)d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            double d1 = this.getPushFactor();
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.8f;
            this.field_70159_w += this.pushX * d1;
            this.field_70179_y += this.pushZ * d1;
        } else {
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.98f;
        }
        super.func_94101_h();
    }

    protected double getPushFactor() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                double factor = module.getPushFactor();
                if (!(factor >= 0.0)) continue;
                return factor;
            }
        }
        return 0.05;
    }

    public void func_70109_d(NBTTagCompound tagCompound) {
        super.func_70109_d(tagCompound);
        tagCompound.func_74778_a("cartName", this.name);
        tagCompound.func_74780_a("pushX", this.pushX);
        tagCompound.func_74780_a("pushZ", this.pushZ);
        tagCompound.func_74780_a("temppushX", this.temppushX);
        tagCompound.func_74780_a("temppushZ", this.temppushZ);
        tagCompound.func_74777_a("workingTime", (short)this.workingTime);
        tagCompound.func_74773_a("Modules", this.moduleLoadingData);
        tagCompound.func_74774_a("CartVersion", this.cartVersion);
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ModuleBase module = this.modules.get(i);
                module.writeToNBT(tagCompound, i);
            }
        }
    }

    public void func_70020_e(NBTTagCompound tagCompound) {
        super.func_70020_e(tagCompound);
        this.name = tagCompound.func_74779_i("cartName");
        this.pushX = tagCompound.func_74769_h("pushX");
        this.pushZ = tagCompound.func_74769_h("pushZ");
        this.temppushX = tagCompound.func_74769_h("temppushX");
        this.temppushZ = tagCompound.func_74769_h("temppushZ");
        this.workingTime = tagCompound.func_74765_d("workingTime");
        byte oldVersion = this.cartVersion = tagCompound.func_74771_c("CartVersion");
        this.loadModules(tagCompound);
        if (this.modules != null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ModuleBase module = this.modules.get(i);
                module.readFromNBT(tagCompound, i);
            }
        }
        if (oldVersion < 2) {
            int newSlot = -1;
            int slotCount = 0;
            for (ModuleBase module : this.modules) {
                if (module instanceof ModuleTool) {
                    newSlot = slotCount;
                    break;
                }
                slotCount += module.getInventorySize();
            }
            if (newSlot != -1) {
                ItemStack lastitem = null;
                for (int i = newSlot; i < this.func_70302_i_(); ++i) {
                    ItemStack thisitem = this.func_70301_a(i);
                    this.func_70299_a(i, lastitem);
                    lastitem = thisitem;
                }
            }
        }
    }

    public boolean isDisabled() {
        return this.isCartFlag(1);
    }

    public void setIsDisabled(boolean disabled) {
        this.setCartFlag(1, disabled);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.onCartUpdate();
        if (this.field_70170_p.field_72995_K) {
            this.updateSounds();
        }
    }

    public void onCartUpdate() {
        if (this.modules != null) {
            this.updateFuel();
            for (ModuleBase module : this.modules) {
                module.update();
            }
            for (ModuleBase module : this.modules) {
                module.postUpdate();
            }
            this.work();
            this.setCurrentCartSpeedCapOnRail(this.getMaxCartSpeedOnRail());
        }
        if (this.isPlaceholder && this.keepAlive++ > 20) {
            this.func_70076_C();
            this.placeholderAsssembler.resetPlaceholder();
        }
    }

    public boolean hasFuel() {
        if (this.isDisabled()) {
            return false;
        }
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!module.stopEngines()) continue;
                return false;
            }
        }
        return this.hasFuelForModule();
    }

    public boolean hasFuelForModule() {
        if (this.isPlaceholder) {
            return true;
        }
        int consumption = this.getConsumption(true);
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!module.hasFuel(consumption)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_70092_e((double)this.x(), (double)this.y(), (double)this.z()) <= 64.0;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.isPlaceholder) {
            return false;
        }
        if (this.modules != null && !entityplayer.func_70093_af()) {
            boolean interupt = false;
            for (ModuleBase module : this.modules) {
                if (!module.onInteractFirst(entityplayer)) continue;
                interupt = true;
            }
            if (interupt) {
                return true;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.isDisabled() && this.field_70153_n != entityplayer) {
                this.temppushX = this.field_70165_t - entityplayer.field_70165_t;
                this.temppushZ = this.field_70161_v - entityplayer.field_70161_v;
            }
            if (!this.isDisabled() && this.hasFuel() && this.pushX == 0.0 && this.pushZ == 0.0) {
                this.pushX = this.temppushX;
                this.pushZ = this.temppushZ;
            }
            FMLNetworkHandler.openGui((EntityPlayer)entityplayer, (Object)StevesCarts.instance, (int)0, (World)this.field_70170_p, (int)this.func_145782_y(), (int)0, (int)0);
            this.func_70295_k_();
        }
        return true;
    }

    public void loadChunks() {
        this.loadChunks(this.cartTicket, this.x() >> 4, this.z() >> 4);
    }

    public void loadChunks(int chunkX, int chunkZ) {
        this.loadChunks(this.cartTicket, chunkX, chunkZ);
    }

    public void loadChunks(ForgeChunkManager.Ticket ticket) {
        this.loadChunks(ticket, this.x() >> 4, this.z() >> 4);
    }

    public void loadChunks(ForgeChunkManager.Ticket ticket, int chunkX, int chunkZ) {
        if (this.field_70170_p.field_72995_K || ticket == null) {
            return;
        }
        if (this.cartTicket == null) {
            this.cartTicket = ticket;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(chunkX + i, chunkZ + j));
            }
        }
    }

    public void initChunkLoading() {
        if (this.field_70170_p.field_72995_K || this.cartTicket != null) {
            return;
        }
        this.cartTicket = ForgeChunkManager.requestTicket((Object)StevesCarts.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (this.cartTicket != null) {
            this.cartTicket.bindEntity((Entity)this);
            this.cartTicket.setChunkListDepth(9);
            this.loadChunks();
        }
    }

    public void dropChunkLoading() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.cartTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.cartTicket);
            this.cartTicket = null;
        }
    }

    public void setWorker(ModuleWorker worker) {
        if (this.workingComponent != null && worker != null) {
            this.workingComponent.stopWorking();
        }
        this.workingComponent = worker;
        if (worker == null) {
            this.setWorkingTime(0);
        }
    }

    public ModuleWorker getWorker() {
        return this.workingComponent;
    }

    public void setWorkingTime(int val) {
        this.workingTime = val;
    }

    private void work() {
        if (this.isPlaceholder) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.hasFuel()) {
            if (this.workingTime <= 0) {
                ModuleWorker oldComponent = this.workingComponent;
                if (this.workingComponent != null) {
                    boolean result = this.workingComponent.work();
                    if (this.workingComponent != null && oldComponent == this.workingComponent && this.workingTime <= 0 && !this.workingComponent.preventAutoShutdown()) {
                        this.workingComponent.stopWorking();
                    }
                    if (result) {
                        this.work();
                        return;
                    }
                }
                if (this.workModules != null) {
                    for (ModuleWorker module : this.workModules) {
                        if (!module.work()) continue;
                        return;
                    }
                }
            } else if (this.getCurrentEngine() != null) {
                this.workingTime -= (int)Math.pow(2.0, this.getCurrentEngine().getEngineTier());
            }
        }
    }

    public void handleActivator(ActivatorOption option, boolean isOrange) {
        for (ModuleBase module : this.modules) {
            if (!(module instanceof IActivatorModule) || !option.getModule().isAssignableFrom(module.getClass())) continue;
            IActivatorModule iactivator = (IActivatorModule)((Object)module);
            if (option.shouldActivate(isOrange)) {
                iactivator.doActivate(option.getId());
                continue;
            }
            if (option.shouldDeactivate(isOrange)) {
                iactivator.doDeActivate(option.getId());
                continue;
            }
            if (!option.shouldToggle()) continue;
            if (iactivator.isActive(option.getId())) {
                iactivator.doDeActivate(option.getId());
                continue;
            }
            iactivator.doActivate(option.getId());
        }
    }

    public boolean getRenderFlippedYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if (!this.oldRender || Math.abs(yaw - this.lastRenderYaw) < 90.0f || Math.abs(yaw - this.lastRenderYaw) > 270.0f || this.field_70159_w > 0.0 && this.lastMotionX < 0.0 || this.field_70179_y > 0.0 && this.lastMotionZ < 0.0 || this.field_70159_w < 0.0 && this.lastMotionX > 0.0 || this.field_70179_y < 0.0 && this.lastMotionZ > 0.0 || this.wrongRender >= 50) {
            this.lastMotionX = this.field_70159_w;
            this.lastMotionZ = this.field_70179_y;
            this.lastRenderYaw = yaw;
            this.oldRender = true;
            this.wrongRender = 0;
            return false;
        }
        ++this.wrongRender;
        return true;
    }

    public ArrayList<String> getLabel() {
        ArrayList<String> label = new ArrayList<String>();
        if (this.getModules() != null) {
            for (ModuleBase module : this.getModules()) {
                module.addToLabel(label);
            }
        }
        return label;
    }

    public int x() {
        return MathHelper.func_76128_c((double)this.field_70165_t);
    }

    public int y() {
        return MathHelper.func_76128_c((double)this.field_70163_u);
    }

    public int z() {
        return MathHelper.func_76128_c((double)this.field_70161_v);
    }

    public void addItemToChest(ItemStack iStack) {
        TransferHandler.TransferItem(iStack, (IInventory)this, this.getCon(null), Slot.class, null, -1);
        this.pushToTrain(iStack);
    }

    public void addItemToChest(ItemStack iStack, int start, int end) {
        TransferHandler.TransferItem(iStack, this, start, end, this.getCon(null), Slot.class, null, -1);
        this.pushToTrain(iStack);
    }

    public void addItemToChest(ItemStack iStack, Class validSlot, Class invalidSlot) {
        TransferHandler.TransferItem(iStack, (IInventory)this, this.getCon(null), validSlot, invalidSlot, -1);
        this.pushToTrain(iStack);
    }

    private void pushToTrain(ItemStack iStack) {
        if (iStack.field_77994_a != 0) {
            for (ModuleBase module : this.getModules()) {
                if (!(module instanceof ModuleTrainStorage)) continue;
                ((ModuleTrainStorage)module).pushItemStack(iStack);
            }
        }
    }

    public ItemStack func_70301_a(int i) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (i < module.getInventorySize()) {
                    return module.getStack(i);
                }
                i -= module.getInventorySize();
            }
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack item) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (i < module.getInventorySize()) {
                    module.setStack(i, item);
                    break;
                }
                i -= module.getInventorySize();
            }
        }
    }

    public ItemStack func_70298_a(int i, int n) {
        if (this.modules == null) {
            return null;
        }
        if (this.func_70301_a(i) != null) {
            if (this.func_70301_a((int)i).field_77994_a <= n) {
                ItemStack item = this.func_70301_a(i);
                this.func_70299_a(i, null);
                return item;
            }
            ItemStack item = this.func_70301_a(i).func_77979_a(n);
            if (this.func_70301_a((int)i).field_77994_a == 0) {
                this.func_70299_a(i, null);
            }
            return item;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.func_70301_a(i) != null) {
            ItemStack var2 = this.func_70301_a(i);
            this.func_70299_a(i, null);
            return var2;
        }
        return null;
    }

    public Container getCon(InventoryPlayer player) {
        return new ContainerMinecart((IInventory)player, this);
    }

    public void func_70295_k_() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!(module instanceof ModuleChest)) continue;
                ((ModuleChest)module).openChest();
            }
        }
    }

    public void func_70305_f() {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (!(module instanceof ModuleChest)) continue;
                ((ModuleChest)module).closeChest();
            }
        }
    }

    public void setPlaceholder(TileEntityCartAssembler assembler) {
        this.isPlaceholder = true;
        this.placeholderAsssembler = assembler;
    }

    public AxisAlignedBB func_70046_E() {
        if (this.isPlaceholder) {
            return null;
        }
        return super.func_70046_E();
    }

    public boolean func_70067_L() {
        if (this.isPlaceholder) {
            return false;
        }
        return super.func_70067_L();
    }

    public boolean func_70104_M() {
        if (this.isPlaceholder) {
            return false;
        }
        return super.func_70104_M();
    }

    @SideOnly(value=Side.CLIENT)
    private void generateModels() {
        if (this.modules != null) {
            ModuleData data;
            ArrayList<String> invalid = new ArrayList<String>();
            for (ModuleBase module : this.modules) {
                data = module.getData();
                if (!data.haveRemovedModels()) continue;
                for (String remove : data.getRemovedModels()) {
                    invalid.add(remove);
                }
            }
            for (int i = this.modules.size() - 1; i >= 0; --i) {
                ModuleBase module;
                module = this.modules.get(i);
                data = module.getData();
                if (data == null || !data.haveModels(this.isPlaceholder)) continue;
                ArrayList<ModelCartbase> models = new ArrayList<ModelCartbase>();
                for (String str : data.getModels(this.isPlaceholder).keySet()) {
                    if (invalid.contains(str)) continue;
                    models.add(data.getModels(this.isPlaceholder).get(str));
                    invalid.add(str);
                }
                if (models.size() <= 0) continue;
                module.setModels(models);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player) {
        return new GuiMinecart(player.field_71071_by, this);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte(this.moduleLoadingData.length);
        for (byte b : this.moduleLoadingData) {
            data.writeByte((int)b);
        }
        data.writeByte(this.name.getBytes().length);
        for (byte b : this.name.getBytes()) {
            data.writeByte((int)b);
        }
    }

    public void readSpawnData(ByteBuf data) {
        byte length = data.readByte();
        byte[] bytes = new byte[length];
        data.readBytes(bytes);
        this.loadModules(bytes);
        int nameLength = data.readByte();
        byte[] nameBytes = new byte[nameLength];
        for (int i = 0; i < nameLength; ++i) {
            nameBytes[i] = data.readByte();
        }
        this.name = new String(nameBytes);
        if (this.func_70096_w() instanceof DataWatcherLockable) {
            ((DataWatcherLockable)this.func_70096_w()).release();
        }
    }

    public void setScrollY(int val) {
        if (this.canScrollModules) {
            this.scrollY = val;
        }
    }

    public int getScrollY() {
        if (this.getInterfaceThief() != null) {
            return 0;
        }
        return this.scrollY;
    }

    public int getRealScrollY() {
        return (int)((float)(this.modularSpaceHeight - 168) / 198.0f * (float)this.getScrollY());
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int amount = 0;
        if (resource != null && resource.amount > 0) {
            FluidStack fluid = resource.copy();
            for (int i = 0; i < this.tankModules.size(); ++i) {
                int tempAmount = this.tankModules.get(i).fill(fluid, doFill);
                amount += tempAmount;
                fluid.amount -= tempAmount;
                if (fluid.amount <= 0) break;
            }
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(from, null, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource, resource == null ? 0 : resource.amount, doDrain);
    }

    private FluidStack drain(ForgeDirection from, FluidStack resource, int maxDrain, boolean doDrain) {
        FluidStack ret = resource;
        if (ret != null) {
            ret = ret.copy();
            ret.amount = 0;
        }
        for (int i = 0; i < this.tankModules.size(); ++i) {
            FluidStack temp = null;
            temp = this.tankModules.get(i).drain(maxDrain, doDrain);
            if (temp == null || ret != null && !ret.isFluidEqual(temp)) continue;
            if (ret == null) {
                ret = temp;
            } else {
                ret.amount += temp.amount;
            }
            if ((maxDrain -= temp.amount) <= 0) break;
        }
        if (ret != null && ret.amount == 0) {
            return null;
        }
        return ret;
    }

    public int drain(Fluid type, int maxDrain, boolean doDrain) {
        int amount = 0;
        if (type != null && maxDrain > 0) {
            for (ModuleTank tank : this.tankModules) {
                FluidStack drained = tank.drain(maxDrain, false);
                if (drained == null || !type.equals(drained.getFluid())) continue;
                amount += drained.amount;
                maxDrain -= drained.amount;
                if (doDrain) {
                    tank.drain(drained.amount, true);
                }
                if (maxDrain > 0) continue;
                break;
            }
        }
        return amount;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        FluidTankInfo[] ret = new FluidTankInfo[this.tankModules.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new FluidTankInfo(this.tankModules.get(i).getFluid(), this.tankModules.get(i).getCapacity());
        }
        return ret;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (this.modules != null) {
            for (ModuleBase module : this.modules) {
                if (slot < module.getInventorySize()) {
                    return module.getSlots().get(slot).func_75214_a(item);
                }
                slot -= module.getInventorySize();
            }
        }
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return "container.modularcart";
    }

    public String getCartName() {
        if (this.name == null || this.name.length() == 0) {
            return "Modular Cart";
        }
        return this.name;
    }

    public boolean hasCreativeSupplies() {
        return this.creativeSupplies != null;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSound(MovingSound sound, boolean riding) {
        if (riding) {
            this.soundRiding = sound;
        } else {
            this.sound = sound;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void silent() {
        this.keepSilent = 6;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSounds() {
        if (this.keepSilent > 1) {
            --this.keepSilent;
            this.stopSound(this.sound);
            this.stopSound(this.soundRiding);
            this.sound = null;
            this.soundRiding = null;
        } else if (this.keepSilent == 1) {
            this.keepSilent = 0;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundMinecart((EntityMinecart)this));
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundMinecartRiding((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (EntityMinecart)this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopSound(MovingSound sound) {
        if (sound != null) {
            ReflectionHelper.setPrivateValue(MovingSound.class, (Object)sound, (Object)true, (int)0);
        }
    }
}

