/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Realtimers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.ModuleBase;

public class ModuleExperience
extends ModuleBase {
    private static final int MAX_EXPERIENCE_AMOUNT = 1500;
    private int experienceAmount;

    public ModuleExperience(MinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (!this.getCart().field_70170_p.field_72995_K) {
            List list = this.getCart().field_70170_p.func_72839_b((Entity)this.getCart(), this.getCart().field_70121_D.func_72314_b(3.0, 1.0, 3.0));
            for (int e = 0; e < list.size(); ++e) {
                if (!(list.get(e) instanceof EntityXPOrb)) continue;
                this.experienceAmount += ((EntityXPOrb)list.get(e)).func_70526_d();
                if (this.experienceAmount > 1500) {
                    this.experienceAmount = 1500;
                    continue;
                }
                ((Entity)list.get(e)).func_70106_y();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, Localization.MODULES.ATTACHMENTS.EXPERIENCE_LEVEL.translate(String.valueOf(this.experienceAmount), String.valueOf(1500)) + "\n" + Localization.MODULES.ATTACHMENTS.EXPERIENCE_EXTRACT.translate(new String[0]) + "\n" + Localization.MODULES.ATTACHMENTS.EXPERIENCE_PLAYER_LEVEL.translate(String.valueOf(this.getClientPlayer().field_71068_ca)), x, y, this.getContainerRect());
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.experienceAmount);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.experienceAmount = data;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ATTACHMENTS.EXPERIENCE.translate(new String[0]), 8, 6, 0x404040);
    }

    private int[] getContainerRect() {
        return new int[]{10, 15, 26, 65};
    }

    private int[] getContentRect(float part) {
        int[] cont = this.getContainerRect();
        int normalHeight = cont[3] - 4;
        int currentHeight = (int)((float)normalHeight * part);
        return new int[]{cont[0] + 2, cont[1] + 2 + normalHeight - currentHeight, cont[2] - 4, currentHeight, normalHeight};
    }

    private void drawContent(GuiMinecart gui, int x, int y, int id) {
        int lowerLevel = id * 1500 / 3;
        int currentLevel = this.experienceAmount - lowerLevel;
        float part = 3.0f * (float)currentLevel / 1500.0f;
        if (part > 1.0f) {
            part = 1.0f;
        }
        int[] content = this.getContentRect(part);
        this.drawImage(gui, content, 4 + content[2] * (id + 1), content[4] - content[3]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/experience.png");
        for (int i = 0; i < 3; ++i) {
            this.drawContent(gui, x, y, i);
        }
        this.drawImage(gui, this.getContainerRect(), 0, this.inRect(x, y, this.getContainerRect()) ? 65 : 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (this.inRect(x, y, this.getContainerRect())) {
            this.sendPacket(0);
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public int guiWidth() {
        return 70;
    }

    @Override
    public int guiHeight() {
        return 84;
    }

    @Override
    protected int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            player.func_71023_q(Math.min(this.experienceAmount, 50));
            this.experienceAmount -= Math.min(this.experienceAmount, 50);
        }
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.experienceAmount = tagCompound.func_74765_d(this.generateNBTName("Experience", id));
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74777_a(this.generateNBTName("Experience", id), (short)this.experienceAmount);
    }
}

