/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentMenuBUDs;
import vswe.stevesfactory.components.ComponentMenuCamouflage;
import vswe.stevesfactory.components.ComponentMenuCamouflageInside;
import vswe.stevesfactory.components.ComponentMenuCamouflageItems;
import vswe.stevesfactory.components.ComponentMenuCamouflageShape;
import vswe.stevesfactory.components.ComponentMenuCamouflageSides;
import vswe.stevesfactory.components.ComponentMenuContainerScrap;
import vswe.stevesfactory.components.ComponentMenuContainerTypes;
import vswe.stevesfactory.components.ComponentMenuContainerTypesVariable;
import vswe.stevesfactory.components.ComponentMenuCrafting;
import vswe.stevesfactory.components.ComponentMenuCraftingPriority;
import vswe.stevesfactory.components.ComponentMenuEmitters;
import vswe.stevesfactory.components.ComponentMenuGroup;
import vswe.stevesfactory.components.ComponentMenuInterval;
import vswe.stevesfactory.components.ComponentMenuInventory;
import vswe.stevesfactory.components.ComponentMenuInventoryCondition;
import vswe.stevesfactory.components.ComponentMenuItem;
import vswe.stevesfactory.components.ComponentMenuItemCondition;
import vswe.stevesfactory.components.ComponentMenuItemOutput;
import vswe.stevesfactory.components.ComponentMenuLiquid;
import vswe.stevesfactory.components.ComponentMenuLiquidCondition;
import vswe.stevesfactory.components.ComponentMenuLiquidOutput;
import vswe.stevesfactory.components.ComponentMenuListOrder;
import vswe.stevesfactory.components.ComponentMenuListOrderVariable;
import vswe.stevesfactory.components.ComponentMenuNodes;
import vswe.stevesfactory.components.ComponentMenuPulse;
import vswe.stevesfactory.components.ComponentMenuReceivers;
import vswe.stevesfactory.components.ComponentMenuRedstoneOutput;
import vswe.stevesfactory.components.ComponentMenuRedstoneSidesEmitter;
import vswe.stevesfactory.components.ComponentMenuRedstoneSidesNodes;
import vswe.stevesfactory.components.ComponentMenuRedstoneSidesTrigger;
import vswe.stevesfactory.components.ComponentMenuRedstoneStrength;
import vswe.stevesfactory.components.ComponentMenuRedstoneStrengthNodes;
import vswe.stevesfactory.components.ComponentMenuResult;
import vswe.stevesfactory.components.ComponentMenuSignText;
import vswe.stevesfactory.components.ComponentMenuSigns;
import vswe.stevesfactory.components.ComponentMenuSplit;
import vswe.stevesfactory.components.ComponentMenuTank;
import vswe.stevesfactory.components.ComponentMenuTankCondition;
import vswe.stevesfactory.components.ComponentMenuTargetInventory;
import vswe.stevesfactory.components.ComponentMenuTargetTank;
import vswe.stevesfactory.components.ComponentMenuUpdateBlock;
import vswe.stevesfactory.components.ComponentMenuVariable;
import vswe.stevesfactory.components.ComponentMenuVariableContainers;
import vswe.stevesfactory.components.ComponentMenuVariableLoop;
import vswe.stevesfactory.components.ConnectionSet;

public enum ComponentType {
    TRIGGER(0, Localization.TRIGGER_SHORT, Localization.TRIGGER_LONG, new ConnectionSet[]{ConnectionSet.CONTINUOUSLY, ConnectionSet.REDSTONE, ConnectionSet.BUD}, ComponentMenuReceivers.class, ComponentMenuBUDs.class, ComponentMenuInterval.class, ComponentMenuRedstoneSidesTrigger.class, ComponentMenuRedstoneStrength.class, ComponentMenuUpdateBlock.class, ComponentMenuResult.class),
    INPUT(1, Localization.INPUT_SHORT, Localization.INPUT_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuInventory.class, ComponentMenuTargetInventory.class, ComponentMenuItem.class, ComponentMenuResult.class),
    OUTPUT(2, Localization.OUTPUT_SHORT, Localization.OUTPUT_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuInventory.class, ComponentMenuTargetInventory.class, ComponentMenuItemOutput.class, ComponentMenuResult.class),
    CONDITION(3, Localization.CONDITION_SHORT, Localization.CONDITION_LONG, new ConnectionSet[]{ConnectionSet.STANDARD_CONDITION}, ComponentMenuInventoryCondition.class, ComponentMenuTargetInventory.class, ComponentMenuItemCondition.class, ComponentMenuResult.class),
    FLOW_CONTROL(4, Localization.FLOW_CONTROL_SHORT, Localization.FLOW_CONTROL_LONG, new ConnectionSet[]{ConnectionSet.MULTIPLE_INPUT_2, ConnectionSet.MULTIPLE_INPUT_5, ConnectionSet.MULTIPLE_OUTPUT_2, ConnectionSet.MULTIPLE_OUTPUT_5}, ComponentMenuSplit.class, ComponentMenuResult.class),
    LIQUID_INPUT(5, Localization.LIQUID_INPUT_SHORT, Localization.LIQUID_INPUT_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuTank.class, ComponentMenuTargetTank.class, ComponentMenuLiquid.class, ComponentMenuResult.class),
    LIQUID_OUTPUT(6, Localization.LIQUID_OUTPUT_SHORT, Localization.LIQUID_OUTPUT_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuTank.class, ComponentMenuTargetTank.class, ComponentMenuLiquidOutput.class, ComponentMenuResult.class),
    LIQUID_CONDITION(7, Localization.LIQUID_CONDITION_SHORT, Localization.LIQUID_CONDITION_LONG, new ConnectionSet[]{ConnectionSet.STANDARD_CONDITION}, ComponentMenuTankCondition.class, ComponentMenuTargetTank.class, ComponentMenuLiquidCondition.class, ComponentMenuResult.class),
    REDSTONE_EMITTER(8, Localization.REDSTONE_EMITTER_SHORT, Localization.REDSTONE_EMITTER_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuEmitters.class, ComponentMenuRedstoneSidesEmitter.class, ComponentMenuRedstoneOutput.class, ComponentMenuPulse.class, ComponentMenuResult.class),
    REDSTONE_CONDITION(9, Localization.REDSTONE_CONDITION_SHORT, Localization.REDSTONE_CONDITION_LONG, new ConnectionSet[]{ConnectionSet.STANDARD_CONDITION}, ComponentMenuNodes.class, ComponentMenuRedstoneSidesNodes.class, ComponentMenuRedstoneStrengthNodes.class, ComponentMenuResult.class),
    VARIABLE(10, Localization.CONTAINER_VARIABLE_SHORT, Localization.CONTAINER_VARIABLE_LONG, new ConnectionSet[]{ConnectionSet.EMPTY, ConnectionSet.STANDARD}, ComponentMenuVariable.class, ComponentMenuContainerTypesVariable.class, ComponentMenuVariableContainers.class, ComponentMenuListOrderVariable.class, ComponentMenuResult.class),
    FOR_EACH(11, Localization.FOR_EACH_LOOP_SHORT, Localization.FOR_EACH_LOOP_LONG, new ConnectionSet[]{ConnectionSet.FOR_EACH}, ComponentMenuVariableLoop.class, ComponentMenuContainerTypes.class, ComponentMenuListOrder.class, ComponentMenuResult.class),
    AUTO_CRAFTING(12, Localization.AUTO_CRAFTER_SHORT, Localization.AUTO_CRAFTER_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuCrafting.class, ComponentMenuCraftingPriority.class, ComponentMenuContainerScrap.class, ComponentMenuResult.class),
    GROUP(13, Localization.GROUP_SHORT, Localization.GROUP_LONG, new ConnectionSet[]{ConnectionSet.DYNAMIC}, ComponentMenuGroup.class, ComponentMenuResult.class),
    NODE(14, Localization.NODE_SHORT, Localization.NODE_LONG, new ConnectionSet[]{ConnectionSet.INPUT_NODE, ConnectionSet.OUTPUT_NODE}, ComponentMenuResult.class),
    CAMOUFLAGE(15, Localization.CAMOUFLAGE_SHORT, Localization.CAMOUFLAGE_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuCamouflage.class, ComponentMenuCamouflageShape.class, ComponentMenuCamouflageInside.class, ComponentMenuCamouflageSides.class, ComponentMenuCamouflageItems.class, ComponentMenuResult.class),
    SIGN(16, Localization.SIGN_SHORT, Localization.SIGN_LONG, new ConnectionSet[]{ConnectionSet.STANDARD}, ComponentMenuSigns.class, ComponentMenuSignText.class, ComponentMenuResult.class);

    private Class<? extends ComponentMenu>[] classes;
    private int id;
    private ConnectionSet[] sets;
    private Localization name;
    private Localization longName;

    private ComponentType(int id, Localization name, Localization longName, ConnectionSet[] sets, Class<? extends ComponentMenu> ... classes) {
        this.classes = classes;
        this.id = id;
        this.sets = sets;
        this.name = name;
        this.longName = longName;
    }

    public Class<? extends ComponentMenu>[] getClasses() {
        return this.classes;
    }

    public int getId() {
        return this.id;
    }

    public static ComponentType getTypeFromId(int id) {
        for (ComponentType componentType : ComponentType.values()) {
            if (id != componentType.id) continue;
            return componentType;
        }
        return null;
    }

    public ConnectionSet[] getSets() {
        return this.sets;
    }

    public String getName() {
        return this.name.toString();
    }

    public String getLongName() {
        return this.longName.toString();
    }

    public String toString() {
        return this.getName() + "[" + this.getLongName() + "]";
    }

    public Localization getLongUnLocalizedName() {
        return this.longName;
    }
}

