/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.animation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentType;
import vswe.stevesfactory.components.Connection;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.Point;

public class AnimationController {
    private final TileEntityManager manager;
    private List<FlowComponent> blueprints;
    private List<FlowComponent> items;
    private FlowComponent target;
    private FlowComponent blueprint;
    private Progress progress = Progress.GROUP;
    private float delay;
    private int targetConnectionX;
    private int targetConnectionY;
    private boolean setMenuInfo;
    private int menuId;
    private List<FlowComponent> groupTracking;
    private boolean openNext;
    private int virtualId;
    private int mult;
    Map<Integer, Integer> groupNodes = new HashMap<Integer, Integer>();
    private float time;
    private static final int MOVE_SPEED = 300;
    private static final int MOVE_SPEED_CONNECTION = 300;
    private static final int MOVE_SPEED_NODE = 250;
    private int connectionX;
    private int connectionY;
    private Point blueprintNode;
    private List<Point> nodesBlueprint;
    private Connection nodesConnection;

    public AnimationController(TileEntityManager manager, int mult) {
        this.manager = manager;
        this.mult = mult;
        this.blueprints = new ArrayList<FlowComponent>();
        HashMap<Integer, Integer> ids = new HashMap<Integer, Integer>();
        HashMap<Integer, List<FlowComponent>> groups = new HashMap<Integer, List<FlowComponent>>();
        for (FlowComponent c : manager.getFlowItems()) {
            FlowComponent component = c.copy();
            if (c.getParent() != null) {
                int oldId = c.getParent().getId();
                Integer id = (Integer)ids.get(oldId);
                if (id == null) {
                    if (groups.get(oldId) == null) {
                        groups.put(oldId, new ArrayList());
                    }
                    ((List)groups.get(oldId)).add(component);
                    continue;
                }
                component.setParent(this.blueprints.get(id));
            }
            this.addComponent(component, ids, groups);
        }
        for (FlowComponent item : this.blueprints) {
            for (int i = 0; i < item.getConnectionSet().getConnections().length; ++i) {
                Connection connection = item.getConnection(i);
                if (connection == null) continue;
                connection.setComponentId((Integer)ids.get(connection.getComponentId()));
            }
        }
        for (FlowComponent item : this.blueprints) {
            if (item.getParent() == null || item.getType() != ComponentType.NODE) continue;
            int id = item.getParent().getId();
            Integer count = this.groupNodes.get(id);
            if (count == null) {
                this.groupNodes.put(id, 1);
                continue;
            }
            this.groupNodes.put(id, count + 1);
        }
        this.items = new ArrayList<FlowComponent>(this.blueprints);
        manager.getFlowItems().clear();
        manager.getZLevelRenderingList().clear();
        for (FlowComponent flowComponent : manager.getFlowItems()) {
            manager.getZLevelRenderingList().add(0, flowComponent);
        }
        manager.setSelectedComponent(null);
    }

    private void addComponent(FlowComponent component, Map<Integer, Integer> ids, Map<Integer, List<FlowComponent>> groups) {
        int oldId = component.getId();
        int newId = this.blueprints.size();
        ids.put(oldId, newId);
        component.setId(newId);
        this.blueprints.add(component);
        if (groups.get(oldId) != null) {
            for (FlowComponent o : groups.get(oldId)) {
                o.setParent(component);
                this.addComponent(o, ids, groups);
            }
        }
    }

    public void update(float elapsedSeconds) {
        this.time += elapsedSeconds * (float)this.mult;
        while (this.execute()) {
        }
    }

    private boolean execute() {
        if (this.delay != 0.0f) {
            float rem = Math.min(this.delay, this.time);
            this.delay -= rem;
            this.time -= rem;
            if (this.delay != 0.0f) {
                return false;
            }
        }
        if (this.time <= 0.0f) {
            this.time = 0.0f;
            return false;
        }
        switch (this.progress) {
            case GROUP: {
                int index;
                if (this.groupTracking != null) {
                    if (this.groupTracking.size() > 0) {
                        if (!this.openNext) {
                            for (FlowComponent component : this.manager.getFlowItems()) {
                                component.close();
                            }
                            if (this.groupTracking.get(0) != null && this.groupTracking.get(0).isVisible()) {
                                this.manager.getFlowItems().get(this.groupTracking.get(0).getId()).setOpen(true);
                                this.manager.getFlowItems().get(this.groupTracking.get(0).getId()).setOpenMenuId(0);
                                this.moveToFront(this.groupTracking.get(0));
                            }
                            this.openNext = true;
                        } else {
                            if (this.groupTracking.get(0) != null) {
                                this.manager.getFlowItems().get(this.groupTracking.get(0).getId()).setOpen(false);
                            }
                            if (this.manager.getSelectedComponent() != null && this.manager.getSelectedComponent().isVisible(this.groupTracking.get(0))) {
                                this.manager.getFlowItems().get(this.manager.getSelectedComponent().getId()).setOpen(true);
                                this.manager.getFlowItems().get(this.manager.getSelectedComponent().getId()).setOpenMenuId(0);
                                this.moveToFront(this.manager.getSelectedComponent());
                            }
                            this.manager.setSelectedComponent(this.groupTracking.remove(0));
                            this.openNext = false;
                        }
                    } else {
                        for (FlowComponent component : this.manager.getFlowItems()) {
                            component.close();
                        }
                        this.groupTracking = null;
                        this.progress = Progress.PLACE;
                    }
                    this.delay = 0.5f;
                    return true;
                }
                if (!(this.time >= 0.5f) || this.items.size() <= 0) break;
                this.time -= 0.5f;
                this.blueprint = this.items.remove(0);
                ArrayList<FlowComponent> parents = new ArrayList<FlowComponent>();
                for (FlowComponent temp = this.blueprint; temp != null; temp = temp.getParent()) {
                    parents.add(temp);
                }
                FlowComponent current = this.manager.getSelectedComponent();
                this.groupTracking = new ArrayList<FlowComponent>();
                while ((index = parents.indexOf(current)) == -1) {
                    current = current.getParent();
                    this.groupTracking.add(current);
                }
                for (int i = index - 1; i >= 0; --i) {
                    this.groupTracking.add((FlowComponent)parents.get(i));
                }
                if (this.groupTracking.size() == 0) {
                    this.groupTracking = null;
                    this.progress = Progress.PLACE;
                }
                return true;
            }
            case PLACE: {
                this.target = new FlowComponent(this.manager, 50, 50, this.blueprint.getType());
                this.manager.getFlowItems().add(this.target);
                this.target.setId(this.blueprint.getId());
                if (this.blueprint.getParent() != null) {
                    this.target.setParent(this.manager.getFlowItems().get(this.blueprint.getParent().getId()));
                }
                this.manager.getZLevelRenderingList().add(0, this.target);
                this.virtualId = this.target.getId();
                this.progress = Progress.POSITION;
                this.delay = 0.25f;
                return true;
            }
            case POSITION: {
                int distanceX = this.blueprint.getX() - this.target.getX();
                int distanceY = this.blueprint.getY() - this.target.getY();
                float distance = (float)Math.sqrt(Math.pow(distanceX, 2.0) + Math.pow(distanceY, 2.0));
                if (distance < 1.0f) {
                    this.target.setX(this.blueprint.getX());
                    this.target.setY(this.blueprint.getY());
                    this.progress = this.target.getType() == ComponentType.GROUP && this.target.getName().equals(this.blueprint.getName()) ? Progress.CLOSE : Progress.OPEN;
                    this.delay = 0.25f + distance * 300.0f;
                    return true;
                }
                float timeMovement = this.time * 300.0f;
                float movement = Math.min(distance, timeMovement);
                this.target.setX(this.target.getX() + (int)((float)distanceX * (movement / distance)));
                this.target.setY(this.target.getY() + (int)((float)distanceY * (movement / distance)));
                this.time = Math.max(0.0f, this.time - movement / 300.0f);
                return true;
            }
            case OPEN: {
                this.target.setOpen(true);
                this.delay = 0.15f;
                this.progress = Progress.RENAME;
                return true;
            }
            case RENAME: {
                if (this.target.getName().equals(this.blueprint.getName())) {
                    this.progress = this.target.getType() == ComponentType.GROUP ? Progress.CLOSE : Progress.MENUS;
                    this.menuId = this.target.getMenus().size() - 1;
                    this.target.setNameEdited(false);
                    this.delay = 0.5f;
                } else {
                    if (!this.target.isNameBeingEdited()) {
                        this.target.setNameEdited(true);
                        this.delay = 0.5f;
                        return true;
                    }
                    String name = this.target.getComponentName();
                    if (name == null) {
                        name = "";
                    }
                    name = name + this.blueprint.getComponentName().charAt(name.length());
                    this.target.setComponentName(name);
                    this.target.refreshEditing(name);
                    this.delay = 0.1f;
                }
                return true;
            }
            case MENUS: {
                ComponentMenu menu = this.target.getMenus().get(this.menuId);
                if (menu.isVisible()) {
                    if (this.target.getOpenMenuId() == menu.getId()) {
                        if (!this.setMenuInfo) {
                            this.setMenuInfo = true;
                            menu.copyFrom(this.blueprint.getMenus().get(menu.getId()));
                            this.delay = 0.5f;
                            return true;
                        }
                    } else {
                        this.setMenuInfo = false;
                        this.target.setOpenMenuId(menu.getId());
                        this.delay = 0.5f;
                        return true;
                    }
                    this.target.setOpenMenuId(-1);
                    this.delay = 0.5f;
                }
                if (this.target.getMenus().size() == 1 || this.menuId == this.target.getMenus().size() - 2) {
                    this.progress = Progress.CLOSE;
                } else {
                    this.menuId = (this.menuId + 1) % this.target.getMenus().size();
                }
                this.delay = 0.2f;
                return true;
            }
            case CLOSE: {
                this.target.setOpen(false);
                this.delay = 0.15f;
                this.progress = Progress.CONNECT;
                return true;
            }
            case CONNECT: {
                if (this.target.getType() != ComponentType.GROUP || this.groupNodes.get(this.target.getId()) == null) {
                    this.target.setOpen(false);
                    if (this.manager.getCurrentlyConnecting() != null) {
                        int distanceX = this.targetConnectionX - this.target.getOverrideX();
                        int distanceY = this.targetConnectionY - this.target.getOverrideY();
                        float distance = (float)Math.sqrt(Math.pow(distanceX, 2.0) + Math.pow(distanceY, 2.0));
                        if (distance < 1.0f) {
                            int connectionId = this.manager.getCurrentlyConnecting().getConnectionId();
                            Connection connection = this.blueprint.getConnection(connectionId).copy();
                            this.target.setConnection(connectionId, connection);
                            this.manager.getFlowItems().get(connection.getComponentId()).setConnection(connection.getConnectionId(), this.manager.getCurrentlyConnecting());
                            this.manager.setCurrentlyConnecting(null);
                            this.delay = 0.25f + distance / 300.0f;
                            return true;
                        }
                        float timeMovement = this.time * 300.0f;
                        float movement = Math.min(distance, timeMovement);
                        this.target.setOverrideX(this.target.getOverrideX() + (int)((float)distanceX * (movement / distance)));
                        this.target.setOverrideY(this.target.getOverrideY() + (int)((float)distanceY * (movement / distance)));
                        this.time = Math.max(0.0f, this.time - movement / 300.0f);
                        break;
                    }
                    for (int i = 0; i < this.blueprint.getConnectionSet().getConnections().length; ++i) {
                        Connection connection;
                        if (this.target.getConnection(i) != null || (connection = this.blueprint.getConnection(i)) == null || connection.getComponentId() >= this.virtualId || this.groupNodes.get(connection.getComponentId()) != null) continue;
                        int[] location = this.target.getConnectionLocationFromId(i);
                        if (location != null) {
                            this.manager.setCurrentlyConnecting(new Connection(this.target.getId(), i));
                            this.target.setOverrideX(location[0] + location[3] / 2);
                            this.target.setOverrideY(location[1] + location[4] / 2);
                            int[] targetConnectionLocation = this.manager.getFlowItems().get(connection.getComponentId()).getConnectionLocationFromId(connection.getConnectionId());
                            this.targetConnectionX = targetConnectionLocation[0] + targetConnectionLocation[3] / 2;
                            this.targetConnectionY = targetConnectionLocation[1] + targetConnectionLocation[4] / 2;
                            return true;
                        }
                        this.blueprint.setConnection(i, null);
                    }
                    if (this.target.getType() == ComponentType.NODE && this.target.getParent() != null) {
                        int id = this.target.getParent().getId();
                        Integer count = this.groupNodes.get(id);
                        if (count == 1) {
                            this.groupNodes.put(id, null);
                            this.target = this.target.getParent();
                            this.blueprint = this.blueprints.get(this.target.getId());
                            this.manager.setSelectedComponent(this.target.getParent());
                            this.progress = Progress.CONNECT;
                            this.target.setOpen(true);
                            this.target.setOpenMenuId(0);
                            this.moveToFront(this.target);
                            this.delay = 0.75f;
                            return true;
                        }
                        this.groupNodes.put(id, count - 1);
                    }
                    this.progress = Progress.NODES;
                    return true;
                }
                this.progress = Progress.NODES;
                return true;
            }
            case NODES: {
                if (this.nodesConnection != null) {
                    if (this.blueprintNode == null) {
                        if (this.nodesBlueprint.size() == 0) {
                            this.nodesConnection = null;
                            return true;
                        }
                        this.blueprintNode = this.nodesBlueprint.remove(0);
                        if (this.nodesConnection.getNodes().size() == 0) {
                            this.nodesConnection.addAndSelectNode(this.connectionX, this.connectionY, 0);
                        } else {
                            this.nodesConnection.addAndSelectNode(this.nodesConnection.getNodes().get(0).getX(), this.nodesConnection.getNodes().get(0).getY(), 0);
                        }
                        this.delay = 0.2f;
                        return true;
                    }
                    Point node = this.nodesConnection.getSelectedNode();
                    int distanceX = this.blueprintNode.getX() - node.getX();
                    int distanceY = this.blueprintNode.getY() - node.getY();
                    float distance = (float)Math.sqrt(Math.pow(distanceX, 2.0) + Math.pow(distanceY, 2.0));
                    if (distance < 1.0f) {
                        node.setX(this.blueprintNode.getX());
                        node.setY(this.blueprintNode.getY());
                        this.nodesConnection.setSelectedNode(null);
                        this.blueprintNode = null;
                        this.delay = distance / 250.0f;
                        return true;
                    }
                    float timeMovement = this.time * 250.0f;
                    float movement = Math.min(distance, timeMovement);
                    node.setX(node.getX() + (int)((float)distanceX * (movement / distance)));
                    node.setY(node.getY() + (int)((float)distanceY * (movement / distance)));
                    this.time = Math.max(0.0f, this.time - movement / 250.0f);
                    break;
                }
                for (int i = 0; i < this.target.getConnectionSet().getConnections().length; ++i) {
                    Connection targetConnection;
                    if (this.target.getConnection(i) == null) continue;
                    boolean reverse = this.target.getId() >= this.target.getConnection(i).getComponentId();
                    FlowComponent other = this.blueprints.get(this.target.getConnection(i).getComponentId());
                    FlowComponent otherTarget = this.manager.getFlowItems().get(this.target.getConnection(i).getComponentId());
                    Connection connection = reverse ? other.getConnection(this.target.getConnection(i).getConnectionId()) : this.blueprint.getConnection(i);
                    Connection connection2 = targetConnection = reverse ? otherTarget.getConnection(this.target.getConnection(i).getConnectionId()) : this.target.getConnection(i);
                    if (!targetConnection.getNodes().isEmpty() || connection.getNodes().isEmpty()) continue;
                    this.nodesConnection = targetConnection;
                    this.nodesBlueprint = new ArrayList<Point>(connection.getNodes());
                    System.out.println(this.nodesBlueprint.size());
                    if (reverse) {
                        Collections.reverse(this.nodesBlueprint);
                    }
                    int[] location = reverse ? other.getConnectionLocationFromId(this.target.getConnection(i).getConnectionId()) : this.target.getConnectionLocationFromId(i);
                    this.connectionX = location[0] + location[3] / 2;
                    this.connectionY = location[1] + location[4] / 2;
                    return true;
                }
                this.progress = Progress.GROUP;
                return true;
            }
        }
        return false;
    }

    private void moveToFront(FlowComponent c) {
        FlowComponent component = this.manager.getFlowItems().get(c.getId());
        this.manager.getZLevelRenderingList().remove(c);
        this.manager.getZLevelRenderingList().add(0, component);
    }

    private static enum Progress {
        GROUP,
        PLACE,
        POSITION,
        OPEN,
        RENAME,
        MENUS,
        CLOSE,
        CONNECT,
        NODES;

    }
}

