/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.RadioButton;
import vswe.stevesfactory.components.RadioButtonList;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

public class ComponentMenuCraftingPriority
extends ComponentMenu {
    private static final int RADIO_X = 5;
    private static final int RADIO_Y = 5;
    private static final int RADIO_MARGIN = 13;
    private RadioButtonList radioButtons = new RadioButtonList(){

        @Override
        public void updateSelectedOption(int selectedOption) {
            DataWriter dw = ComponentMenuCraftingPriority.this.getWriterForServerComponentPacket();
            dw.writeBoolean(selectedOption == 0);
            PacketHandler.sendDataToServer(dw);
        }
    };
    private static final String NBT_SELECTED = "SelectedOption";

    public ComponentMenuCraftingPriority(FlowComponent parent) {
        super(parent);
        this.radioButtons.add(new RadioButton(5, 5, Localization.PRIORITY_MOVE_FIRST));
        this.radioButtons.add(new RadioButton(5, 18, Localization.PRIORITY_CRAFT_FIRST));
    }

    @Override
    public String getName() {
        return "Priority";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        this.radioButtons.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.radioButtons.onClick(mX, mY, button);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeBoolean(this.radioButtons.getSelectedOption() == 0);
    }

    @Override
    public void readData(DataReader dr) {
        this.radioButtons.setSelectedOption(dr.readBoolean() ? 0 : 1);
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        this.radioButtons.setSelectedOption(((ComponentMenuCraftingPriority)menu).radioButtons.getSelectedOption());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuCraftingPriority newDataPriority = (ComponentMenuCraftingPriority)newData;
        if (this.radioButtons.getSelectedOption() != newDataPriority.radioButtons.getSelectedOption()) {
            this.radioButtons.setSelectedOption(newDataPriority.radioButtons.getSelectedOption());
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeBoolean(this.radioButtons.getSelectedOption() == 0);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.radioButtons.setSelectedOption(nbtTagCompound.func_74771_c(NBT_SELECTED));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a(NBT_SELECTED, (byte)this.radioButtons.getSelectedOption());
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        this.radioButtons.setSelectedOption(dr.readBoolean() ? 0 : 1);
    }

    public boolean shouldPrioritizeCrafting() {
        return this.radioButtons.getSelectedOption() == 1;
    }

    public void setPrioritizeCrafting(boolean val) {
        this.radioButtons.setSelectedOption(val ? 1 : 0);
    }
}

