/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.IFrontRotation;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;

public final class Util {
    private static final Pattern matchE_ = Pattern.compile("(E,(E,)+)");

    private Util() {
    }

    public static String intBitsToString(int number) {
        StringBuilder result = new StringBuilder(16);
        for (int i = 31; i >= 0; --i) {
            int mask = 1 << i;
            result.append((number & mask) != 0 ? "1" : "0");
            if (i % 8 != 0) continue;
            result.append(' ');
        }
        result.replace(result.length() - 1, result.length(), "");
        return result.toString();
    }

    public static String intBitsToShortString(int number) {
        StringBuilder result = new StringBuilder(16);
        for (int i = 31; i >= 0; --i) {
            int mask = 1 << i;
            result.append((number & mask) != 0 ? ":" : ".");
            if (i % 8 != 0) continue;
            result.append('|');
        }
        result.replace(result.length() - 1, result.length(), "");
        return result.toString();
    }

    public static boolean StructureCheckerExtreme(String[][] structure, Block[] blockType, byte[] blockMeta, Method adder, String[] addingMethods, short[] casingTextures, Block[] blockTypeFallback, byte[] blockMetaFallback, int horizontalOffset, int verticalOffset, int depthOffset, IGregTechTileEntity aBaseMetaTileEntity, IFrontRotation frontRotation, boolean forceCheck) {
        World world = aBaseMetaTileEntity.getWorld();
        if (world.field_72995_K) {
            return false;
        }
        int facingAndRotation = aBaseMetaTileEntity.getFrontFacing() + (frontRotation == null ? 0 : frontRotation.getFrontRotation() << 3);
        IMetaTileEntity imt = aBaseMetaTileEntity.getMetaTileEntity();
        int baseX = aBaseMetaTileEntity.getXCoord();
        int baseZ = aBaseMetaTileEntity.getZCoord();
        short baseY = aBaseMetaTileEntity.getYCoord();
        int c = -depthOffset;
        for (String[] _structure : structure) {
            int b = verticalOffset;
            for (String __structure : _structure) {
                int a = -horizontalOffset;
                for (char block : __structure.toCharArray()) {
                    block57: {
                        block58: {
                            int y;
                            int z;
                            int x;
                            if (block < ' ') {
                                b -= block;
                                break;
                            }
                            if (block > '@') {
                                a += block - 64;
                                continue;
                            }
                            if (block == '.') {
                                ++a;
                                continue;
                            }
                            switch (facingAndRotation) {
                                case 4: {
                                    x = baseX + c;
                                    z = baseZ + a;
                                    y = baseY + b;
                                    break;
                                }
                                case 12: {
                                    x = baseX + c;
                                    y = baseY - a;
                                    z = baseZ + b;
                                    break;
                                }
                                case 20: {
                                    x = baseX + c;
                                    z = baseZ - a;
                                    y = baseY - b;
                                    break;
                                }
                                case 28: {
                                    x = baseX + c;
                                    y = baseY + a;
                                    z = baseZ - b;
                                    break;
                                }
                                case 3: {
                                    x = baseX + a;
                                    z = baseZ - c;
                                    y = baseY + b;
                                    break;
                                }
                                case 11: {
                                    y = baseY - a;
                                    z = baseZ - c;
                                    x = baseX + b;
                                    break;
                                }
                                case 19: {
                                    x = baseX - a;
                                    z = baseZ - c;
                                    y = baseY - b;
                                    break;
                                }
                                case 27: {
                                    y = baseY + a;
                                    z = baseZ - c;
                                    x = baseX - b;
                                    break;
                                }
                                case 5: {
                                    x = baseX - c;
                                    z = baseZ - a;
                                    y = baseY + b;
                                    break;
                                }
                                case 13: {
                                    x = baseX - c;
                                    y = baseY - a;
                                    z = baseZ - b;
                                    break;
                                }
                                case 21: {
                                    x = baseX - c;
                                    z = baseZ + a;
                                    y = baseY - b;
                                    break;
                                }
                                case 29: {
                                    x = baseX - c;
                                    y = baseY + a;
                                    z = baseZ + b;
                                    break;
                                }
                                case 2: {
                                    x = baseX - a;
                                    z = baseZ + c;
                                    y = baseY + b;
                                    break;
                                }
                                case 10: {
                                    y = baseY - a;
                                    z = baseZ + c;
                                    x = baseX - b;
                                    break;
                                }
                                case 18: {
                                    x = baseX + a;
                                    z = baseZ + c;
                                    y = baseY - b;
                                    break;
                                }
                                case 26: {
                                    y = baseY + a;
                                    z = baseZ + c;
                                    x = baseX + b;
                                    break;
                                }
                                case 1: {
                                    x = baseX + a;
                                    z = baseZ - b;
                                    y = baseY - c;
                                    break;
                                }
                                case 9: {
                                    z = baseZ + a;
                                    x = baseX + b;
                                    y = baseY - c;
                                    break;
                                }
                                case 17: {
                                    x = baseX - a;
                                    z = baseZ + b;
                                    y = baseY - c;
                                    break;
                                }
                                case 25: {
                                    z = baseZ - a;
                                    x = baseX - b;
                                    y = baseY - c;
                                    break;
                                }
                                case 0: {
                                    x = baseX - a;
                                    z = baseZ - b;
                                    y = baseY + c;
                                    break;
                                }
                                case 8: {
                                    z = baseZ + a;
                                    x = baseX - b;
                                    y = baseY + c;
                                    break;
                                }
                                case 16: {
                                    x = baseX + a;
                                    z = baseZ + b;
                                    y = baseY + c;
                                    break;
                                }
                                case 24: {
                                    z = baseZ - a;
                                    x = baseX + b;
                                    y = baseY + c;
                                    break;
                                }
                                default: {
                                    if (TecTechConfig.DEBUG_MODE) {
                                        TecTech.LOGGER.info((Object)("facing = " + facingAndRotation));
                                    }
                                    return false;
                                }
                            }
                            if (y < 0 || y >= 256) {
                                return false;
                            }
                            if (!world.func_72899_e(x, y, z)) break block58;
                            switch (block) {
                                case '-': {
                                    if (world.func_147439_a(x, y, z).func_149688_o() != Material.field_151579_a) {
                                        return false;
                                    }
                                    break block57;
                                }
                                case '+': {
                                    if (world.func_147439_a(x, y, z).func_149688_o() == Material.field_151579_a) {
                                        return false;
                                    }
                                    break block57;
                                }
                                default: {
                                    int pointer = block - 48;
                                    if (pointer >= 0) {
                                        if (world.func_147439_a(x, y, z) != blockType[pointer]) {
                                            if (TecTechConfig.DEBUG_MODE) {
                                                TecTech.LOGGER.info((Object)("Struct-block-error " + x + ' ' + y + ' ' + z + " / " + a + ' ' + b + ' ' + c + " / " + world.func_147439_a(x, y, z).func_149739_a() + ' ' + blockType[pointer].func_149739_a()));
                                            }
                                            return false;
                                        }
                                        if (world.func_72805_g(x, y, z) != blockMeta[pointer]) {
                                            if (TecTechConfig.DEBUG_MODE) {
                                                TecTech.LOGGER.info((Object)("Struct-meta-id-error " + x + ' ' + y + ' ' + z + " / " + a + ' ' + b + ' ' + c + " / " + world.func_72805_g(x, y, z) + ' ' + blockMeta[pointer]));
                                            }
                                            return false;
                                        }
                                    } else {
                                        pointer = block - 32;
                                        if (pointer >= 0) {
                                            IGregTechTileEntity igt = aBaseMetaTileEntity.getIGregTechTileEntity(x, y, z);
                                            try {
                                                if (igt == null || !((Boolean)adder.invoke((Object)imt, addingMethods[pointer], igt, casingTextures[pointer])).booleanValue()) {
                                                    if (world.func_147439_a(x, y, z) != blockTypeFallback[pointer]) {
                                                        if (TecTechConfig.DEBUG_MODE) {
                                                            TecTech.LOGGER.info((Object)("Fallback-struct-block-error " + x + ' ' + y + ' ' + z + " / " + a + ' ' + b + ' ' + c + " / " + world.func_147439_a(x, y, z).func_149739_a() + ' ' + (blockTypeFallback[pointer] == null ? "null" : blockTypeFallback[pointer].func_149739_a())));
                                                        }
                                                        return false;
                                                    }
                                                    if (world.func_72805_g(x, y, z) != blockMetaFallback[pointer]) {
                                                        if (TecTechConfig.DEBUG_MODE) {
                                                            TecTech.LOGGER.info((Object)("Fallback-Struct-meta-id-error " + x + ' ' + y + ' ' + z + " / " + a + ' ' + b + ' ' + c + " / " + world.func_72805_g(x, y, z) + ' ' + blockMetaFallback[pointer]));
                                                        }
                                                        return false;
                                                    }
                                                }
                                                break block57;
                                            }
                                            catch (IllegalAccessException | InvocationTargetException e) {
                                                if (TecTechConfig.DEBUG_MODE) {
                                                    e.printStackTrace();
                                                }
                                                return false;
                                            }
                                        }
                                    }
                                    break block57;
                                }
                            }
                        }
                        if (forceCheck) {
                            return false;
                        }
                    }
                    ++a;
                }
                --b;
            }
            ++c;
        }
        return true;
    }

    public static boolean StructureBuilder(String[][] structure, Block[] blockType, byte[] blockMeta, int horizontalOffset, int verticalOffset, int depthOffset, IGregTechTileEntity aBaseMetaTileEntity, boolean hintsOnly) {
        byte facing = aBaseMetaTileEntity.getFrontFacing();
        return Util.StructureBuilderExtreme(structure, blockType, blockMeta, horizontalOffset, verticalOffset, depthOffset, aBaseMetaTileEntity.getWorld().func_147438_o(aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord()), null, facing, hintsOnly);
    }

    public static boolean StructureBuilderExtreme(String[][] structure, Block[] blockType, byte[] blockMeta, int horizontalOffset, int verticalOffset, int depthOffset, IGregTechTileEntity aBaseMetaTileEntity, IFrontRotation frontRotation, boolean hintsOnly) {
        byte facing = aBaseMetaTileEntity.getFrontFacing();
        return Util.StructureBuilderExtreme(structure, blockType, blockMeta, horizontalOffset, verticalOffset, depthOffset, aBaseMetaTileEntity.getWorld().func_147438_o(aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord()), frontRotation, facing, hintsOnly);
    }

    public static boolean StructureBuilder(String[][] structure, Block[] blockType, byte[] blockMeta, int horizontalOffset, int verticalOffset, int depthOffset, TileEntity tileEntity, int facing, boolean hintsOnly) {
        return Util.StructureBuilderExtreme(structure, blockType, blockMeta, horizontalOffset, verticalOffset, depthOffset, tileEntity, null, facing, hintsOnly);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean StructureBuilderExtreme(String[][] structure, Block[] blockType, byte[] blockMeta, int horizontalOffset, int verticalOffset, int depthOffset, TileEntity tileEntity, IFrontRotation frontRotation, int facing, boolean hintsOnly) {
        if (!tileEntity.func_145830_o()) {
            return false;
        }
        World world = tileEntity.func_145831_w();
        if (!world.field_72995_K && hintsOnly) {
            return false;
        }
        int baseX = tileEntity.field_145851_c;
        int baseZ = tileEntity.field_145849_e;
        int baseY = tileEntity.field_145848_d;
        if (frontRotation != null) {
            facing += frontRotation.getFrontRotation() << 3;
        }
        int c = -depthOffset;
        String[][] stringArray = structure;
        int n = stringArray.length;
        int n2 = 0;
        block34: while (n2 < n) {
            String[] _structure = stringArray[n2];
            int b = verticalOffset;
            String[] stringArray2 = _structure;
            int n3 = stringArray2.length;
            int n4 = 0;
            while (true) {
                int n5;
                char[] cArray;
                int a;
                if (n4 < n3) {
                    String __structure = stringArray2[n4];
                    a = -horizontalOffset;
                    cArray = __structure.toCharArray();
                    n5 = cArray.length;
                } else {
                    ++c;
                    ++n2;
                    continue block34;
                }
                for (int i = 0; i < n5; ++i) {
                    int y;
                    int z;
                    int x;
                    char block = cArray[i];
                    if (block < ' ') {
                        b -= block;
                        break;
                    }
                    if (block > '@') {
                        a += block - 64;
                        continue;
                    }
                    if (block == '.') {
                        ++a;
                        continue;
                    }
                    switch (facing) {
                        case 4: {
                            x = baseX + c;
                            z = baseZ + a;
                            y = baseY + b;
                            break;
                        }
                        case 12: {
                            x = baseX + c;
                            y = baseY - a;
                            z = baseZ + b;
                            break;
                        }
                        case 20: {
                            x = baseX + c;
                            z = baseZ - a;
                            y = baseY - b;
                            break;
                        }
                        case 28: {
                            x = baseX + c;
                            y = baseY + a;
                            z = baseZ - b;
                            break;
                        }
                        case 3: {
                            x = baseX + a;
                            z = baseZ - c;
                            y = baseY + b;
                            break;
                        }
                        case 11: {
                            y = baseY - a;
                            z = baseZ - c;
                            x = baseX + b;
                            break;
                        }
                        case 19: {
                            x = baseX - a;
                            z = baseZ - c;
                            y = baseY - b;
                            break;
                        }
                        case 27: {
                            y = baseY + a;
                            z = baseZ - c;
                            x = baseX - b;
                            break;
                        }
                        case 5: {
                            x = baseX - c;
                            z = baseZ - a;
                            y = baseY + b;
                            break;
                        }
                        case 13: {
                            x = baseX - c;
                            y = baseY - a;
                            z = baseZ - b;
                            break;
                        }
                        case 21: {
                            x = baseX - c;
                            z = baseZ + a;
                            y = baseY - b;
                            break;
                        }
                        case 29: {
                            x = baseX - c;
                            y = baseY + a;
                            z = baseZ + b;
                            break;
                        }
                        case 2: {
                            x = baseX - a;
                            z = baseZ + c;
                            y = baseY + b;
                            break;
                        }
                        case 10: {
                            y = baseY - a;
                            z = baseZ + c;
                            x = baseX - b;
                            break;
                        }
                        case 18: {
                            x = baseX + a;
                            z = baseZ + c;
                            y = baseY - b;
                            break;
                        }
                        case 26: {
                            y = baseY + a;
                            z = baseZ + c;
                            x = baseX + b;
                            break;
                        }
                        case 1: {
                            x = baseX + a;
                            z = baseZ - b;
                            y = baseY - c;
                            break;
                        }
                        case 9: {
                            z = baseZ + a;
                            x = baseX + b;
                            y = baseY - c;
                            break;
                        }
                        case 17: {
                            x = baseX - a;
                            z = baseZ + b;
                            y = baseY - c;
                            break;
                        }
                        case 25: {
                            z = baseZ - a;
                            x = baseX - b;
                            y = baseY - c;
                            break;
                        }
                        case 0: {
                            x = baseX - a;
                            z = baseZ - b;
                            y = baseY + c;
                            break;
                        }
                        case 8: {
                            z = baseZ + a;
                            x = baseX - b;
                            y = baseY + c;
                            break;
                        }
                        case 16: {
                            x = baseX + a;
                            z = baseZ + b;
                            y = baseY + c;
                            break;
                        }
                        case 24: {
                            z = baseZ - a;
                            x = baseX + b;
                            y = baseY + c;
                            break;
                        }
                        default: {
                            if (TecTechConfig.DEBUG_MODE) {
                                TecTech.LOGGER.info((Object)("facing = " + facing));
                            }
                            return false;
                        }
                    }
                    if (y < 0 || y >= 256) {
                        return false;
                    }
                    if (world.func_72899_e(x, y, z)) {
                        int pointer;
                        if (hintsOnly) {
                            switch (block) {
                                case '-': {
                                    TecTech.proxy.hint_particle(world, x, y, z, TT_Container_Casings.sHintCasingsTT, 13);
                                    break;
                                }
                                case '+': {
                                    TecTech.proxy.hint_particle(world, x, y, z, TT_Container_Casings.sHintCasingsTT, 14);
                                    break;
                                }
                                default: {
                                    pointer = block - 48;
                                    if (pointer >= 0) {
                                        if (world.func_147439_a(x, y, z) == blockType[pointer] && world.func_72805_g(x, y, z) == blockMeta[pointer]) break;
                                        TecTech.proxy.hint_particle(world, x, y, z, blockType[pointer], blockMeta[pointer]);
                                        break;
                                    }
                                    pointer = block - 32;
                                    if (pointer >= 0) {
                                        if (pointer >= 0 && pointer < 12) {
                                            TecTech.proxy.hint_particle(world, x, y, z, TT_Container_Casings.sHintCasingsTT, pointer);
                                            break;
                                        }
                                        TecTech.proxy.hint_particle(world, x, y, z, TT_Container_Casings.sHintCasingsTT, 12);
                                        break;
                                    }
                                    TecTech.proxy.hint_particle(world, x, y, z, TT_Container_Casings.sHintCasingsTT, 15);
                                    break;
                                }
                            }
                        } else {
                            switch (block) {
                                case '-': {
                                    world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                                    break;
                                }
                                case '+': {
                                    world.func_147465_d(x, y, z, TT_Container_Casings.sBlockCasingsTT, 14, 2);
                                    break;
                                }
                                default: {
                                    pointer = block - 48;
                                    if (pointer >= 0) {
                                        world.func_147465_d(x, y, z, blockType[pointer], (int)blockMeta[pointer], 2);
                                        break;
                                    }
                                    if (block - 32 >= 0) break;
                                    world.func_147465_d(x, y, z, TT_Container_Casings.sHintCasingsTT, 15, 2);
                                }
                            }
                        }
                    }
                    ++a;
                }
                --b;
                ++n4;
            }
            break;
        }
        return true;
    }

    public static String[] StructureWriter(IGregTechTileEntity aBaseMetaTileEntity, int horizontalOffset, int verticalOffset, int depthOffset, int horizontalSize, int verticalSize, int depthSize, boolean ignoreAir) {
        int i;
        int y;
        int z;
        int x;
        int a;
        int b;
        byte facing = aBaseMetaTileEntity.getFrontFacing();
        World world = aBaseMetaTileEntity.getWorld();
        if (world.field_72995_K) {
            return new String[]{"Not at Client m8"};
        }
        ItemStack[] array = new ItemStack[10];
        int baseX = aBaseMetaTileEntity.getXCoord();
        int baseZ = aBaseMetaTileEntity.getZCoord();
        short baseY = aBaseMetaTileEntity.getYCoord();
        int c = -depthOffset;
        for (int cz = 0; cz < depthSize; ++cz) {
            b = verticalOffset;
            for (int by = 0; by < verticalSize; ++by) {
                a = -horizontalOffset;
                for (int az = 0; az < horizontalSize; ++az) {
                    int meta;
                    switch (facing) {
                        case 4: {
                            x = baseX + c;
                            z = baseZ + a;
                            y = baseY + b;
                            break;
                        }
                        case 3: {
                            x = baseX + a;
                            z = baseZ - c;
                            y = baseY + b;
                            break;
                        }
                        case 5: {
                            x = baseX - c;
                            z = baseZ - a;
                            y = baseY + b;
                            break;
                        }
                        case 2: {
                            x = baseX - a;
                            z = baseZ + c;
                            y = baseY + b;
                            break;
                        }
                        case 1: {
                            x = baseX + a;
                            z = baseZ + b;
                            y = baseY - c;
                            break;
                        }
                        case 0: {
                            x = baseX - a;
                            z = baseZ - b;
                            y = baseY + c;
                            break;
                        }
                        default: {
                            return new String[]{"Invalid rotation"};
                        }
                    }
                    if (y < 0 || y >= 256) {
                        return new String[]{"Invalid position"};
                    }
                    Block block = world.func_147439_a(x, y, z);
                    if (!block.hasTileEntity(meta = world.func_72805_g(x, y, z)) && block.func_149688_o() != Material.field_151579_a) {
                        boolean err = true;
                        ItemStack is = new ItemStack(block, 1, meta);
                        for (int i2 = 0; i2 < array.length; ++i2) {
                            if (array[i2] == null) {
                                array[i2] = is;
                                err = false;
                                break;
                            }
                            if (is.func_77973_b() != array[i2].func_77973_b() || is.func_77960_j() != array[i2].func_77960_j()) continue;
                            err = false;
                            break;
                        }
                        if (err) {
                            return new String[]{"Too much different blocks"};
                        }
                    }
                    ++a;
                }
                --b;
            }
            ++c;
        }
        ArrayList<String> output = new ArrayList<String>();
        output.add("Offsets: " + horizontalOffset + ' ' + verticalOffset + ' ' + depthOffset);
        output.add("Sizes: " + horizontalSize + ' ' + verticalSize + ' ' + depthSize);
        output.add("");
        output.add("ID[]: Name[]");
        output.add("");
        for (i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            output.add(i + ": " + array[i].func_82833_r());
        }
        output.add("");
        output.add("ID[]: Block[] BlockMetaID[]");
        output.add("");
        for (i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            output.add(i + ": " + array[i].func_77973_b().func_77658_a() + ' ' + array[i].func_77960_j());
        }
        output.add("");
        output.add("String[][]");
        output.add("{");
        c = -depthOffset;
        for (int cz = 0; cz < depthSize; ++cz) {
            b = verticalOffset;
            StringBuilder addMe = new StringBuilder().append('{');
            for (int by = 0; by < verticalSize; ++by) {
                a = -horizontalOffset;
                StringBuilder line = new StringBuilder();
                for (int az = 0; az < horizontalSize; ++az) {
                    switch (facing) {
                        case 4: {
                            x = baseX + c;
                            z = baseZ + a;
                            y = baseY + b;
                            break;
                        }
                        case 3: {
                            x = baseX + a;
                            z = baseZ - c;
                            y = baseY + b;
                            break;
                        }
                        case 5: {
                            x = baseX - c;
                            z = baseZ - a;
                            y = baseY + b;
                            break;
                        }
                        case 2: {
                            x = baseX - a;
                            z = baseZ + c;
                            y = baseY + b;
                            break;
                        }
                        case 1: {
                            x = baseX + a;
                            z = baseZ + b;
                            y = baseY - c;
                            break;
                        }
                        case 0: {
                            x = baseX - a;
                            z = baseZ - b;
                            y = baseY + c;
                            break;
                        }
                        default: {
                            return new String[]{"Invalid rotation"};
                        }
                    }
                    Block block = world.func_147439_a(x, y, z);
                    int meta = world.func_72805_g(x, y, z);
                    if (a == 0 && b == 0 && c == 0) {
                        line.append('.');
                    } else if (block.func_149688_o() == Material.field_151579_a) {
                        line.append('-');
                    } else if (block.hasTileEntity(meta)) {
                        line.append('*');
                    } else {
                        ItemStack stack = new ItemStack(block, 1, meta);
                        String str = "?";
                        for (int i3 = 0; i3 < array.length; ++i3) {
                            if (array[i3] == null || stack.func_77973_b() != array[i3].func_77973_b() || stack.func_77960_j() != array[i3].func_77960_j()) continue;
                            str = Integer.toString(i3);
                            break;
                        }
                        line.append(str);
                    }
                    ++a;
                }
                if (ignoreAir) {
                    StringBuilder builder = new StringBuilder();
                    int temp = 64;
                    for (char ch : line.toString().toCharArray()) {
                        if (ch == '-') {
                            if ((temp = (int)((char)(temp + 1))) != 126) continue;
                            builder.append('~');
                            temp = 64;
                            continue;
                        }
                        if (temp > 64) {
                            builder.append((char)temp);
                            temp = 64;
                        }
                        builder.append(ch);
                    }
                    while (builder.length() > 0 && builder.charAt(builder.length() - 1) == '~') {
                        builder.deleteCharAt(builder.length() - 1);
                    }
                    if (builder.length() == 0) {
                        builder.append("E,");
                    } else {
                        builder.insert(0, '\"');
                        builder.append('\"').append(',');
                    }
                    addMe.append((CharSequence)builder);
                } else {
                    if (line.length() == 0) {
                        line.append("E,");
                    } else {
                        line.insert(0, '\"');
                        line.append('\"').append(',');
                    }
                    addMe.append((CharSequence)line);
                }
                --b;
            }
            addMe.append('}').append(',');
            String builtStr = addMe.toString().replaceAll("(E,)+(?=})", "");
            Matcher matcher = matchE_.matcher(builtStr);
            while (matcher.find()) {
                byte lenEE = (byte)(matcher.group(1).length() >> 1);
                builtStr = builtStr.replaceFirst("E,(E,)+", "\"\\\\u00" + String.format("%02X", lenEE - 1) + "\",");
            }
            output.add(builtStr);
            ++c;
        }
        output.add("}");
        return output.toArray(new String[output.size()]);
    }

    public static boolean isInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, FluidStack[] requiredFluidInputs, ItemStack[] requiredInputs, FluidStack[] givenFluidInputs, ItemStack ... givenInputs) {
        int n;
        int n2;
        FluidStack[] fluidStackArray;
        int amt;
        boolean temp;
        if (!GregTech_API.sPostloadFinished) {
            return false;
        }
        if (requiredFluidInputs.length > 0 && givenFluidInputs == null) {
            return false;
        }
        for (FluidStack fluidStack : requiredFluidInputs) {
            if (fluidStack == null) continue;
            temp = true;
            amt = fluidStack.amount;
            fluidStackArray = givenFluidInputs;
            n2 = fluidStackArray.length;
            for (n = 0; n < n2; ++n) {
                FluidStack aFluid = fluidStackArray[n];
                if (aFluid == null || !aFluid.isFluidEqual(fluidStack)) continue;
                if (aDontCheckStackSizes) {
                    temp = false;
                    break;
                }
                if ((amt -= aFluid.amount) >= 1) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (requiredInputs.length > 0 && givenInputs == null) {
            return false;
        }
        for (FluidStack fluidStack : requiredInputs) {
            if (fluidStack == null) continue;
            amt = fluidStack.field_77994_a;
            temp = true;
            fluidStackArray = givenInputs;
            n2 = fluidStackArray.length;
            for (n = 0; n < n2; ++n) {
                FluidStack aStack = fluidStackArray[n];
                if (!GT_Utility.areUnificationsEqual((ItemStack)aStack, (ItemStack)fluidStack, (boolean)true) && !GT_Utility.areUnificationsEqual((ItemStack)GT_OreDictUnificator.get((boolean)false, (ItemStack)aStack), (ItemStack)fluidStack, (boolean)true)) continue;
                if (aDontCheckStackSizes) {
                    temp = false;
                    break;
                }
                if ((amt -= aStack.field_77994_a) >= 1) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            if (givenFluidInputs != null) {
                block4: for (FluidStack fluidStack : requiredFluidInputs) {
                    if (fluidStack == null) continue;
                    amt = fluidStack.amount;
                    FluidStack[] fluidStackArray2 = givenFluidInputs;
                    int n3 = fluidStackArray2.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        FluidStack aFluid = fluidStackArray2[n2];
                        if (aFluid == null || !aFluid.isFluidEqual(fluidStack)) continue;
                        if (aDontCheckStackSizes) {
                            aFluid.amount -= amt;
                            continue block4;
                        }
                        if (aFluid.amount < amt) {
                            amt -= aFluid.amount;
                            aFluid.amount = 0;
                            continue;
                        }
                        aFluid.amount -= amt;
                        continue block4;
                    }
                }
            }
            if (givenInputs != null) {
                block6: for (FluidStack fluidStack : requiredInputs) {
                    if (fluidStack == null) continue;
                    amt = fluidStack.field_77994_a;
                    for (ItemStack aStack : givenInputs) {
                        if (!GT_Utility.areUnificationsEqual((ItemStack)aStack, (ItemStack)fluidStack, (boolean)true) && !GT_Utility.areUnificationsEqual((ItemStack)GT_OreDictUnificator.get((boolean)false, (ItemStack)aStack), (ItemStack)fluidStack, (boolean)true)) continue;
                        if (aDontCheckStackSizes) {
                            aStack.field_77994_a -= amt;
                            continue block6;
                        }
                        if (aStack.field_77994_a < amt) {
                            amt -= aStack.field_77994_a;
                            aStack.field_77994_a = 0;
                            continue;
                        }
                        aStack.field_77994_a -= amt;
                        continue block6;
                    }
                }
            }
        }
        return true;
    }

    public static String getUniqueIdentifier(ItemStack is) {
        return GameRegistry.findUniqueIdentifierFor((Item)is.func_77973_b()).modId + ':' + is.func_77977_a();
    }

    public static byte getTier(long l) {
        byte b = -1;
        do {
            if ((b = (byte)((byte)(b + 1))) < CommonValues.V.length) continue;
            return b;
        } while (l > CommonValues.V[b]);
        return b;
    }

    public static String[] splitButDifferent(String string, String delimiter) {
        String[] strings = new String[StringUtils.countMatches((CharSequence)string, (CharSequence)delimiter) + 1];
        int lastEnd = 0;
        for (int i = 0; i < strings.length - 1; ++i) {
            int nextEnd = string.indexOf(delimiter, lastEnd);
            strings[i] = string.substring(lastEnd, nextEnd);
            lastEnd = nextEnd + delimiter.length();
        }
        strings[strings.length - 1] = string.substring(lastEnd);
        return strings;
    }

    public static String[] infoFromNBT(NBTTagCompound nbt) {
        String[] strings = new String[nbt.func_74762_e("i")];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = nbt.func_74779_i(Integer.toString(i));
        }
        return strings;
    }

    public static boolean areBitsSet(int setBits, int testedValue) {
        return (testedValue & setBits) == setBits;
    }

    public static void setTier(int tier, Object me) {
        try {
            Field field = GT_MetaTileEntity_TieredMachineBlock.class.getField("mTier");
            field.setAccessible(true);
            field.set(me, (byte)tier);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class TT_ItemStack
    implements Comparable<TT_ItemStack> {
        public final Item mItem;
        public final int mStackSize;
        public final int mMetaData;

        public TT_ItemStack(Item aItem, long aStackSize, long aMetaData) {
            this.mItem = aItem;
            this.mStackSize = (byte)aStackSize;
            this.mMetaData = (short)aMetaData;
        }

        public TT_ItemStack(ItemStack aStack) {
            if (aStack == null) {
                this.mItem = null;
                this.mMetaData = 0;
                this.mStackSize = 0;
            } else {
                this.mItem = aStack.func_77973_b();
                this.mStackSize = aStack.field_77994_a;
                this.mMetaData = Items.field_151008_G.getDamage(aStack);
            }
        }

        @Override
        public int compareTo(TT_ItemStack o) {
            if (this.mMetaData > o.mMetaData) {
                return 1;
            }
            if (this.mMetaData < o.mMetaData) {
                return -1;
            }
            if (this.mStackSize > o.mStackSize) {
                return 1;
            }
            if (this.mStackSize < o.mStackSize) {
                return -1;
            }
            if (this.mItem != null && o.mItem != null) {
                return this.mItem.func_77658_a().compareTo(o.mItem.func_77658_a());
            }
            if (this.mItem == null && o.mItem == null) {
                return 0;
            }
            if (this.mItem != null) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object aStack) {
            return aStack == this || aStack instanceof TT_ItemStack && (this.mItem == ((TT_ItemStack)aStack).mItem || ((TT_ItemStack)aStack).mItem.func_77658_a().equals(this.mItem.func_77658_a())) && ((TT_ItemStack)aStack).mStackSize == this.mStackSize && ((TT_ItemStack)aStack).mMetaData == this.mMetaData;
        }

        public int hashCode() {
            return (this.mItem != null ? this.mItem.func_77658_a().hashCode() : 0) ^ this.mMetaData << 16 ^ this.mStackSize << 24;
        }

        public String toString() {
            return Integer.toString(this.hashCode()) + ' ' + (this.mItem == null ? "null" : this.mItem.func_77658_a()) + ' ' + this.mMetaData + ' ' + this.mStackSize;
        }
    }
}

