/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.transformations;

import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aFluidDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aFluidQuantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aItemDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aItemQuantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aOredictDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aOredictQuantizationInfo;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class bTransformationInfo {
    public static final HashMap<Integer, aFluidQuantizationInfo> fluidQuantization = new HashMap(32);
    public HashMap<iElementalDefinition, aFluidDequantizationInfo> fluidDequantization;
    public static final HashMap<aItemQuantizationInfo, aItemQuantizationInfo> itemQuantization = new HashMap(32);
    public HashMap<iElementalDefinition, aItemDequantizationInfo> itemDequantization;
    public static final HashMap<Integer, aOredictQuantizationInfo> oredictQuantization = new HashMap(32);
    public HashMap<iElementalDefinition, aOredictDequantizationInfo> oredictDequantization;
    public static final HashSet<iElementalDefinition> stacksRegistered = new HashSet();

    public bTransformationInfo(int fluidCap, int itemCap, int oreCap) {
        if (fluidCap > 0) {
            this.fluidDequantization = new HashMap(fluidCap);
        }
        if (itemCap > 0) {
            this.itemDequantization = new HashMap(itemCap);
        }
        if (oreCap > 0) {
            this.oredictDequantization = new HashMap(oreCap);
        }
    }

    public void addFluid(iHasElementalDefinition em, FluidStack fluidStack) {
        fluidQuantization.put(fluidStack.getFluidID(), new aFluidQuantizationInfo(fluidStack, em));
        this.fluidDequantization.put(em.getDefinition(), new aFluidDequantizationInfo(em, fluidStack));
        stacksRegistered.add(em.getDefinition());
    }

    public void addFluid(iHasElementalDefinition em, int fluidID, int fluidAmount) {
        fluidQuantization.put(fluidID, new aFluidQuantizationInfo(fluidID, fluidAmount, em));
        this.fluidDequantization.put(em.getDefinition(), new aFluidDequantizationInfo(em, fluidID, fluidAmount));
        stacksRegistered.add(em.getDefinition());
    }

    public void addFluid(iHasElementalDefinition em, Fluid fluid, int fluidAmount) {
        fluidQuantization.put(fluid.getID(), new aFluidQuantizationInfo(fluid, fluidAmount, em));
        this.fluidDequantization.put(em.getDefinition(), new aFluidDequantizationInfo(em, fluid, fluidAmount));
        stacksRegistered.add(em.getDefinition());
    }

    private void addItemQuantization(aItemQuantizationInfo aIQI) {
        itemQuantization.put(aIQI, aIQI);
    }

    public void addItem(iHasElementalDefinition em, ItemStack itemStack, boolean skipNBT) {
        this.addItemQuantization(new aItemQuantizationInfo(itemStack, skipNBT, em));
        this.itemDequantization.put(em.getDefinition(), new aItemDequantizationInfo(em, itemStack));
        stacksRegistered.add(em.getDefinition());
    }

    public void addItem(iHasElementalDefinition em, OrePrefixes prefix, Materials material, int amount, boolean skipNBT) {
        this.addItemQuantization(new aItemQuantizationInfo(prefix, material, amount, skipNBT, em));
        this.itemDequantization.put(em.getDefinition(), new aItemDequantizationInfo(em, prefix, material, amount));
        stacksRegistered.add(em.getDefinition());
    }

    public void addOredict(iHasElementalDefinition em, int id, int qty) {
        oredictQuantization.put(id, new aOredictQuantizationInfo(id, qty, em));
        this.oredictDequantization.put(em.getDefinition(), new aOredictDequantizationInfo(em, id, qty));
        stacksRegistered.add(em.getDefinition());
    }

    public void addOredict(iHasElementalDefinition em, String name, int qty) {
        oredictQuantization.put(OreDictionary.getOreID((String)name), new aOredictQuantizationInfo(name, qty, em));
        this.oredictDequantization.put(em.getDefinition(), new aOredictDequantizationInfo(em, name, qty));
        stacksRegistered.add(em.getDefinition());
    }

    public void addOredict(iHasElementalDefinition em, OrePrefixes prefix, Materials material, int qty) {
        oredictQuantization.put(OreDictionary.getOreID((String)(prefix.name() + material.mName)), new aOredictQuantizationInfo(prefix, material, qty, em));
        this.oredictDequantization.put(em.getDefinition(), new aOredictDequantizationInfo(em, prefix, material, qty));
        stacksRegistered.add(em.getDefinition());
    }

    public void addOredict(iHasElementalDefinition em, OrePrefixes prefix, String materialName, int qty) {
        oredictQuantization.put(OreDictionary.getOreID((String)(prefix.name() + materialName)), new aOredictQuantizationInfo(prefix, materialName, qty, em));
        this.oredictDequantization.put(em.getDefinition(), new aOredictDequantizationInfo(em, prefix, materialName, qty));
        stacksRegistered.add(em.getDefinition());
    }
}

