/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.hatch;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.iElementalInstanceContainer;
import com.github.technus.tectech.mechanics.elementalMatter.core.tElementalException;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OverflowElemental;
import com.github.technus.tectech.thing.metaTileEntity.pipe.IConnectsToElementalPipe;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_Hatch_ElementalContainer
extends GT_MetaTileEntity_Hatch
implements iElementalInstanceContainer,
IConnectsToElementalPipe {
    private static Textures.BlockIcons.CustomIcon EM_T_SIDES;
    private static Textures.BlockIcons.CustomIcon EM_T_ACTIVE;
    private static Textures.BlockIcons.CustomIcon EM_T_CONN;
    protected cElementalInstanceStackMap content = new cElementalInstanceStackMap();
    public int postEnergize = 0;
    public float overflowMatter = 0.0f;
    public short id = (short)-1;
    private byte deathDelay = (byte)2;

    protected GT_MetaTileEntity_Hatch_ElementalContainer(int aID, String aName, String aNameRegional, int aTier, String descr) {
        super(aID, aName, aNameRegional, aTier, 0, descr, new ITexture[0]);
        Util.setTier(aTier, this);
    }

    protected GT_MetaTileEntity_Hatch_ElementalContainer(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        EM_T_ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_EM_T_ACTIVE");
        EM_T_SIDES = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_EM_T_SIDES");
        EM_T_CONN = new Textures.BlockIcons.CustomIcon("iconsets/EM_PIPE_CONN");
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)EM_T_ACTIVE, Dyes.getModulation((int)this.getBaseMetaTileEntity().getColorization(), (short[])Dyes.MACHINE_METAL.getRGBA())), new GT_RenderedTexture((IIconContainer)EM_T_CONN)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)EM_T_SIDES, Dyes.getModulation((int)this.getBaseMetaTileEntity().getColorization(), (short[])Dyes.MACHINE_METAL.getRGBA())), new GT_RenderedTexture((IIconContainer)EM_T_CONN)};
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("postEnergize", this.postEnergize);
        aNBT.func_74776_a("overflowMatter", this.overflowMatter);
        aNBT.func_74782_a("eM_Stacks", (NBTBase)this.content.toNBT());
        aNBT.func_74777_a("eID", this.id);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        block3: {
            super.loadNBTData(aNBT);
            this.postEnergize = aNBT.func_74762_e("postEnergize");
            this.overflowMatter = aNBT.func_74760_g("overflowMatter");
            this.id = aNBT.func_74765_d("eID");
            try {
                this.content = cElementalInstanceStackMap.fromNBT(aNBT.func_74775_l("eM_Stacks"));
            }
            catch (tElementalException e) {
                if (TecTechConfig.DEBUG_MODE) {
                    e.printStackTrace();
                }
                if (this.content != null) break block3;
                this.content = new cElementalInstanceStackMap();
            }
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            byte Tick = (byte)(aTick % 20L);
            if (0 == Tick) {
                this.purgeOverflow();
                this.content.tickContentByOneSecond(1.0f, this.postEnergize);
                this.purgeOverflow();
            } else if (10 == Tick) {
                if (this.overflowMatter <= 0.0f) {
                    this.deathDelay = (byte)3;
                } else {
                    if (this.deathDelay == 1) {
                        IGregTechTileEntity tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSide(aBaseMetaTileEntity.getBackFacing());
                        if (tGTTileEntity == null || !(tGTTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_OverflowElemental)) {
                            tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSide((byte)0);
                        }
                        if (tGTTileEntity == null || !(tGTTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_OverflowElemental)) {
                            tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSide((byte)1);
                        }
                        if (tGTTileEntity != null && tGTTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_OverflowElemental) {
                            GT_MetaTileEntity_Hatch_OverflowElemental aMetaTileEntity = (GT_MetaTileEntity_Hatch_OverflowElemental)tGTTileEntity.getMetaTileEntity();
                            if (aMetaTileEntity.addOverflowMatter(this.overflowMatter)) {
                                if (TecTech.configTecTech.BOOM_ENABLE) {
                                    tGTTileEntity.doExplosion(CommonValues.V[14]);
                                } else {
                                    TecTech.proxy.broadcast("Container1 BOOM! " + this.getBaseMetaTileEntity().getXCoord() + ' ' + this.getBaseMetaTileEntity().getYCoord() + ' ' + this.getBaseMetaTileEntity().getZCoord());
                                }
                            }
                            this.deathDelay = (byte)3;
                            this.overflowMatter = 0.0f;
                        }
                    } else if (this.deathDelay < 1) {
                        if (TecTech.configTecTech.BOOM_ENABLE) {
                            this.getBaseMetaTileEntity().doExplosion(CommonValues.V[14]);
                        } else {
                            this.deathDelay = (byte)3;
                            this.overflowMatter = 0.0f;
                            TecTech.proxy.broadcast("Container0 BOOM! " + this.getBaseMetaTileEntity().getXCoord() + ' ' + this.getBaseMetaTileEntity().getYCoord() + ' ' + this.getBaseMetaTileEntity().getZCoord());
                        }
                    }
                    this.deathDelay = (byte)(this.deathDelay - 1);
                }
            } else if (4 == Tick) {
                if (this.content.hasStacks()) {
                    this.moveAround(aBaseMetaTileEntity);
                }
                this.getBaseMetaTileEntity().setActive(this.content.hasStacks());
            }
        }
    }

    public void moveAround(IGregTechTileEntity aBaseMetaTileEntity) {
    }

    @Override
    public cElementalInstanceStackMap getContainerHandler() {
        return this.content;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isLiquidInput(byte aSide) {
        return false;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public int getMaxStacksCount() {
        return this.mTier * 2;
    }

    public int getMaxStackSize() {
        return this.mTier * (this.mTier - 7) * 1000;
    }

    @Override
    public float purgeOverflow() {
        return this.overflowMatter += this.content.removeOverflow(this.getMaxStacksCount(), this.getMaxStackSize());
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        if (TecTech.configTecTech.EASY_SCAN) {
            if (this.id > 0) {
                if (this.content == null || this.content.size() == 0) {
                    return new String[]{"ID: " + EnumChatFormatting.AQUA + this.id, "No Stacks"};
                }
                String[] lines = this.content.getElementalInfo();
                String[] output = new String[lines.length + 1];
                output[0] = "ID: " + EnumChatFormatting.AQUA + this.id;
                System.arraycopy(lines, 0, output, 1, lines.length);
                return output;
            }
            if (this.content == null || this.content.size() == 0) {
                return new String[]{"No Stacks"};
            }
            return this.content.getElementalInfo();
        }
        if (this.id > 0) {
            if (this.content == null || this.content.size() == 0) {
                return new String[]{"ID: " + EnumChatFormatting.AQUA + this.id, "No Stacks"};
            }
            return new String[]{"ID: " + EnumChatFormatting.AQUA + this.id, "Contains EM"};
        }
        if (this.content == null || this.content.size() == 0) {
            return new String[]{"No Stacks"};
        }
        return new String[]{"Contains EM"};
    }

    public float updateSlots() {
        return this.purgeOverflow();
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, this.mDescription, "Max stacks amount: " + EnumChatFormatting.AQUA + this.getMaxStacksCount(), "Stack capacity: " + EnumChatFormatting.AQUA + this.getMaxStackSize(), "Place Overflow Hatch behind,on top or below", "to provide overflow protection while this block", "is not attached to multi block.", "Transport range can be extended in straight", "line up to 15 blocks with quantum tunnels.", EnumChatFormatting.AQUA + "Must be painted to work"};
    }

    public void onRemoval() {
        if (GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)this) && this.getBaseMetaTileEntity().isActive()) {
            if (TecTech.configTecTech.BOOM_ENABLE) {
                this.getBaseMetaTileEntity().doExplosion(CommonValues.V[15]);
            } else {
                TecTech.proxy.broadcast("BOOM! " + this.getBaseMetaTileEntity().getXCoord() + ' ' + this.getBaseMetaTileEntity().getYCoord() + ' ' + this.getBaseMetaTileEntity().getZCoord());
            }
        }
    }
}

