/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.hatch;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.thing.metaTileEntity.Textures;
import com.github.technus.tectech.thing.metaTileEntity.pipe.IConnectsToEnergyTunnel;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_Hatch_EnergyTunnel
extends GT_MetaTileEntity_Hatch
implements IConnectsToEnergyTunnel {
    public final int Amperes;
    private final long upkeep;
    private long packetsCount = 0L;

    public GT_MetaTileEntity_Hatch_EnergyTunnel(int aID, String aName, String aNameRegional, int aTier, int aAmp) {
        super(aID, aName, aNameRegional, aTier, 0, "Energy injecting terminal for Multiblocks", new ITexture[0]);
        this.Amperes = aAmp;
        Util.setTier(aTier, this);
        this.upkeep = Math.max(CommonValues.V[this.mTier] / (long)this.Amperes, CommonValues.V[4]);
    }

    public GT_MetaTileEntity_Hatch_EnergyTunnel(String aName, int aTier, int aAmp, long aUpkeep, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        this.Amperes = aAmp;
        this.upkeep = aUpkeep;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.OVERLAYS_ENERGY_IN_POWER_TT[this.mTier]};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.OVERLAYS_ENERGY_IN_POWER_TT[this.mTier]};
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.packetsCount = aNBT.func_74763_f("ePackets");
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("ePackets", this.packetsCount);
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isInputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public long getMinimumStoredEU() {
        return CommonValues.V[this.mTier];
    }

    public long maxEUInput() {
        return CommonValues.V[this.mTier];
    }

    public long maxEUStore() {
        return 512L + CommonValues.V[this.mTier] * 4L * (long)this.Amperes;
    }

    public long maxAmperesIn() {
        return 0L;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_EnergyTunnel(this.mName, this.mTier, this.Amperes, this.upkeep, this.mDescription, this.mTextures);
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_GENERAL, this.mDescription};
    }

    @Override
    public boolean canConnect(byte side) {
        return this.isInputFacing(side);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        byte Tick;
        if (aBaseMetaTileEntity.isServerSide() && 16 == (Tick = (byte)(aTick % 20L))) {
            long diff;
            if (this.packetsCount > 0L && (diff = (this.maxEUStore() - aBaseMetaTileEntity.getStoredEU()) / this.maxEUInput()) > 0L) {
                this.setEUVar(aBaseMetaTileEntity.getStoredEU() + this.takePackets(diff) * this.maxEUInput());
            }
            if (aBaseMetaTileEntity.getStoredEU() > 0L) {
                this.setEUVar(aBaseMetaTileEntity.getStoredEU() - this.upkeep);
                if (aBaseMetaTileEntity.getStoredEU() < 0L) {
                    this.setEUVar(0L);
                }
            }
            this.getBaseMetaTileEntity().setActive(this.packetsCount > 0L);
        }
    }

    public void addPackets(long count) {
        this.packetsCount += count;
    }

    public long takePackets(long count) {
        if (this.packetsCount > count) {
            this.packetsCount -= count;
            return count;
        }
        count = this.packetsCount;
        this.packetsCount = 0L;
        return count;
    }
}

