/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.Vec3pos;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.dataTransport.QuantumDataPacket;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.IConstructable;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_InputData;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OutputData;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_Rack;
import com.github.technus.tectech.thing.metaTileEntity.multi.GT_MetaTileEntity_EM_switch;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class GT_MetaTileEntity_EM_computer
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private final ArrayList<GT_MetaTileEntity_Hatch_Rack> eRacks = new ArrayList();
    private int maxCurrentTemp = 0;
    private static final String[][] front;
    private static final String[][] terminator;
    private static final String[][] cap;
    private static final String[][] slice;
    private static final Block[] blockType;
    private static final byte[] blockMeta;
    private static final String[] addingMethods;
    private static final short[] casingTextures;
    private static final Block[] blockTypeFallback;
    private static final byte[] blockMetaFallback;
    private static final String[] description;

    public GT_MetaTileEntity_EM_computer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.eCertainMode = (byte)5;
        this.eCertainStatus = (byte)-128;
    }

    public GT_MetaTileEntity_EM_computer(String aName) {
        super(aName);
        this.eCertainMode = (byte)5;
        this.eCertainStatus = (byte)-128;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getActivitySound() {
        return GT_MetaTileEntity_EM_switch.activitySound;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_computer(this.mName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_COMPUTER");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_COMPUTER_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3], new TT_RenderedTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3]};
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        this.eAvailableData = 0L;
        this.maxCurrentTemp = 0;
        double overClockRatio = this.getParameterIn(0, 0);
        double overVoltageRatio = this.getParameterIn(0, 1);
        if (Double.isNaN(overClockRatio) || Double.isNaN(overVoltageRatio)) {
            return false;
        }
        if (overClockRatio > 0.0 && overVoltageRatio >= (double)0.7f && overClockRatio <= 3.0 && overVoltageRatio <= 2.0) {
            float eut = (float)CommonValues.V[8] * (float)overVoltageRatio * (float)overClockRatio;
            if (!(eut < 2.1474836E9f)) {
                this.mEUt = -((int)CommonValues.V[8]);
                return false;
            }
            this.mEUt = -((int)eut);
            int thingsActive = 0;
            for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
                int rackComputation;
                if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
                if (rack.heat > this.maxCurrentTemp) {
                    this.maxCurrentTemp = rack.heat;
                }
                if ((rackComputation = rack.tickComponents((float)overClockRatio, (float)overVoltageRatio)) > 0) {
                    this.eAvailableData += (long)rackComputation;
                    thingsActive = (short)(thingsActive + 4);
                }
                rack.getBaseMetaTileEntity().setActive(true);
            }
            for (GT_MetaTileEntity_Hatch_InputData di : this.eInputData) {
                if (di.q == null) continue;
                thingsActive = (short)(thingsActive + 1);
            }
            if (thingsActive > 0 && this.eCertainStatus == 0) {
                thingsActive = (short)(thingsActive + this.eOutputData.size());
                this.eAmpereFlow = 1 + (thingsActive >> 2);
                this.mMaxProgresstime = 20;
                this.mEfficiencyIncrease = 10000;
                return true;
            }
            this.eAvailableData = 0L;
            this.mEUt = -((int)CommonValues.V[8]);
            this.eAmpereFlow = 1L;
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            return true;
        }
        return false;
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (!this.eOutputData.isEmpty()) {
            Vec3pos pos = new Vec3pos(this.getBaseMetaTileEntity());
            QuantumDataPacket pack = new QuantumDataPacket(this.eAvailableData / (long)this.eOutputData.size()).unifyTraceWith(pos);
            if (pack == null) {
                return;
            }
            for (GT_MetaTileEntity_Hatch_InputData hatch : this.eInputData) {
                if (hatch.q == null || ((QuantumDataPacket)hatch.q).contains(pos) || (pack = pack.unifyPacketWith((QuantumDataPacket)hatch.q)) != null) continue;
                return;
            }
            for (GT_MetaTileEntity_Hatch_OutputData o : this.eOutputData) {
                o.q = pack;
            }
        }
    }

    @Override
    protected long getAvailableData_EM() {
        return this.eAvailableData;
    }

    @Override
    protected void afterRecipeCheckFailed() {
        super.afterRecipeCheckFailed();
        for (GT_MetaTileEntity_Hatch_Rack r : this.eRacks) {
            r.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    protected void parametersLoadDefault_EM() {
        this.setParameterPairIn_ClearOut(0, false, 1.0, 1.0);
    }

    @Override
    public void parametersOutAndStatusesWrite_EM(boolean machineBusy) {
        double ocRatio = this.getParameterIn(0, 0);
        if (ocRatio < 0.0) {
            this.setStatusOfParameterIn(0, 0, (byte)1);
        } else if (ocRatio < 1.0) {
            this.setStatusOfParameterIn(0, 0, (byte)2);
        } else if (ocRatio == 1.0) {
            this.setStatusOfParameterIn(0, 0, (byte)4);
        } else if (ocRatio <= 3.0) {
            this.setStatusOfParameterIn(0, 0, (byte)6);
        } else if (Double.isNaN(ocRatio)) {
            this.setStatusOfParameterIn(0, 0, (byte)3);
        } else {
            this.setStatusOfParameterIn(0, 0, (byte)5);
        }
        double ovRatio = this.getParameterIn(0, 1);
        if (ovRatio < (double)0.7f) {
            this.setStatusOfParameterIn(0, 1, (byte)1);
        } else if (ovRatio < (double)0.8f) {
            this.setStatusOfParameterIn(0, 1, (byte)2);
        } else if (ovRatio <= (double)1.2f) {
            this.setStatusOfParameterIn(0, 1, (byte)4);
        } else if (ovRatio <= 2.0) {
            this.setStatusOfParameterIn(0, 1, (byte)6);
        } else if (Double.isNaN(ovRatio)) {
            this.setStatusOfParameterIn(0, 1, (byte)3);
        } else {
            this.setStatusOfParameterIn(0, 1, (byte)5);
        }
        this.setParameterOut(0, 0, this.maxCurrentTemp);
        this.setParameterOut(0, 1, this.eAvailableData);
        if (this.maxCurrentTemp < -10000) {
            this.setStatusOfParameterOut(0, 0, (byte)1);
        } else if (this.maxCurrentTemp < 0) {
            this.setStatusOfParameterOut(0, 0, (byte)2);
        } else if (this.maxCurrentTemp == 0) {
            this.setStatusOfParameterOut(0, 0, (byte)4);
        } else if (this.maxCurrentTemp <= 5000) {
            this.setStatusOfParameterOut(0, 0, (byte)6);
        } else {
            this.setStatusOfParameterOut(0, 0, (byte)5);
        }
        if (!machineBusy) {
            this.setStatusOfParameterOut(0, 1, (byte)0);
        } else if (this.eAvailableData <= 0L) {
            this.setStatusOfParameterOut(0, 1, (byte)1);
        } else {
            this.setStatusOfParameterOut(0, 1, (byte)4);
        }
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        for (GT_MetaTileEntity_Hatch_Rack r : this.eRacks) {
            r.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    public void stopMachine() {
        super.stopMachine();
        this.eAvailableData = 0L;
        for (GT_MetaTileEntity_Hatch_Rack r : this.eRacks) {
            r.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        int offset;
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(false);
        }
        this.eRacks.clear();
        if (!this.structureCheck_EM(front, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 2, 0)) {
            return false;
        }
        if (!this.structureCheck_EM(cap, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 2, -1)) {
            return false;
        }
        int totalLen = 4;
        for (offset = -2; offset > -16 && this.structureCheck_EM(slice, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 2, offset); offset = (int)((byte)(offset - 1))) {
            totalLen = (byte)(totalLen + 1);
        }
        if (totalLen > 16) {
            return false;
        }
        if (!this.structureCheck_EM(cap, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 2, offset = (int)((byte)(offset + 1)))) {
            return false;
        }
        if (!this.structureCheck_EM(terminator, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 1, 2, offset = (int)((byte)(offset - 1)))) {
            return false;
        }
        this.eCertainMode = (byte)Math.min(totalLen / 3, 5);
        for (GT_MetaTileEntity_Hatch_Rack rack : this.eRacks) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)rack)) continue;
            rack.getBaseMetaTileEntity().setActive(iGregTechTileEntity.isActive());
        }
        return this.eUncertainHatches.size() == 1;
    }

    @Override
    public void construct(int stackSize, boolean hintsOnly) {
        int rackSlices;
        IGregTechTileEntity igt = this.getBaseMetaTileEntity();
        Util.StructureBuilderExtreme(front, blockType, blockMeta, 1, 2, 0, igt, this, hintsOnly);
        Util.StructureBuilderExtreme(cap, blockType, blockMeta, 1, 2, -1, igt, this, hintsOnly);
        int offset = -2;
        int n = rackSlices = stackSize > 12 ? 12 : stackSize;
        while (rackSlices > 0) {
            int n2 = offset;
            offset = (byte)(offset - 1);
            Util.StructureBuilderExtreme(slice, blockType, blockMeta, 1, 2, n2, igt, this, hintsOnly);
            --rackSlices;
        }
        int n3 = offset;
        offset = (byte)(offset - 1);
        Util.StructureBuilderExtreme(cap, blockType, blockMeta, 1, 2, n3, igt, this, hintsOnly);
        Util.StructureBuilderExtreme(terminator, blockType, blockMeta, 1, 2, offset, igt, this, hintsOnly);
    }

    @Override
    public String[] getStructureDescription(int stackSize) {
        return description;
    }

    @Override
    protected void extraExplosions_EM() {
        for (MetaTileEntity metaTileEntity : this.eRacks) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(CommonValues.V[9]);
        }
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, Util.intBitsToString(TecTech.RANDOM.nextInt()), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + "You need it to process the number above"};
    }

    public final boolean addRackToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Rack) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eRacks.add((GT_MetaTileEntity_Hatch_Rack)aMetaTileEntity);
        }
        return false;
    }

    public static void run() {
        block2: {
            try {
                adderMethodMap.put("addRackToMachineList", GT_MetaTileEntity_EM_computer.class.getMethod("addRackToMachineList", IGregTechTileEntity.class, Integer.TYPE));
            }
            catch (NoSuchMethodException e) {
                if (!TecTechConfig.DEBUG_MODE) break block2;
                e.printStackTrace();
            }
        }
    }

    static {
        front = new String[][]{{"A  ", "A  ", "A. ", "A  "}};
        terminator = new String[][]{{"A  ", "A  ", "A  ", "A  "}};
        cap = new String[][]{{"-01", "A22", "A22", "-01"}};
        slice = new String[][]{{"-01", "A!2", "A!2", "-01"}};
        blockType = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMeta = new byte[]{2, 1, 3};
        addingMethods = new String[]{"addToMachineList", "addRackToMachineList"};
        casingTextures = new short[]{1025, 1027};
        blockTypeFallback = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMetaFallback = new byte[]{1, 3};
        description = new String[]{EnumChatFormatting.AQUA + "Hint Details:", "1 - Classic/Data Hatches or Computer casing", "2 - Rack Hatches or Advanced computer casing"};
    }
}

