/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalInstanceStack;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.IConstructable;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_InputElemental;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OutputElemental;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class GT_MetaTileEntity_EM_decay
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private static final double URANIUM_INGOT_MASS_DIFF = 1.6114516E10;
    private static final double MASS_TO_EU_PARTIAL;
    private static final double MASS_TO_EU_INSTANT;
    private static final String[][] shape;
    private static final Block[] blockType;
    private static final byte[] blockMeta;
    private static final String[] addingMethods;
    private static final short[] casingTextures;
    private static final Block[] blockTypeFallback;
    private static final byte[] blockMetaFallback;
    private static final String[] description;

    public GT_MetaTileEntity_EM_decay(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_decay(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_decay(this.mName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_DECAY");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_DECAY_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12], new TT_RenderedTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][12]};
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        return this.structureCheck_EM(shape, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 2, 2, 0);
    }

    @Override
    public void construct(int stackSize, boolean hintsOnly) {
        Util.StructureBuilderExtreme(shape, blockType, blockMeta, 2, 2, 0, this.getBaseMetaTileEntity(), this, hintsOnly);
    }

    @Override
    public String[] getStructureDescription(int stackSize) {
        return description;
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, "Is life time too long?", EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + "Make it half-life (3) instead!"};
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        cElementalInstanceStackMap map = this.getInputsClone_EM();
        if (map != null && map.hasStacks()) {
            for (GT_MetaTileEntity_Hatch_InputElemental i : this.eInputHatches) {
                i.getContainerHandler().clear();
            }
            return this.startRecipe(map);
        }
        return false;
    }

    private boolean startRecipe(cElementalInstanceStackMap input) {
        this.mMaxProgresstime = 20;
        this.mEfficiencyIncrease = 10000;
        this.outputEM = new cElementalInstanceStackMap[2];
        this.outputEM[0] = input;
        this.outputEM[1] = new cElementalInstanceStackMap();
        for (cElementalInstanceStack stack : this.outputEM[0].values()) {
            if (stack.getEnergy() == 0L && stack.definition.decayMakesEnergy(1L)) {
                if (this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)((double)stack.getEnergySettingCost(1L) * MASS_TO_EU_INSTANT), false)) {
                    stack.setEnergy(1L);
                    continue;
                }
                this.outputEM[0].remove(stack.definition);
                this.outputEM[1].putReplace(stack);
                continue;
            }
            if (stack.definition.decayMakesEnergy(stack.getEnergy())) continue;
            this.outputEM[0].remove(stack.definition);
            this.outputEM[1].putReplace(stack);
        }
        float preMass = this.outputEM[0].getMass();
        this.outputEM[0].tickContent(1.0f, 0, 1);
        double energyDose = (double)(preMass - this.outputEM[0].getMass()) * MASS_TO_EU_PARTIAL;
        this.mEUt = (int)(energyDose / (double)this.getParameterInInt(0, 0));
        this.eAmpereFlow = this.getParameterInInt(0, 0);
        return this.outputEM[0].hasStacks();
    }

    @Override
    public void outputAfterRecipe_EM() {
        for (int i = 0; i < 2 && i < this.eOutputHatches.size(); ++i) {
            ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(i)).getContainerHandler().putUnifyAll(this.outputEM[i]);
            this.outputEM[i] = null;
        }
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (Object tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        for (Object tHatch : this.eEnergyMulti) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{"Progress:", EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + Integer.toString(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", "Energy Hatches:", EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(maxEnergy) + EnumChatFormatting.RESET + " EU", (this.mEUt <= 0 ? "Probably uses: " : "Probably makes: ") + EnumChatFormatting.RED + Integer.toString(Math.abs(this.mEUt)) + EnumChatFormatting.RESET + " EU/t at " + EnumChatFormatting.RED + this.eAmpereFlow + EnumChatFormatting.RESET + " A", "Tier Rating: " + EnumChatFormatting.YELLOW + CommonValues.VN[this.getMaxEnergyInputTier_EM()] + EnumChatFormatting.RESET + " / " + EnumChatFormatting.GREEN + CommonValues.VN[this.getMinEnergyInputTier_EM()] + EnumChatFormatting.RESET + " Amp Rating: " + EnumChatFormatting.GREEN + this.eMaxAmpereFlow + EnumChatFormatting.RESET + " A", "Problems: " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " Efficiency: " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %", "PowerPass: " + EnumChatFormatting.BLUE + this.ePowerPass + EnumChatFormatting.RESET + " SafeVoid: " + EnumChatFormatting.BLUE + this.eSafeVoid, "Computation: " + EnumChatFormatting.GREEN + this.eAvailableData + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + this.eRequiredData + EnumChatFormatting.RESET};
    }

    @Override
    public long maxEUStore() {
        return super.maxEUStore();
    }

    static {
        MASS_TO_EU_PARTIAL = (double)ConfigUtil.getFloat((Config)MainConfig.get(), (String)"balance/energy/generator/nuclear") * 3000000.0 / 1.6114516E10;
        MASS_TO_EU_INSTANT = MASS_TO_EU_PARTIAL * 20.0;
        shape = new String[][]{{"0C0", "A   ", "A . ", "A   ", "0C0"}, {"00000", "00000", "00000", "00000", "00000"}, {"0C0", "A!!!", "A!0!", "A!!!", "0C0"}, {"01110", "12221", "12221", "12221", "01110"}, {"01310", "12221", "32223", "12221", "01310"}, {"01110", "12221", "12221", "12221", "01110"}, {"0C0", "A!!!", "A!0!", "A!!!", "0C0"}, {"00000", "00000", "00000", "00000", "00000"}, {"0C0", "A   ", "A   ", "A   ", "0C0"}};
        blockType = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMeta = new byte[]{4, 5, 8, 6};
        addingMethods = new String[]{"addClassicToMachineList", "addElementalToMachineList"};
        casingTextures = new short[]{1024, 1028};
        blockTypeFallback = new Block[]{TT_Container_Casings.sBlockCasingsTT, TT_Container_Casings.sBlockCasingsTT};
        blockMetaFallback = new byte[]{0, 4};
        description = new String[]{EnumChatFormatting.AQUA + "Hint Details:", "1 - Classic Hatches or High Power Casing", "2 - Elemental Hatches or Molecular Casing"};
    }
}

