/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.stacks;

import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.cElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.cPrimitiveDefinition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class cElementalDefinitionStack
implements iHasElementalDefinition {
    public final iElementalDefinition definition;
    public final long amount;

    public cElementalDefinitionStack(iElementalDefinition def, long amount) {
        this.definition = def == null ? cPrimitiveDefinition.null__ : def;
        this.amount = amount;
    }

    @Override
    public cElementalDefinitionStack clone() {
        return this;
    }

    @Override
    public iElementalDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public long getCharge() {
        return (long)this.definition.getCharge() * this.amount;
    }

    @Override
    public float getMass() {
        return this.definition.getMass() * (float)this.amount;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("d", (NBTBase)this.definition.toNBT());
        nbt.func_74772_a("q", this.amount);
        return nbt;
    }

    public static cElementalDefinitionStack fromNBT(NBTTagCompound nbt) {
        return new cElementalDefinitionStack(cElementalDefinition.fromNBT(nbt.func_74775_l("d")), nbt.func_74763_f("q"));
    }

    public cElementalDefinitionStack addAmountIntoNewInstance(long amount) {
        if (amount == 0L) {
            return this;
        }
        return new cElementalDefinitionStack(this.definition, amount + this.amount);
    }

    public cElementalDefinitionStack addAmountIntoNewInstance(cElementalDefinitionStack ... other) {
        if (other == null || other.length == 0) {
            return this;
        }
        long l = 0L;
        for (cElementalDefinitionStack stack : other) {
            l += stack.amount;
        }
        return this.addAmountIntoNewInstance(l);
    }

    @Override
    public int compareTo(iHasElementalDefinition o) {
        return this.definition.compareTo(o.getDefinition());
    }

    public boolean equals(Object obj) {
        if (obj instanceof iElementalDefinition) {
            return this.definition.compareTo((iElementalDefinition)obj) == 0;
        }
        if (obj instanceof iHasElementalDefinition) {
            return this.definition.compareTo(((iHasElementalDefinition)obj).getDefinition()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }
}

