/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.templates;

import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.cElementalPrimitive;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.cPrimitiveDefinition;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public abstract class cElementalDefinition
extends iElementalDefinition {
    public static final iElementalDefinition[] nothing = new cElementalPrimitive[0];
    private static final Map<Byte, Method> nbtCreationBind = new HashMap<Byte, Method>();
    private static final HashSet<Byte> classSet = new HashSet();

    protected static void addCreatorFromNBT(byte shortcutNBT, Method constructorFromNBT, byte classID) {
        if (nbtCreationBind.put(shortcutNBT, constructorFromNBT) != null) {
            throw new Error("Duplicate NBT shortcut! " + shortcutNBT + " used for NBT based creation");
        }
        if (!classSet.add(classID)) {
            throw new Error("Duplicate Class ID! " + classID + " used for class comparison");
        }
    }

    public static Map<Byte, Method> getBindsComplex() {
        return nbtCreationBind;
    }

    @Override
    public final cElementalDefinition clone() {
        return this;
    }

    public static iElementalDefinition fromNBT(NBTTagCompound nbt) {
        try {
            return (iElementalDefinition)nbtCreationBind.get(nbt.func_74771_c("t")).invoke(null, nbt);
        }
        catch (Exception e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return cPrimitiveDefinition.nbtE__;
        }
    }

    @Override
    public int compareTo(iElementalDefinition o) {
        int classCompare = this.compareClassID(o);
        if (classCompare != 0) {
            return classCompare;
        }
        return cElementalDefinition.compareInnerContentsWithAmounts(this.getSubParticles().values(), o.getSubParticles().values());
    }

    private static int compareInnerContentsWithAmounts(cElementalDefinitionStack[] tc, cElementalDefinitionStack[] sc) {
        if (tc == null) {
            if (sc == null) {
                return 0;
            }
            return -1;
        }
        if (sc == null) {
            return 1;
        }
        int lenDiff = tc.length - sc.length;
        if (lenDiff != 0) {
            return lenDiff;
        }
        for (int i = 0; i < tc.length; ++i) {
            int cn = tc[i].definition.compareTo(sc[i].definition);
            if (cn != 0) {
                return cn;
            }
            if (tc[i].amount > sc[i].amount) {
                return 1;
            }
            if (tc[i].amount >= sc[i].amount) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public final cElementalDefinitionStack getStackForm(long i) {
        return new cElementalDefinitionStack(this, i);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof iElementalDefinition) {
            return this.compareTo((iElementalDefinition)obj) == 0;
        }
        if (obj instanceof iHasElementalDefinition) {
            return this.compareTo(((iHasElementalDefinition)obj).getDefinition()) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = -(this.getSubParticles().size() << 4);
        for (cElementalDefinitionStack stack : this.getSubParticles().values()) {
            hash = (int)((long)hash + (((stack.amount & 1L) == 0L ? -stack.amount : stack.amount) + (long)stack.definition.hashCode()));
        }
        return hash;
    }
}

