/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.hatch;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.loader.MainLoader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_OverflowElemental
extends GT_MetaTileEntity_Hatch {
    private static Textures.BlockIcons.CustomIcon EM_T_SIDES;
    private static Textures.BlockIcons.CustomIcon EM_T_ACTIVE;
    private static Textures.BlockIcons.CustomIcon MufflerEM;
    private static Textures.BlockIcons.CustomIcon MufflerEMidle;
    private float overflowMatter = 0.0f;
    public final float overflowMax;
    private final float overflowDisperse;

    public GT_MetaTileEntity_Hatch_OverflowElemental(int aID, String aName, String aNameRegional, int aTier, float max) {
        super(aID, aName, aNameRegional, aTier, 0, "Disposes excess elemental Matter", new ITexture[0]);
        this.overflowMatter = max / 2.0f;
        this.overflowMax = max;
        this.overflowDisperse = this.overflowMax / (float)(30 - aTier);
        Util.setTier(aTier, (Object)this);
    }

    public GT_MetaTileEntity_Hatch_OverflowElemental(String aName, int aTier, float max, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        this.overflowMatter = max / 2.0f;
        this.overflowMax = max;
        this.overflowDisperse = this.overflowMax / (float)(30 - aTier);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        EM_T_ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_EM_T_ACTIVE");
        EM_T_SIDES = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_EM_T_SIDES");
        MufflerEM = new Textures.BlockIcons.CustomIcon("iconsets/MUFFLER_EM");
        MufflerEMidle = new Textures.BlockIcons.CustomIcon("iconsets/MUFFLER_EM_IDLE");
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)EM_T_ACTIVE, Dyes.getModulation((int)this.getBaseMetaTileEntity().getColorization(), (short[])Dyes.MACHINE_METAL.getRGBA())), new GT_RenderedTexture((IIconContainer)MufflerEM)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)EM_T_SIDES, Dyes.getModulation((int)this.getBaseMetaTileEntity().getColorization(), (short[])Dyes.MACHINE_METAL.getRGBA())), new GT_RenderedTexture((IIconContainer)MufflerEMidle)};
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, this.mDescription, "Mass capacity: " + EnumChatFormatting.AQUA + String.format(Locale.ENGLISH, "%+.2E", Float.valueOf(this.overflowMax)) + " eV/c\u00b2", "Disposal Speed: " + EnumChatFormatting.AQUA + String.format(Locale.ENGLISH, "%+.2E", Float.valueOf(this.overflowDisperse)) + " (eV/c\u00b2)/s", "DO NOT OBSTRUCT THE OUTPUT!"};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_OverflowElemental(this.mName, this.mTier, this.overflowMax, this.mDescription, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74776_a("overflowMatter", this.overflowMatter);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.overflowMatter = aNBT.func_74760_g("overflowMatter");
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 14L) {
            if (aBaseMetaTileEntity.isActive()) {
                if (this.overflowMatter > this.overflowDisperse) {
                    this.overflowMatter -= this.overflowDisperse;
                } else {
                    this.overflowMatter = 0.0f;
                    aBaseMetaTileEntity.setActive(false);
                    aBaseMetaTileEntity.setLightValue((byte)0);
                    aBaseMetaTileEntity.getWorld().func_147463_c(EnumSkyBlock.Block, aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
                }
                this.vapePollution(aBaseMetaTileEntity);
            } else if (this.overflowMatter > 0.0f) {
                aBaseMetaTileEntity.setActive(true);
                aBaseMetaTileEntity.setLightValue((byte)15);
                aBaseMetaTileEntity.getWorld().func_147463_c(EnumSkyBlock.Block, aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
            }
        } else if (aBaseMetaTileEntity.isClientSide() && this.getBaseMetaTileEntity().isActive()) {
            TecTech.proxy.em_particle(this.getBaseMetaTileEntity(), this.getBaseMetaTileEntity().getFrontFacing());
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    private void vapePollution(IGregTechTileEntity mte) {
        float xPos = (float)mte.getXCoord() + 0.5f;
        float yPos = (float)mte.getYCoord() + 0.5f;
        float zPos = (float)mte.getZCoord() + 0.5f;
        int xDirShift = ForgeDirection.getOrientation((int)mte.getFrontFacing()).offsetX;
        int yDirShift = ForgeDirection.getOrientation((int)mte.getFrontFacing()).offsetY;
        int zDirShift = ForgeDirection.getOrientation((int)mte.getFrontFacing()).offsetZ;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)xPos - 0.5 + (double)xDirShift), (double)((double)yPos - 0.5 + (double)yDirShift), (double)((double)zPos - 0.5 + (double)zDirShift), (double)((double)xPos + 0.5 + (double)xDirShift), (double)((double)yPos + 1.5 + (double)yDirShift), (double)((double)zPos + 0.5 + (double)zDirShift));
        for (Object entity : mte.getWorld().func_72872_a(EntityLivingBase.class, aabb)) {
            float damagingFactor = (float)Math.log(this.overflowDisperse);
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 1, (int)(damagingFactor * 20.0f)));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 2, (int)(damagingFactor * 15.0f)));
            ((EntityLivingBase)entity).func_70097_a(MainLoader.elementalPollution, damagingFactor);
        }
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        return new String[]{"Contained mass:", EnumChatFormatting.RED + Double.toString(this.overflowMatter) + EnumChatFormatting.RESET + " eV/c\u00b2 /", EnumChatFormatting.GREEN + Double.toString(this.overflowMax) + EnumChatFormatting.RESET + " eV/c\u00b2", "Mass Disposal speed: " + EnumChatFormatting.BLUE + Double.toString(this.overflowDisperse) + EnumChatFormatting.RESET + " (eV/c\u00b2)/s"};
    }

    public void onRemoval() {
        if (GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)this) && this.getBaseMetaTileEntity().isActive()) {
            if (TecTech.configTecTech.BOOM_ENABLE) {
                this.getBaseMetaTileEntity().doExplosion(CommonValues.V[15]);
            } else {
                TecTech.proxy.broadcast("Muffler BOOM! " + this.getBaseMetaTileEntity().getXCoord() + ' ' + this.getBaseMetaTileEntity().getYCoord() + ' ' + this.getBaseMetaTileEntity().getZCoord());
            }
        }
    }

    public boolean addOverflowMatter(float matter) {
        this.overflowMatter += matter;
        return this.overflowMatter > this.overflowMax;
    }

    public float getOverflowMatter() {
        return this.overflowMatter;
    }

    public boolean setOverflowMatter(float overflowMatter) {
        this.overflowMatter = overflowMatter;
        return overflowMatter > this.overflowMax;
    }
}

