/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.CommonValues;
import com.github.technus.tectech.Util;
import com.github.technus.tectech.loader.MainLoader;
import com.github.technus.tectech.thing.metaTileEntity.IConstructable;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_Container_MultiMachineEM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_GUIContainer_MultiMachineEM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedTexture;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;

public class GT_MetaTileEntity_TM_microwave
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    public static final int POWER_SETTING_DEFAULT = 1000;
    public static final int TIMER_SETTING_DEFAULT = 360;
    private int powerSetting;
    private int timerSetting;
    private int timerValue;
    private boolean hasBeenPausedThisCycle = false;
    private static final String[][] shape = new String[][]{{"00000", "00000", "00.00", "0   0"}, {"0---0", "0---0", "0---0", " 000 "}, {"0---0", "0---0", "0---0", " 000 "}, {"0---0", "0---0", "0---0", " 000 "}, {"00000", "00000", "00000", "0   0"}};
    private static final Block[] blockType = new Block[]{GregTech_API.sBlockCasings4};
    private static final byte[] blockMeta = new byte[]{1};
    private static final String[] addingMethods = new String[]{"addClassicToMachineList"};
    private static final short[] casingTextures = new short[]{49};
    private static final Block[] blockTypeFallback = new Block[]{GregTech_API.sBlockCasings4};
    private static final byte[] blockMetaFallback = new byte[]{1};
    private static final String[] description = new String[]{EnumChatFormatting.AQUA + "Hint Details:", "1 - Classic Hatches or Clean Stainless Steel Casing", "Also acts like a hopper so give it an Output Bus"};

    public GT_MetaTileEntity_TM_microwave(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_TM_microwave(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TM_microwave(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[49], new TT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE))};
        }
        if (aSide == GT_Utility.getOppositeSide((int)aFacing)) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[49], aActive ? Textures.BlockIcons.CASING_BLOCKS[52] : Textures.BlockIcons.CASING_BLOCKS[53]};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[49]};
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_MultiMachineEM(aPlayerInventory, aBaseMetaTileEntity, false, true, true);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachineEM(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "EMDisplay.png", false, true, true);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        return this.structureCheck_EM(shape, blockType, blockMeta, addingMethods, casingTextures, blockTypeFallback, blockMetaFallback, 2, 2, 0);
    }

    @Override
    public void construct(int stackSize, boolean hintsOnly) {
        Util.StructureBuilderExtreme(shape, blockType, blockMeta, 2, 2, 0, this.getBaseMetaTileEntity(), this, hintsOnly);
    }

    @Override
    public String[] getStructureDescription(int stackSize) {
        return description;
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.BASS_MARK, "High Frequency Oven", EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + "From live to done in seconds!", EnumChatFormatting.BLUE + "I said nuke the... I meant microwave supper!"};
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        this.hasBeenPausedThisCycle = false;
        if (this.powerSetting < 300 || this.timerSetting <= 0 || this.timerSetting > 3000) {
            return false;
        }
        if (this.timerValue <= 0) {
            this.timerValue = this.timerSetting;
        }
        this.mEUt = -(this.powerSetting >> 1);
        this.eAmpereFlow = 1L;
        this.mMaxProgresstime = 20;
        this.mEfficiencyIncrease = 10000;
        return true;
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (this.hasBeenPausedThisCycle) {
            return;
        }
        --this.timerValue;
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        double[] xyzOffsets = this.getTranslatedOffsets(0.0, -1.0, 2.0);
        double xPos = (double)((float)mte.getXCoord() + 0.5f) + xyzOffsets[0];
        double yPos = (double)((float)mte.getYCoord() + 0.5f) + xyzOffsets[1];
        double zPos = (double)((float)mte.getZCoord() + 0.5f) + xyzOffsets[2];
        AxisAlignedBB aabb = this.getBoundingBox(-2, -2, -2, 2, 2, 2).func_72317_d(xPos, yPos, zPos);
        xyzOffsets = this.getTranslatedOffsets(0.0, -4.0, 0.0);
        double[] xyzExpansion = this.getTranslatedOffsets(1.5, 0.0, 1.5);
        for (int i = 0; i < 3; ++i) {
            if (!(xyzExpansion[i] < 0.0)) continue;
            xyzExpansion[i] = -xyzExpansion[i];
        }
        int damagingFactor = Math.min(this.powerSetting >> 6, 8) + Math.min(this.powerSetting >> 8, 24) + Math.min(this.powerSetting >> 12, 48) + (this.powerSetting >> 18);
        ArrayList<ItemStack> itemsToOutput = new ArrayList<ItemStack>();
        HashSet<Entity> tickedStuff = new HashSet<Entity>();
        boolean inside = true;
        do {
            for (Object entity : mte.getWorld().func_72839_b(null, aabb)) {
                if (!(entity instanceof Entity) || !tickedStuff.add((Entity)entity)) continue;
                if (inside && entity instanceof EntityItem) {
                    GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sMicrowaveRecipes.findRecipe((IHasWorldObjectAndCoords)mte, null, true, 128L, null, null, new ItemStack[]{((EntityItem)entity).func_92059_d()});
                    if (tRecipe == null || tRecipe.mInputs[0].field_77994_a != 1) {
                        itemsToOutput.add(((EntityItem)entity).func_92059_d());
                    } else {
                        ItemStack newStuff = tRecipe.getOutput(0).func_77946_l();
                        newStuff.field_77994_a = ((EntityItem)entity).func_92059_d().field_77994_a;
                        itemsToOutput.add(newStuff);
                    }
                    ((EntityItem)entity).field_145804_b = 2;
                    ((EntityItem)entity).func_70106_y();
                    continue;
                }
                if (!(entity instanceof EntityLivingBase) || GT_Utility.isWearingFullElectroHazmat((EntityLivingBase)((EntityLivingBase)entity))) continue;
                ((EntityLivingBase)entity).func_70097_a(MainLoader.microwaving, (float)damagingFactor);
            }
            aabb.func_72317_d(xyzOffsets[0], xyzOffsets[1], xyzOffsets[2]);
            aabb = aabb.func_72314_b(xyzExpansion[0], xyzExpansion[1], xyzExpansion[2]);
            inside = false;
        } while ((damagingFactor >>= 1) > 0);
        this.mOutputItems = itemsToOutput.toArray(new ItemStack[itemsToOutput.size()]);
        if (this.timerValue <= 0) {
            mte.getWorld().func_72908_a(xPos, yPos, zPos, "tectech:microwave_ding", 1.0f, 1.0f);
            this.stopMachine();
        }
    }

    @Override
    protected void parametersLoadDefault_EM() {
        this.powerSetting = 1000;
        this.timerSetting = 360;
        this.setParameterPairIn_ClearOut(0, false, 1000.0, 360.0);
    }

    @Override
    protected void parametersInRead_EM() {
        this.powerSetting = (int)this.getParameterIn(0, 0);
        this.timerSetting = (int)this.getParameterIn(0, 1);
    }

    @Override
    public void parametersOutAndStatusesWrite_EM(boolean machineBusy) {
        double powerParameter = this.getParameterIn(0, 0);
        if (powerParameter < 300.0) {
            this.setStatusOfParameterIn(0, 0, (byte)1);
        } else if (powerParameter < 1000.0) {
            this.setStatusOfParameterIn(0, 0, (byte)2);
        } else if (powerParameter == 1000.0) {
            this.setStatusOfParameterIn(0, 0, (byte)4);
        } else if (powerParameter == Double.POSITIVE_INFINITY) {
            this.setStatusOfParameterIn(0, 0, (byte)5);
        } else if (Double.isNaN(powerParameter)) {
            this.setStatusOfParameterIn(0, 0, (byte)3);
        } else {
            this.setStatusOfParameterOut(0, 0, (byte)6);
        }
        double timerParameter = this.getParameterIn(0, 1);
        if (timerParameter <= 1.0) {
            this.setStatusOfParameterIn(0, 1, (byte)1);
        } else if (timerParameter <= 3000.0) {
            this.setStatusOfParameterIn(0, 1, (byte)4);
        } else if (Double.isNaN(timerParameter)) {
            this.setStatusOfParameterIn(0, 1, (byte)3);
        } else {
            this.setStatusOfParameterIn(0, 1, (byte)5);
        }
        this.setParameterOut(0, 0, this.timerValue);
        this.setParameterOut(0, 1, this.timerSetting - this.timerValue);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.eSafeVoid) {
            this.hasBeenPausedThisCycle = true;
        }
        return this.hasBeenPausedThisCycle || super.onRunningTick(aStack);
    }

    @Override
    public void stopMachine() {
        super.stopMachine();
        this.timerValue = 0;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("eTimerVal", this.timerValue);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.timerValue = aNBT.func_74762_e("eTimerVal");
    }

    @Override
    public byte getTileEntityBaseType() {
        return 1;
    }
}

