/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi.base;

public class MultiblockControl<T> {
    private final int[] controls = new int[7];
    private final boolean shouldExplode;
    private final T values;

    public MultiblockControl(T values, int EUt, int amperes, int requiredData, int effIncrease, int maxProgressTime) {
        this.values = values;
        this.controls[0] = EUt;
        this.controls[1] = amperes;
        this.controls[2] = requiredData;
        this.controls[3] = effIncrease;
        this.controls[4] = maxProgressTime;
        this.shouldExplode = false;
    }

    public MultiblockControl(T values, int EUt, int amperes, int requiredData, int effIncrease, int maxProgressTime, int pollutionToAdd, float excessMass) {
        this.values = values;
        this.controls[0] = EUt;
        this.controls[1] = amperes;
        this.controls[2] = requiredData;
        this.controls[3] = effIncrease;
        this.controls[4] = maxProgressTime;
        this.controls[5] = pollutionToAdd;
        this.controls[6] = Float.floatToIntBits(excessMass);
        this.shouldExplode = false;
    }

    public MultiblockControl(float excessMass) {
        this.values = null;
        this.controls[6] = Float.floatToIntBits(excessMass);
        this.shouldExplode = true;
    }

    public T getValue() {
        return this.values;
    }

    public int getEUT() {
        return this.controls[0];
    }

    public int getAmperage() {
        return this.controls[1];
    }

    public int getRequiredData() {
        return this.controls[2];
    }

    public int getEffIncrease() {
        return this.controls[3];
    }

    public int getMaxProgressTime() {
        return this.controls[4];
    }

    public int getPollutionToAdd() {
        return this.controls[5];
    }

    public float getExcessMass() {
        return Float.intBitsToFloat(this.controls[6]);
    }

    public boolean shouldExplode() {
        return this.shouldExplode;
    }
}

