/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.definitions.complex;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.dComplexAspectDefinition;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDecay;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalMutableDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.tElementalException;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.cElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aFluidDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aItemDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aOredictDequantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.aOredictQuantizationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.bTransformationInfo;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.dAtomDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eBosonDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eQuarkDefinition;
import com.github.technus.tectech.thing.item.DebugElementalInstanceContainer_EM;
import com.github.technus.tectech.util.Util;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public final class dHadronDefinition
extends cElementalDefinition {
    private final int hash;
    private static final byte nbtType = 104;
    public static final Map<dHadronDefinition, String> SYMBOL_MAP = new HashMap<dHadronDefinition, String>();
    public static final Map<dHadronDefinition, String> NAME_MAP = new HashMap<dHadronDefinition, String>();
    public static dHadronDefinition hadron_p;
    public static dHadronDefinition hadron_n;
    public static dHadronDefinition hadron_p_;
    public static dHadronDefinition hadron_n_;
    public static cElementalDefinitionStack hadron_p1;
    public static cElementalDefinitionStack hadron_n1;
    public static cElementalDefinitionStack hadron_p2;
    public static cElementalDefinitionStack hadron_n2;
    public static cElementalDefinitionStack hadron_p3;
    public static cElementalDefinitionStack hadron_n3;
    public static cElementalDefinitionStack hadron_p5;
    private static double protonMass;
    private static double neutronMass;
    private static final double actualProtonMass = 9.382720813E8;
    private static final double actualNeutronMass = 9.395654133E8;
    public final double mass;
    public final int charge;
    public final double rawLifeTime;
    public final int amount;
    public final byte type;
    private final cElementalDefinitionStackMap quarkStacks;

    @Deprecated
    public dHadronDefinition(eQuarkDefinition ... quarks) throws tElementalException {
        this(true, new cElementalDefinitionStackMap(quarks));
    }

    @Deprecated
    private dHadronDefinition(boolean check, eQuarkDefinition ... quarks) throws tElementalException {
        this(check, new cElementalDefinitionStackMap(quarks));
    }

    public dHadronDefinition(cElementalDefinitionStack ... quarks) throws tElementalException {
        this(true, new cElementalDefinitionStackMap(quarks));
    }

    private dHadronDefinition(boolean check, cElementalDefinitionStack ... quarks) throws tElementalException {
        this(check, new cElementalDefinitionStackMap(quarks));
    }

    public dHadronDefinition(cElementalDefinitionStackMap quarks) throws tElementalException {
        this(true, quarks);
    }

    private dHadronDefinition(boolean check, cElementalDefinitionStackMap quarks) throws tElementalException {
        if (check && !dHadronDefinition.canTheyBeTogether(quarks)) {
            throw new tElementalException("Hadron Definition error");
        }
        this.quarkStacks = quarks;
        int amount = 0;
        int charge = 0;
        int type = 0;
        boolean containsAnti = false;
        double mass = 0.0;
        for (cElementalDefinitionStack quarkStack : this.quarkStacks.values()) {
            amount = (int)((double)amount + quarkStack.amount);
            if ((double)((int)quarkStack.amount) != quarkStack.amount) {
                throw new ArithmeticException("Amount cannot be safely converted to int!");
            }
            mass += quarkStack.getMass();
            charge = (int)((double)charge + quarkStack.getCharge());
            type = Math.max(Math.abs(quarkStack.definition.getType()), type);
            if (quarkStack.definition.getType() >= 0) continue;
            containsAnti = true;
        }
        this.amount = amount;
        this.charge = charge;
        this.type = containsAnti ? (byte)(-type) : (byte)type;
        long mult = this.amount * this.amount * (this.amount - 1);
        if ((mass = mass * 5.543 * (double)mult) == protonMass && this.amount == 3) {
            this.rawLifeTime = 1.5E36;
            mass = 9.382720813E8;
        } else if (mass == neutronMass && this.amount == 3) {
            this.rawLifeTime = 882.0;
            mass = 9.395654133E8;
        } else {
            this.rawLifeTime = this.amount == 3 ? 1.34 / mass * Math.pow(9.81, charge) : (this.amount == 2 ? 1.21 / mass / Math.pow(19.8, charge) : 1.21 / mass / Math.pow(9.8, charge));
        }
        this.mass = mass;
        this.hash = super.hashCode();
    }

    private static boolean canTheyBeTogether(cElementalDefinitionStackMap stacks) {
        long amount = 0L;
        for (cElementalDefinitionStack quarks : stacks.values()) {
            if (!(quarks.definition instanceof eQuarkDefinition)) {
                return false;
            }
            if ((double)((int)quarks.amount) != quarks.amount) {
                throw new ArithmeticException("Amount cannot be safely converted to int!");
            }
            amount = (long)((double)amount + quarks.amount);
        }
        return amount >= 2L && amount <= 12L;
    }

    @Override
    public String getName() {
        StringBuilder name = new StringBuilder(this.getSimpleName());
        name.append(':');
        String sym = NAME_MAP.get(this);
        if (sym != null) {
            name.append(' ').append(sym);
        } else {
            for (cElementalDefinitionStack quark : this.quarkStacks.values()) {
                name.append(' ').append(quark.definition.getSymbol()).append((int)quark.amount);
            }
        }
        return name.toString();
    }

    private String getSimpleName() {
        switch (this.amount) {
            case 2: {
                return "Meson";
            }
            case 3: {
                return "Baryon";
            }
            case 4: {
                return "Tetraquark";
            }
            case 5: {
                return "Pentaquark";
            }
            case 6: {
                return "Hexaquark";
            }
        }
        return "Hadron";
    }

    @Override
    public String getSymbol() {
        String sym = SYMBOL_MAP.get(this);
        if (sym != null) {
            return sym;
        }
        StringBuilder symbol = new StringBuilder(8);
        for (cElementalDefinitionStack quark : this.quarkStacks.values()) {
            int i = 0;
            while ((double)i < quark.amount) {
                symbol.append(quark.definition.getSymbol());
                ++i;
            }
        }
        return symbol.toString();
    }

    @Override
    public String getShortSymbol() {
        String sym = SYMBOL_MAP.get(this);
        if (sym != null) {
            return sym;
        }
        StringBuilder symbol = new StringBuilder(8);
        for (cElementalDefinitionStack quark : this.quarkStacks.values()) {
            int i = 0;
            while ((double)i < quark.amount) {
                symbol.append(quark.definition.getShortSymbol());
                ++i;
            }
        }
        return symbol.toString();
    }

    @Override
    public byte getColor() {
        return -7;
    }

    @Override
    public cElementalDefinitionStackMap getSubParticles() {
        return this.quarkStacks;
    }

    @Override
    public cElementalDecay[] getNaturalDecayInstant() {
        cElementalDefinitionStack[] quarkStacks = this.quarkStacks.values();
        if (this.amount == 2 && quarkStacks.length == 2 && quarkStacks[0].definition.getMass() == quarkStacks[1].definition.getMass() && quarkStacks[0].definition.getType() == -quarkStacks[1].definition.getType()) {
            return cElementalDecay.noProduct;
        }
        ArrayList<cElementalDefinitionStack> decaysInto = new ArrayList<cElementalDefinitionStack>();
        for (cElementalDefinitionStack quarks : quarkStacks) {
            if (quarks.definition.getType() == 1 || quarks.definition.getType() == -1) {
                decaysInto.add(quarks);
                continue;
            }
            decaysInto.add(new cElementalDefinitionStack(eBosonDefinition.boson_Y__, 2.0));
        }
        return new cElementalDecay[]{new cElementalDecay(0.75, decaysInto.toArray(new cElementalDefinitionStack[0])), eBosonDefinition.deadEnd};
    }

    @Override
    public cElementalDecay[] getEnergyInducedDecay(long energyLevel) {
        cElementalDefinitionStack[] quarkStacks = this.quarkStacks.values();
        if (this.amount == 2 && quarkStacks.length == 2 && quarkStacks[0].definition.getMass() == quarkStacks[1].definition.getMass() && quarkStacks[0].definition.getType() == -quarkStacks[1].definition.getType()) {
            return cElementalDecay.noProduct;
        }
        return new cElementalDecay[]{new cElementalDecay(0.75, quarkStacks), eBosonDefinition.deadEnd};
    }

    @Override
    public double getEnergyDiffBetweenStates(long currentEnergyLevel, long newEnergyLevel) {
        return 25000.0 * (double)(newEnergyLevel - currentEnergyLevel);
    }

    @Override
    public boolean usesSpecialEnergeticDecayHandling() {
        return false;
    }

    @Override
    public boolean usesMultipleDecayCalls(long energyLevel) {
        return false;
    }

    @Override
    public boolean decayMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public boolean fusionMakesEnergy(long energyLevel) {
        return false;
    }

    @Override
    public cElementalDecay[] getDecayArray() {
        cElementalDefinitionStack[] quarkStacks = this.quarkStacks.values();
        if (this.amount == 2 && quarkStacks.length == 2 && quarkStacks[0].definition.getMass() == quarkStacks[1].definition.getMass() && quarkStacks[0].definition.getType() == -quarkStacks[1].definition.getType()) {
            return cElementalDecay.noProduct;
        }
        if (this.amount != 3) {
            return new cElementalDecay[]{new cElementalDecay(0.95, quarkStacks), eBosonDefinition.deadEnd};
        }
        ArrayList<eQuarkDefinition> newBaryon = new ArrayList<eQuarkDefinition>();
        iElementalDefinition[] Particles = new iElementalDefinition[2];
        for (cElementalDefinitionStack quarks : quarkStacks) {
            int i = 0;
            while ((double)i < quarks.amount) {
                newBaryon.add((eQuarkDefinition)quarks.definition);
                ++i;
            }
        }
        eQuarkDefinition lastQuark = (eQuarkDefinition)newBaryon.remove(2);
        cElementalDefinitionStack[] decay = Math.abs(lastQuark.getType()) > 1 ? lastQuark.getDecayArray()[1].outputStacks.values() : lastQuark.getDecayArray()[2].outputStacks.values();
        newBaryon.add((eQuarkDefinition)decay[0].definition);
        Particles[0] = decay[1].definition;
        Particles[1] = decay[2].definition;
        eQuarkDefinition[] contentOfBaryon = newBaryon.toArray(new eQuarkDefinition[3]);
        try {
            return new cElementalDecay[]{new cElementalDecay(0.001, new dHadronDefinition(false, contentOfBaryon), Particles[0], Particles[1], eBosonDefinition.boson_Y__), new cElementalDecay(0.99, new dHadronDefinition(false, contentOfBaryon), Particles[0], Particles[1]), eBosonDefinition.deadEnd};
        }
        catch (tElementalException e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return new cElementalDecay[]{eBosonDefinition.deadEnd};
        }
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public int getCharge() {
        return this.charge;
    }

    @Override
    public double getRawTimeSpan(long currentEnergy) {
        return this.rawLifeTime;
    }

    @Override
    public boolean isTimeSpanHalfLife() {
        return true;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public iElementalDefinition getAnti() {
        cElementalMutableDefinitionStackMap anti = new cElementalMutableDefinitionStackMap();
        for (cElementalDefinitionStack stack : this.quarkStacks.values()) {
            anti.putReplace(new cElementalDefinitionStack(stack.definition.getAnti(), stack.amount));
        }
        try {
            return new dHadronDefinition(anti.toImmutable_optimized_unsafeLeavesExposedElementalTree());
        }
        catch (tElementalException e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public aFluidDequantizationInfo someAmountIntoFluidStack() {
        return null;
    }

    @Override
    public aItemDequantizationInfo someAmountIntoItemsStack() {
        return null;
    }

    @Override
    public aOredictDequantizationInfo someAmountIntoOredictStack() {
        return null;
    }

    @Override
    public NBTTagCompound toNBT() {
        return dComplexAspectDefinition.getNbtTagCompound((byte)104, this.quarkStacks);
    }

    public static dHadronDefinition fromNBT(NBTTagCompound nbt) {
        cElementalDefinitionStack[] stacks = new cElementalDefinitionStack[nbt.func_74762_e("i")];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = cElementalDefinitionStack.fromNBT(nbt.func_74775_l(Integer.toString(i)));
        }
        try {
            return new dHadronDefinition(stacks);
        }
        catch (tElementalException e) {
            if (TecTechConfig.DEBUG_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static void run() {
        block6: {
            try {
                hadron_p = new dHadronDefinition(new cElementalDefinitionStackMap(eQuarkDefinition.quark_u.getStackForm(2.0), eQuarkDefinition.quark_d.getStackForm(1.0)));
                protonMass = dHadronDefinition.hadron_p.mass;
                hadron_p = new dHadronDefinition(new cElementalDefinitionStackMap(eQuarkDefinition.quark_u.getStackForm(2.0), eQuarkDefinition.quark_d.getStackForm(1.0)));
                SYMBOL_MAP.put(hadron_p, "p");
                NAME_MAP.put(hadron_p, "Proton");
                DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(hadron_p);
                hadron_p_ = (dHadronDefinition)hadron_p.getAnti();
                SYMBOL_MAP.put(hadron_p_, "~p");
                NAME_MAP.put(hadron_p_, "Anti Proton");
                DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(hadron_p_);
                hadron_n = new dHadronDefinition(new cElementalDefinitionStackMap(eQuarkDefinition.quark_u.getStackForm(1.0), eQuarkDefinition.quark_d.getStackForm(2.0)));
                neutronMass = dHadronDefinition.hadron_n.mass;
                hadron_n = new dHadronDefinition(new cElementalDefinitionStackMap(eQuarkDefinition.quark_u.getStackForm(1.0), eQuarkDefinition.quark_d.getStackForm(2.0)));
                SYMBOL_MAP.put(hadron_n, "n");
                NAME_MAP.put(hadron_n, "Neutron");
                DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(hadron_n);
                hadron_n_ = (dHadronDefinition)hadron_n.getAnti();
                SYMBOL_MAP.put(hadron_n_, "~n");
                NAME_MAP.put(hadron_n_, "Anti Neutron");
                DebugElementalInstanceContainer_EM.STACKS_REGISTERED.add(hadron_n_);
            }
            catch (tElementalException e) {
                if (TecTechConfig.DEBUG_MODE) {
                    e.printStackTrace();
                }
                protonMass = -1.0;
                neutronMass = -1.0;
            }
            hadron_p1 = new cElementalDefinitionStack(hadron_p, 1.0);
            hadron_n1 = new cElementalDefinitionStack(hadron_n, 1.0);
            hadron_p2 = new cElementalDefinitionStack(hadron_p, 2.0);
            hadron_n2 = new cElementalDefinitionStack(hadron_n, 2.0);
            hadron_p3 = new cElementalDefinitionStack(hadron_p, 3.0);
            hadron_n3 = new cElementalDefinitionStack(hadron_n, 3.0);
            hadron_p5 = new cElementalDefinitionStack(hadron_p, 5.0);
            try {
                cElementalDefinition.addCreatorFromNBT((byte)104, dHadronDefinition.class.getMethod("fromNBT", NBTTagCompound.class), (byte)-64);
            }
            catch (Exception e) {
                if (!TecTechConfig.DEBUG_MODE) break block6;
                e.printStackTrace();
            }
        }
        if (TecTechConfig.DEBUG_MODE) {
            TecTech.LOGGER.info((Object)"Registered Elemental Matter Class: Hadron 104 -64");
        }
    }

    public static void setTransformations() {
        cElementalDefinitionStack neutrons = new cElementalDefinitionStack(hadron_n, 8.6718826944E28);
        dAtomDefinition.TRANSFORMATION_INFO.oredictDequantization.put(neutrons.definition, new aOredictDequantizationInfo((iHasElementalDefinition)neutrons, OrePrefixes.dust, Materials.Neutronium, 1));
        bTransformationInfo.oredictQuantization.put(OreDictionary.getOreID((String)(OrePrefixes.ingotHot.name() + Materials.Neutronium.mName)), new aOredictQuantizationInfo(OrePrefixes.ingotHot, Materials.Neutronium, 1, (iHasElementalDefinition)neutrons));
    }

    @Override
    public byte getClassType() {
        return -64;
    }

    public static byte getClassTypeStatic() {
        return -64;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public void addScanShortSymbols(ArrayList<String> lines, int capabilities, long energyLevel) {
        if (Util.areBitsSet(89, capabilities)) {
            lines.add(this.getShortSymbol());
        }
    }

    @Override
    public void addScanResults(ArrayList<String> lines, int capabilities, long energyLevel) {
        if (Util.areBitsSet(2048, capabilities)) {
            lines.add("CLASS = 104 " + this.getClassType());
        }
        if (Util.areBitsSet(89, capabilities)) {
            lines.add("NAME = " + this.getSimpleName());
        }
        if (Util.areBitsSet(8, capabilities)) {
            lines.add("CHARGE = " + (double)this.getCharge() / 3.0 + " e");
        }
        if (Util.areBitsSet(256, capabilities)) {
            lines.add(this.getColor() < 0 ? "COLORLESS" : "CARRIES COLOR");
        }
        if (Util.areBitsSet(16, capabilities)) {
            lines.add("MASS = " + this.getMass() + " eV/c\u00b2");
        }
        if (Util.areBitsSet(64, capabilities)) {
            lines.add("HALF LIFE = " + this.getRawTimeSpan(energyLevel) + " s");
            lines.add("    At current energy level");
        }
    }

    static {
        protonMass = 0.0;
        neutronMass = 0.0;
    }
}

