/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.util;

import java.util.Arrays;

public class DoubleCount {
    public static double[] distribute(double count, double ... probabilities) throws ArithmeticException {
        if (probabilities == null) {
            return null;
        }
        if (count == 0.0) {
            return new double[probabilities.length];
        }
        switch (probabilities.length) {
            default: {
                int size = probabilities.length;
                double[] output = new double[size];
                double remaining = count;
                double previous = probabilities[--size];
                double sum = 0.0;
                for (int i = size - 1; i >= 0; --i) {
                    double probability = probabilities[i];
                    double out = count * (probability - Math.ulp(probability));
                    remaining -= out;
                    output[i] = out;
                    sum += output[i];
                    if (previous < probability) {
                        throw new ArithmeticException("Malformed probability order: " + Arrays.toString(probabilities));
                    }
                    previous = probability;
                    if (probability >= 1.0) break;
                }
                if (remaining * count < 0.0) {
                    throw new ArithmeticException("Malformed probability sum: " + Arrays.toString(probabilities));
                }
                output[size] = remaining - Math.ulp(remaining) * (double)size;
                if ((sum += output[size]) > count) {
                    throw new ArithmeticException("Too much outputted: " + Arrays.toString(output) + " " + sum + " / " + count);
                }
                return output;
            }
            case 1: {
                return new double[]{count};
            }
            case 0: 
        }
        return probabilities;
    }

    public static double div(double count, double divisor) {
        if (divisor == 0.0) {
            throw new ArithmeticException("Divide by 0");
        }
        if (count == 0.0 || divisor == 1.0) {
            return count;
        }
        if (divisor == -1.0) {
            return -count;
        }
        double result = count / divisor;
        if (result * count < 0.0) {
            return 0.0;
        }
        return result - Math.ulp(result);
    }

    public static double mul(double count, double multiplier) {
        if (count == 0.0 || multiplier == 1.0) {
            return count;
        }
        if (multiplier == -1.0) {
            return -count;
        }
        double result = count * multiplier;
        if (result * count < 0.0) {
            return 0.0;
        }
        return result - Math.ulp(result);
    }

    public static double sub(double count, double value) {
        if (value == 0.0) {
            return count;
        }
        if (count == 0.0) {
            return -value;
        }
        if (value == count) {
            return 0.0;
        }
        return value < 0.0 ? DoubleCount.addInternal(count, -value) : DoubleCount.subInternal(count, value);
    }

    public static double add(double count, double value) {
        if (value == 0.0) {
            return count;
        }
        if (count == 0.0) {
            return value;
        }
        return value < 0.0 ? DoubleCount.subInternal(count, -value) : DoubleCount.addInternal(count, value);
    }

    private static double subInternal(double count, double value) {
        double result = count - Math.max(value, Math.ulp(count));
        if (result + value > count || value > count - result) {
            result -= Math.ulp(result);
        }
        return result;
    }

    private static double addInternal(double count, double value) {
        double result = count + value;
        if (result - value > count || result - count > value) {
            result -= Math.ulp(result);
        }
        return result;
    }
}

