/*
 * Decompiled with CFR 0.152.
 */
package jpsam3hklam9.des;

import jpsam3hklam9.des.FeistelFunction;
import jpsam3hklam9.des.RoundKeyGenerator;

public class DES {
    protected static final long MASK_6_BITS = 0xFC0000000000L;
    protected static final long MASK_32_BITS = 0xFFFFFFFFL;
    protected static final int MASK_28_BITS = 0xFFFFFFF;
    protected static final int NUM_OF_ROUNDS = 16;
    private static final byte[] IP = new byte[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
    private static final byte[] FP = new byte[]{40, 8, 48, 16, 56, 24, 64, 32, 39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25};
    private final RoundKeyGenerator keygen = new RoundKeyGenerator();
    private final FeistelFunction feistel = new FeistelFunction();

    public long[] CBCEncrypt(long[] plainTexts, long key, long IV) {
        return this.CBCMode(plainTexts, key, IV, true);
    }

    public long[] CBCDecrypt(long[] cipherTexts, long key, long IV) {
        return this.CBCMode(cipherTexts, key, IV, false);
    }

    public long encrypt(long block, long key) {
        return this.cipher(block, key, true);
    }

    public long decrypt(long block, long key) {
        return this.cipher(block, key, false);
    }

    private long[] CBCMode(long[] inputs, long key, long IV, boolean encrypt) {
        long[] outputs = new long[inputs.length];
        long xor_val = IV;
        for (int i = 0; i < inputs.length; ++i) {
            if (encrypt) {
                outputs[i] = this.encrypt(inputs[i] ^ xor_val, key);
                xor_val = outputs[i];
                continue;
            }
            outputs[i] = this.decrypt(inputs[i], key) ^ xor_val;
            xor_val = inputs[i];
        }
        return outputs;
    }

    public long cipher(long block, long key, boolean encrypt) {
        long[] roundKeys = this.keygen.generateRoundKeys(key);
        block = this.initialPermutation(block);
        int leftHalf = (int)(block >> 32);
        int rightHalf = (int)block;
        for (int i = 0; i < 16; ++i) {
            int FOutput = encrypt ? this.feistel.F(rightHalf, roundKeys[i]) : this.feistel.F(rightHalf, roundKeys[15 - i]);
            leftHalf ^= FOutput;
            rightHalf ^= (leftHalf ^= rightHalf);
            leftHalf ^= rightHalf;
        }
        long joinedHalves = ((long)rightHalf & 0xFFFFFFFFL) << 32 | (long)leftHalf & 0xFFFFFFFFL;
        return this.finalPermutation(joinedHalves);
    }

    private long initialPermutation(long input) {
        return DES.genericPermutation(input, IP, 64);
    }

    private long finalPermutation(long input) {
        return DES.genericPermutation(input, FP, 64);
    }

    protected static long genericPermutation(long input, byte[] indexTable, int inputLength) {
        long output = 0L;
        for (byte anIndexTable : indexTable) {
            int index = inputLength - anIndexTable;
            output = output << 1 | input >> index & 1L;
        }
        return output;
    }
}

