/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core;

import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDecayResult;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalMutableDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalDefinitionStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.core.tElementalException;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.iElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.cPrimitiveDefinition;
import com.github.technus.tectech.util.DoubleCount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public final class cElementalInstanceStackMap
implements Comparable<cElementalInstanceStackMap> {
    TreeMap<iElementalDefinition, cElementalInstanceStack> map;

    public cElementalInstanceStackMap() {
        this.map = new TreeMap();
    }

    public cElementalInstanceStackMap(cElementalInstanceStack ... inSafe) {
        this(true, inSafe);
    }

    public cElementalInstanceStackMap(boolean clone, cElementalInstanceStack ... in) {
        this.map = new TreeMap();
        if (clone) {
            cElementalInstanceStack[] stacks = new cElementalInstanceStack[in.length];
            for (int i = 0; i < stacks.length; ++i) {
                stacks[i] = in[i].clone();
            }
            this.putUnifyAll(stacks);
        } else {
            this.putUnifyAll(in);
        }
    }

    @Deprecated
    private cElementalInstanceStackMap(TreeMap<iElementalDefinition, cElementalInstanceStack> inSafe) {
        this(true, inSafe);
    }

    @Deprecated
    private cElementalInstanceStackMap(boolean clone, TreeMap<iElementalDefinition, cElementalInstanceStack> in) {
        if (clone) {
            this.map = new TreeMap();
            for (cElementalInstanceStack stack : in.values()) {
                this.putUnify(stack.clone());
            }
        } else {
            this.map = in;
        }
    }

    public cElementalInstanceStackMap(cElementalInstanceStackMap inSafe) {
        this(true, inSafe.map);
    }

    public cElementalInstanceStackMap(boolean copy, cElementalInstanceStackMap in) {
        this(copy, in.map);
    }

    public cElementalInstanceStackMap clone() {
        return new cElementalInstanceStackMap(this.map);
    }

    public cElementalMutableDefinitionStackMap toDefinitionMapForComparison() {
        cElementalDefinitionStack[] list = new cElementalDefinitionStack[this.map.size()];
        int i = 0;
        for (cElementalInstanceStack stack : this.map.values()) {
            list[i++] = new cElementalDefinitionStack(stack.definition, stack.amount);
        }
        return new cElementalMutableDefinitionStackMap(list);
    }

    @Deprecated
    public Map<iElementalDefinition, cElementalInstanceStack> getRawMap() {
        return this.map;
    }

    public Set<Map.Entry<iElementalDefinition, cElementalInstanceStack>> getEntrySet() {
        return this.map.entrySet();
    }

    public void clear() {
        this.map.clear();
    }

    public cElementalInstanceStack remove(iElementalDefinition def) {
        return this.map.remove(def);
    }

    @Deprecated
    public cElementalInstanceStack remove(iHasElementalDefinition has) {
        return this.map.remove(has.getDefinition());
    }

    public void removeAll(iElementalDefinition ... definitions) {
        for (iElementalDefinition def : definitions) {
            this.map.remove(def);
        }
    }

    @Deprecated
    private void removeAll(iHasElementalDefinition ... hasElementalDefinition) {
        for (iHasElementalDefinition has : hasElementalDefinition) {
            this.map.remove(has.getDefinition());
        }
    }

    public boolean removeAmount(boolean testOnly, cElementalInstanceStack instance) {
        cElementalInstanceStack target = this.map.get(instance.definition);
        if (target == null) {
            return false;
        }
        if (testOnly) {
            return target.amount >= instance.amount;
        }
        double diff = DoubleCount.sub(target.amount, instance.amount);
        if (diff > 0.0) {
            target.amount = diff;
            return true;
        }
        if (diff == 0.0) {
            this.map.remove(instance.definition);
            return true;
        }
        return false;
    }

    public boolean removeAmount(boolean testOnly, iHasElementalDefinition stack) {
        cElementalInstanceStack target = this.map.get(stack.getDefinition());
        if (target == null) {
            return false;
        }
        if (testOnly) {
            return target.amount >= stack.getAmount();
        }
        double diff = DoubleCount.sub(target.amount, stack.getAmount());
        if (diff > 0.0) {
            target.amount = diff;
            return true;
        }
        if (diff == 0.0) {
            this.map.remove(stack.getDefinition());
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean removeAmount(boolean testOnly, iElementalDefinition def) {
        return this.removeAmount(testOnly, new cElementalDefinitionStack(def, 1.0));
    }

    public boolean removeAllAmounts(boolean testOnly, cElementalInstanceStack ... instances) {
        boolean test = true;
        for (cElementalInstanceStack stack : instances) {
            test &= this.removeAmount(true, stack);
        }
        if (testOnly || !test) {
            return test;
        }
        for (cElementalInstanceStack stack : instances) {
            this.removeAmount(false, stack);
        }
        return true;
    }

    public boolean removeAllAmounts(boolean testOnly, iHasElementalDefinition ... stacks) {
        boolean test = true;
        for (iHasElementalDefinition stack : stacks) {
            test &= this.removeAmount(true, stack);
        }
        if (testOnly || !test) {
            return test;
        }
        for (iHasElementalDefinition stack : stacks) {
            this.removeAmount(false, stack);
        }
        return true;
    }

    @Deprecated
    public boolean removeAllAmounts(boolean testOnly, iElementalDefinition ... definitions) {
        iHasElementalDefinition[] stacks = new cElementalDefinitionStack[definitions.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = new cElementalDefinitionStack(definitions[i], 1.0);
        }
        return this.removeAllAmounts(testOnly, stacks);
    }

    public boolean removeAllAmounts(boolean testOnly, cElementalStackMap container) {
        boolean test = true;
        for (Map.Entry<iElementalDefinition, cElementalDefinitionStack> entry : container.map.entrySet()) {
            test &= this.removeAmount(true, entry.getValue());
        }
        if (testOnly || !test) {
            return test;
        }
        for (Map.Entry<iElementalDefinition, cElementalDefinitionStack> entry : container.map.entrySet()) {
            this.removeAmount(false, entry.getValue());
        }
        return true;
    }

    public boolean removeAllAmounts(boolean testOnly, cElementalInstanceStackMap container) {
        boolean test = true;
        for (Map.Entry<iElementalDefinition, cElementalInstanceStack> entry : container.map.entrySet()) {
            test &= this.removeAmount(true, entry.getValue());
        }
        if (testOnly || !test) {
            return test;
        }
        for (Map.Entry<iElementalDefinition, cElementalInstanceStack> entry : container.map.entrySet()) {
            test &= this.removeAmount(false, entry.getValue());
        }
        return true;
    }

    public double removeOverflow(int stacksCount, double stackCapacity) {
        double massRemoved = 0.0;
        if (this.map.size() > stacksCount) {
            iElementalDefinition[] keys = this.keys();
            for (int i = stacksCount; i < keys.length; ++i) {
                massRemoved += this.map.get(keys[i]).getDefinitionStack().getMass();
                this.map.remove(keys[i]);
            }
        }
        for (cElementalInstanceStack instance : this.values()) {
            if (!(instance.amount > stackCapacity)) continue;
            massRemoved += instance.definition.getMass() * (instance.amount - stackCapacity);
            instance.amount = stackCapacity;
        }
        return massRemoved;
    }

    public cElementalInstanceStack putReplace(cElementalInstanceStack instanceUnsafe) {
        return this.map.put(instanceUnsafe.definition, instanceUnsafe);
    }

    public void putReplaceAll(cElementalInstanceStack ... instances) {
        for (cElementalInstanceStack instance : instances) {
            this.map.put(instance.definition, instance);
        }
    }

    private void putReplaceAll(Map<iElementalDefinition, cElementalInstanceStack> inTreeUnsafe) {
        this.map.putAll(inTreeUnsafe);
    }

    public void putReplaceAll(cElementalInstanceStackMap inContainerUnsafe) {
        this.putReplaceAll(inContainerUnsafe.map);
    }

    public cElementalInstanceStack putUnify(cElementalInstanceStack instance) {
        cElementalInstanceStack stack = this.map.get(instance.definition);
        if (stack == null) {
            return this.map.put(instance.definition, instance);
        }
        return this.map.put(instance.definition, stack.unifyIntoThis(instance));
    }

    public void putUnifyAll(cElementalInstanceStack ... instances) {
        for (cElementalInstanceStack instance : instances) {
            this.putUnify(instance);
        }
    }

    private void putUnifyAll(Map<iElementalDefinition, cElementalInstanceStack> inTreeUnsafe) {
        for (cElementalInstanceStack in : inTreeUnsafe.values()) {
            this.putUnify(in);
        }
    }

    public void putUnifyAll(cElementalInstanceStackMap containerUnsafe) {
        this.putUnifyAll(containerUnsafe.map);
    }

    public cElementalInstanceStack getFirst() {
        return this.map.firstEntry().getValue();
    }

    public cElementalInstanceStack getLast() {
        return this.map.lastEntry().getValue();
    }

    public cElementalInstanceStack getInstance(iElementalDefinition def) {
        return this.map.get(def);
    }

    public cElementalInstanceStack get(int i) {
        Collection<cElementalInstanceStack> var = this.map.values();
        return var.toArray(new cElementalInstanceStack[0])[i];
    }

    public String[] getShortSymbolsInfo() {
        String[] info = new String[this.map.size()];
        int i = 0;
        for (cElementalInstanceStack instance : this.map.values()) {
            info[i++] = instance.definition.getShortSymbol();
        }
        return info;
    }

    public String[] getElementalInfo() {
        String[] info = new String[this.map.size()];
        int i = 0;
        for (cElementalInstanceStack instance : this.map.values()) {
            info[i++] = EnumChatFormatting.BLUE + instance.definition.getName() + " " + EnumChatFormatting.AQUA + instance.definition.getSymbol() + EnumChatFormatting.RESET + " #: " + EnumChatFormatting.GREEN + String.format("%.3E", instance.amount / 6.02214076E23) + " mol" + EnumChatFormatting.RESET + " E: " + EnumChatFormatting.GREEN + instance.getEnergy() + EnumChatFormatting.RESET + " T: " + EnumChatFormatting.GREEN + (instance.getLifeTime() < 0.0 ? "STABLE" : String.format("%.3E", instance.getLifeTime()));
        }
        return info;
    }

    public ArrayList<String> getScanShortSymbols(int[] capabilities) {
        ArrayList<String> list = new ArrayList<String>(16);
        for (Map.Entry<iElementalDefinition, cElementalInstanceStack> e : this.map.entrySet()) {
            e.getValue().addScanShortSymbols(list, capabilities);
        }
        return list;
    }

    public ArrayList<String> getScanInfo(int[] capabilities) {
        ArrayList<String> list = new ArrayList<String>(16);
        for (Map.Entry<iElementalDefinition, cElementalInstanceStack> e : this.map.entrySet()) {
            e.getValue().addScanResults(list, capabilities);
        }
        return list;
    }

    public cElementalInstanceStack[] values() {
        Collection<cElementalInstanceStack> var = this.map.values();
        return var.toArray(new cElementalInstanceStack[0]);
    }

    public iElementalDefinition[] keys() {
        Set<iElementalDefinition> var = this.map.keySet();
        return var.toArray(new iElementalDefinition[0]);
    }

    public double getMass() {
        double mass = 0.0;
        for (cElementalInstanceStack stack : this.map.values()) {
            mass += stack.getMass();
        }
        return mass;
    }

    public double getCharge() {
        double charge = 0.0;
        for (cElementalInstanceStack stack : this.map.values()) {
            charge += stack.getCharge();
        }
        return charge;
    }

    public double getCountOfAllAmounts() {
        double sum = 0.0;
        for (cElementalInstanceStack stack : this.map.values()) {
            sum = DoubleCount.add(sum, stack.amount);
        }
        return sum;
    }

    public boolean containsDefinition(iElementalDefinition def) {
        return this.map.containsKey(def);
    }

    public boolean containsInstance(cElementalInstanceStack inst) {
        return this.map.containsValue(inst);
    }

    public int size() {
        return this.map.size();
    }

    public boolean hasStacks() {
        return !this.map.isEmpty();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public double tickContentByOneSecond(double lifeTimeMult, int postEnergize) {
        return this.tickContent(lifeTimeMult, postEnergize, 1.0);
    }

    public double tickContent(double lifeTimeMult, int postEnergize, double seconds) {
        this.cleanUp();
        double diff = 0.0;
        for (cElementalInstanceStack instance : this.values()) {
            cElementalDecayResult newInstances = instance.decay(lifeTimeMult, instance.age += seconds, postEnergize);
            if (newInstances == null) {
                instance.nextColor();
                continue;
            }
            diff = DoubleCount.add(diff, newInstances.getMassDiff());
            this.removeAmount(false, instance);
            this.putUnifyAll(newInstances.getOutput());
        }
        return diff;
    }

    public NBTTagCompound getShortSymbolsNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        String[] info = this.getShortSymbolsInfo();
        nbt.func_74768_a("i", info.length);
        for (int i = 0; i < info.length; ++i) {
            nbt.func_74778_a(Integer.toString(i), info[i]);
        }
        return nbt;
    }

    public NBTTagCompound getInfoNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        String[] info = this.getElementalInfo();
        nbt.func_74768_a("i", info.length);
        for (int i = 0; i < info.length; ++i) {
            nbt.func_74778_a(Integer.toString(i), info[i]);
        }
        return nbt;
    }

    public NBTTagCompound getScanShortSymbolsNBT(int[] capabilities) {
        NBTTagCompound nbt = new NBTTagCompound();
        ArrayList<String> info = this.getScanShortSymbols(capabilities);
        nbt.func_74768_a("i", info.size());
        for (int i = 0; i < info.size(); ++i) {
            nbt.func_74778_a(Integer.toString(i), info.get(i));
        }
        return nbt;
    }

    public NBTTagCompound getScanInfoNBT(int[] capabilities) {
        NBTTagCompound nbt = new NBTTagCompound();
        ArrayList<String> info = this.getScanInfo(capabilities);
        nbt.func_74768_a("i", info.size());
        for (int i = 0; i < info.size(); ++i) {
            nbt.func_74778_a(Integer.toString(i), info.get(i));
        }
        return nbt;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("i", this.map.size());
        int i = 0;
        for (cElementalInstanceStack instance : this.map.values()) {
            nbt.func_74782_a(Integer.toString(i++), (NBTBase)instance.toNBT());
        }
        return nbt;
    }

    public static cElementalInstanceStackMap fromNBT(NBTTagCompound nbt) throws tElementalException {
        cElementalInstanceStack[] instances = new cElementalInstanceStack[nbt.func_74762_e("i")];
        for (int i = 0; i < instances.length; ++i) {
            instances[i] = cElementalInstanceStack.fromNBT(nbt.func_74775_l(Integer.toString(i)));
            if (!instances[i].definition.equals(cPrimitiveDefinition.nbtE__)) continue;
            throw new tElementalException("Something went Wrong");
        }
        return new cElementalInstanceStackMap(false, instances);
    }

    public static cElementalInstanceStack[] stackUp(cElementalInstanceStack ... in) {
        cElementalInstanceStackMap inTree = new cElementalInstanceStackMap();
        inTree.putUnifyAll(in);
        return inTree.values();
    }

    @Override
    public int compareTo(cElementalInstanceStackMap o) {
        int sizeDiff = this.map.size() - o.map.size();
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        cElementalInstanceStack[] ofThis = this.values();
        cElementalInstanceStack[] ofThat = o.values();
        for (int i = 0; i < ofThat.length; ++i) {
            int result = ofThis[i].compareTo(ofThat[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof cElementalInstanceStackMap) {
            return this.compareTo((cElementalInstanceStackMap)obj) == 0;
        }
        if (obj instanceof cElementalStackMap) {
            return this.toDefinitionMapForComparison().compareTo((cElementalStackMap)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = -(this.map.size() << 4);
        for (cElementalInstanceStack stack : this.map.values()) {
            hash += stack.definition.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder build = new StringBuilder("Instance Stack Map\n");
        for (cElementalInstanceStack stack : this.map.values()) {
            build.append(stack.toString()).append('\n');
        }
        return build.toString();
    }

    public cElementalInstanceStackMap takeAllToNewMap() {
        TreeMap<iElementalDefinition, cElementalInstanceStack> map = this.map;
        this.map = new TreeMap();
        return new cElementalInstanceStackMap(map);
    }

    public void cleanUp() {
        this.map.entrySet().removeIf(entry -> ((cElementalInstanceStack)entry.getValue()).amount < 2.3911762567303394E-19);
    }
}

