/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.dComplexAspectDefinition;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.ePrimalAspectDefinition;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalDecayResult;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalMutableDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.templates.cElementalPrimitive;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.dAtomDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.dHadronDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.eQuarkDefinition;
import com.github.technus.tectech.thing.block.QuantumGlassBlock;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_InputElemental;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OutputElemental;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.DoubleCount;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_StructureUtility;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_EM_collider
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private static Textures.BlockIcons.CustomIcon ScreenON_Slave;
    private static Textures.BlockIcons.CustomIcon ScreenOFF_Slave;
    protected static final byte FUSE_MODE = 0;
    protected static final byte COLLIDE_MODE = 1;
    private static double MASS_TO_EU_INSTANT;
    private static int STARTUP_COST;
    private static int KEEPUP_COST;
    protected byte eTier = 0;
    protected cElementalInstanceStack stack;
    private long plasmaEnergy;
    protected boolean started = false;
    public static final HashMap<Integer, IColliderHandler> FUSE_HANDLERS;
    public static final HashMap<String, IPrimitiveColliderHandler> PRIMITIVE_FUSE_HANDLERS;
    protected Parameters.Group.ParameterIn mode;
    private static final IStatusFunction<GT_MetaTileEntity_EM_collider> MODE_STATUS;
    private static final INameFunction<GT_MetaTileEntity_EM_collider> MODE_NAME;
    private static final String[] description;
    private static final IStructureDefinition<GT_MetaTileEntity_EM_collider> STRUCTURE_DEFINITION;

    private static boolean fuseAspects(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
        try {
            cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
            defs.putUnify(in1.definition.getStackForm(1.0));
            defs.putUnify(in2.definition.getStackForm(1.0));
            dComplexAspectDefinition aspect = new dComplexAspectDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
            out.putUnify(new cElementalInstanceStack(aspect, Math.min(in1.amount, in2.amount)));
        }
        catch (Exception e) {
            out.putUnifyAll(in1, in2);
            return true;
        }
        return false;
    }

    private static void registerSimpleAspectFuse(byte classTypeStatic) {
        FUSE_HANDLERS.put(dComplexAspectDefinition.getClassTypeStatic() << 16 | classTypeStatic, new IColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                if (GT_MetaTileEntity_EM_collider.fuseAspects(in1, in2, out)) {
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 1;
            }
        });
    }

    private static void registerSimpleAtomFuse(byte classTypeStatic) {
        FUSE_HANDLERS.put(dAtomDefinition.getClassTypeStatic() << 16 | classTypeStatic, new IColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                try {
                    cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
                    defs.putUnifyAll(in1.definition.getSubParticles());
                    defs.putUnify(in2.definition.getStackForm(1.0));
                    dAtomDefinition atom = new dAtomDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
                    out.putUnify(new cElementalInstanceStack(atom, Math.min(in1.amount, in2.amount)));
                }
                catch (Exception e) {
                    out.putUnifyAll(in1, in2);
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 1;
            }
        });
    }

    public IStructureDefinition<GT_MetaTileEntity_EM_collider> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public GT_MetaTileEntity_EM_collider(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_collider(String aName) {
        super(aName);
    }

    public static void setValues(int heliumPlasmaValue) {
        double MASS_TO_EU_PARTIAL = (double)heliumPlasmaValue / 1.059252407581521E31;
        MASS_TO_EU_INSTANT = MASS_TO_EU_PARTIAL * 20.0;
        STARTUP_COST = -heliumPlasmaValue * 10000;
        KEEPUP_COST = -heliumPlasmaValue;
    }

    protected double fuse(GT_MetaTileEntity_EM_collider partner) {
        if (partner.stack != null && this.stack != null) {
            IColliderHandler colliderHandler;
            boolean check = this.stack.definition.fusionMakesEnergy(this.stack.getEnergy()) && partner.stack.definition.fusionMakesEnergy(partner.stack.getEnergy());
            cElementalInstanceStack stack2 = partner.stack;
            double preMass = DoubleCount.add(stack2.getMass(), this.stack.getMass());
            cElementalInstanceStackMap map = new cElementalInstanceStackMap();
            if (stack2.definition.getClassType() > this.stack.definition.getClassType() ? this.handleRecipe(stack2, map, colliderHandler = FUSE_HANDLERS.get(stack2.definition.getClassType() << 16 | this.stack.definition.getClassType())) : this.handleRecipe(stack2, map, colliderHandler = FUSE_HANDLERS.get(this.stack.definition.getClassType() << 16 | stack2.definition.getClassType()))) {
                return 0.0;
            }
            for (cElementalInstanceStack newStack : map.values()) {
                check &= newStack.definition.fusionMakesEnergy(newStack.getEnergy());
            }
            this.outputEM = new cElementalInstanceStackMap[]{map};
            this.stack = null;
            partner.stack = null;
            return check ? preMass - map.getMass() : Math.min(preMass - map.getMass(), 0.0);
        }
        return 0.0;
    }

    protected double collide(GT_MetaTileEntity_EM_collider partner) {
        if (partner.stack != null && this.stack != null) {
            IColliderHandler colliderHandler;
            cElementalInstanceStack stack2 = partner.stack;
            double preMass = stack2.getMass() + this.stack.getMass();
            cElementalInstanceStackMap map = new cElementalInstanceStackMap();
            if (stack2.definition.getClassType() > this.stack.definition.getClassType() ? this.handleRecipe(stack2, map, colliderHandler = FUSE_HANDLERS.get(stack2.definition.getClassType() << 16 | this.stack.definition.getClassType())) : this.handleRecipe(stack2, map, colliderHandler = FUSE_HANDLERS.get(this.stack.definition.getClassType() << 16 | stack2.definition.getClassType()))) {
                return 0.0;
            }
            this.outputEM = new cElementalInstanceStackMap[]{map};
            this.stack = null;
            partner.stack = null;
            return Math.min(preMass - map.getMass(), 0.0);
        }
        return 0.0;
    }

    private boolean handleRecipe(cElementalInstanceStack stack2, cElementalInstanceStackMap map, IColliderHandler colliderHandler) {
        if (colliderHandler == null || this.eTier < colliderHandler.getRequiredTier()) {
            map.putUnifyAll(this.stack, stack2);
            this.outputEM = new cElementalInstanceStackMap[]{map};
            return true;
        }
        colliderHandler.collide(stack2, this.stack, map);
        return false;
    }

    protected GT_MetaTileEntity_EM_collider getPartner() {
        int zDir;
        int yDir;
        int xDir;
        IGregTechTileEntity iGregTechTileEntity = this.getBaseMetaTileEntity();
        IGregTechTileEntity gregTechBaseTileEntity = iGregTechTileEntity.getIGregTechTileEntityOffset(xDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetX * 4, yDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetY * 4, zDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetZ * 4);
        if (gregTechBaseTileEntity != null) {
            IMetaTileEntity gregTechMetaTileEntity = gregTechBaseTileEntity.getMetaTileEntity();
            return gregTechMetaTileEntity instanceof GT_MetaTileEntity_EM_collider && ((GT_MetaTileEntity_EM_collider)gregTechMetaTileEntity).mMachine && gregTechBaseTileEntity.getBackFacing() == iGregTechTileEntity.getFrontFacing() ? (GT_MetaTileEntity_EM_collider)gregTechMetaTileEntity : null;
        }
        return null;
    }

    protected final boolean isMaster() {
        return this.getBaseMetaTileEntity().getFrontFacing() % 2 == 0;
    }

    private void makeEU(double massDiff) {
        this.plasmaEnergy = (long)((double)this.plasmaEnergy + massDiff * MASS_TO_EU_INSTANT);
        if (TecTechConfig.DEBUG_MODE) {
            System.out.println("plasmaEnergy = " + this.plasmaEnergy);
        }
    }

    private cElementalInstanceStackMap tickStack() {
        if (this.stack == null) {
            return null;
        }
        cElementalDecayResult newInstances = this.stack.decay(1.0, this.stack.age += 1.0, 0L);
        if (newInstances == null) {
            this.stack.nextColor();
            return null;
        }
        this.stack = newInstances.getOutput().remove(newInstances.getOutput().getLast().definition);
        return newInstances.getOutput();
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_collider(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        int xDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetZ * 2;
        if (iGregTechTileEntity.getBlockOffset(xDir, 0, zDir) != TT_Container_Casings.sBlockCasingsTT) {
            this.eTier = 0;
            return false;
        }
        if (iGregTechTileEntity.getMetaIDOffset(xDir, 0, zDir) == 8) {
            this.eTier = 1;
        } else if (iGregTechTileEntity.getMetaIDOffset(xDir, 0, zDir) == 9) {
            this.eTier = (byte)2;
        } else {
            this.eTier = 0;
            return false;
        }
        if (this.structureCheck_EM("main", 11, 1, 18)) {
            return true;
        }
        this.eTier = 0;
        return false;
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        GT_MetaTileEntity_EM_collider partner = this.getPartner();
        if (partner == null) {
            return false;
        }
        this.mEfficiencyIncrease = 10000;
        if (this.started) {
            if (this.stack == null) {
                for (GT_MetaTileEntity_Hatch_InputElemental inputElemental : this.eInputHatches) {
                    cElementalInstanceStackMap container = inputElemental.getContainerHandler();
                    if (container.isEmpty()) continue;
                    this.stack = container.remove(container.getFirst().definition);
                    long eut = (long)KEEPUP_COST + (long)((double)KEEPUP_COST * Math.abs(this.stack.getMass() / dAtomDefinition.getSomethingHeavy().getMass())) / 2L;
                    if (eut < -2147483641L) {
                        return false;
                    }
                    this.mMaxProgresstime = 20;
                    this.mEUt = (int)eut;
                    this.eAmpereFlow = 5L;
                    return true;
                }
                this.mMaxProgresstime = 20;
                this.mEUt = KEEPUP_COST;
                this.eAmpereFlow = 1L;
                return true;
            }
            this.mMaxProgresstime = 20;
            this.mEUt = KEEPUP_COST;
            this.eAmpereFlow = 2L;
        } else {
            this.started = true;
            this.mMaxProgresstime = 20;
            this.mEUt = STARTUP_COST;
            this.eAmpereFlow = 10L;
        }
        return true;
    }

    @Override
    public void outputAfterRecipe_EM() {
        GT_MetaTileEntity_EM_collider partner = this.getPartner();
        if (partner == null) {
            if (this.stack != null) {
                this.cleanMassEM_EM(this.stack.getMass());
                this.stack = null;
            }
            return;
        }
        if (this.isMaster()) {
            switch ((int)this.mode.get()) {
                case 0: {
                    this.makeEU(this.fuse(partner));
                    break;
                }
                case 1: {
                    this.collide(partner);
                    break;
                }
                default: {
                    this.outputEM = new cElementalInstanceStackMap[2];
                    this.outputEM[1] = this.tickStack();
                    if (this.outputEM[1] == null) {
                        this.outputEM[1] = partner.tickStack();
                        break;
                    }
                    cElementalInstanceStackMap map = partner.tickStack();
                    if (map == null) break;
                    this.outputEM[1].putUnifyAll(map);
                }
            }
            if (this.outputEM != null) {
                int lim = Math.min(this.outputEM.length, this.eOutputHatches.size());
                for (int i = 0; i < lim; ++i) {
                    if (this.outputEM[i] == null) continue;
                    ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(i)).getContainerHandler().putUnifyAll(this.outputEM[i]);
                    this.outputEM[i] = null;
                }
            }
        }
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.desc.0"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.desc.1")};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER_ACTIVE");
        ScreenOFF_Slave = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER_SLAVE");
        ScreenON_Slave = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER_ACTIVE_SLAVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aFacing % 2 == 0) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][4], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][4], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON_Slave : ScreenOFF_Slave))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][4]};
    }

    @Override
    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0);
        this.mode = hatch_0.makeInParameter(0, 0.0, MODE_NAME, MODE_STATUS);
    }

    @Override
    public void parametersStatusesWrite_EM(boolean machineBusy) {
        if (this.isMaster()) {
            super.parametersStatusesWrite_EM(machineBusy);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("eTier", this.eTier);
        aNBT.func_74757_a("eStarted", this.started);
        if (this.stack != null) {
            aNBT.func_74782_a("eStack", (NBTBase)this.stack.toNBT());
        }
        aNBT.func_74772_a("ePlasmaEnergy", this.plasmaEnergy);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.eTier = aNBT.func_74771_c("eTier");
        this.started = aNBT.func_74767_n("eStarted");
        if (aNBT.func_74764_b("eStack")) {
            this.stack = cElementalInstanceStack.fromNBT(aNBT.func_74775_l("eStack"));
        }
        this.plasmaEnergy = aNBT.func_74763_f("ePlasmaEnergy");
    }

    @Override
    public void stopMachine() {
        this.started = false;
        if (this.stack != null) {
            this.cleanMassEM_EM(this.stack.getMass());
            this.stack = null;
        }
        super.stopMachine();
    }

    @Override
    protected void afterRecipeCheckFailed() {
        this.started = false;
        if (this.stack != null) {
            this.cleanMassEM_EM(this.stack.getMass());
            this.stack = null;
        }
        this.getBaseMetaTileEntity().disableWorking();
        super.afterRecipeCheckFailed();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!aBaseMetaTileEntity.isAllowedToWork()) {
            this.started = false;
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        IGregTechTileEntity iGregTechTileEntity = this.getBaseMetaTileEntity();
        int xDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetX * 4;
        int yDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetY * 4;
        int zDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetZ * 4;
        if (hintsOnly) {
            TecTech.proxy.hint_particle(iGregTechTileEntity.getWorld(), iGregTechTileEntity.getXCoord() + xDir, iGregTechTileEntity.getYCoord() + yDir, iGregTechTileEntity.getZCoord() + zDir, TT_Container_Casings.sHintCasingsTT, 12);
        }
        this.structureBuild_EM("main", 11, 1, 18, hintsOnly, stackSize);
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    static {
        FUSE_HANDLERS = new HashMap();
        PRIMITIVE_FUSE_HANDLERS = new HashMap();
        FUSE_HANDLERS.put(dAtomDefinition.getClassTypeStatic() << 16 | dAtomDefinition.getClassTypeStatic(), new IColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                try {
                    cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
                    defs.putUnifyAll(in1.definition.getSubParticles());
                    defs.putUnifyAll(in2.definition.getSubParticles());
                    dAtomDefinition atom = new dAtomDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
                    out.putUnify(new cElementalInstanceStack(atom, Math.min(in1.amount, in2.amount)));
                }
                catch (Exception e) {
                    out.putUnifyAll(in1, in2);
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 1;
            }
        });
        GT_MetaTileEntity_EM_collider.registerSimpleAtomFuse(dHadronDefinition.getClassTypeStatic());
        GT_MetaTileEntity_EM_collider.registerSimpleAtomFuse(dComplexAspectDefinition.getClassTypeStatic());
        GT_MetaTileEntity_EM_collider.registerSimpleAtomFuse(cElementalPrimitive.getClassTypeStatic());
        FUSE_HANDLERS.put(dHadronDefinition.getClassTypeStatic() << 16 | dHadronDefinition.getClassTypeStatic(), new IColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                try {
                    cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
                    defs.putUnifyAll(in1.definition.getSubParticles());
                    defs.putUnifyAll(in2.definition.getSubParticles());
                    dHadronDefinition hadron = new dHadronDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
                    out.putUnify(new cElementalInstanceStack(hadron, Math.min(in1.amount, in2.amount)));
                }
                catch (Exception e) {
                    out.putUnifyAll(in1, in2);
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 2;
            }
        });
        FUSE_HANDLERS.put(dHadronDefinition.getClassTypeStatic() << 16 | cElementalPrimitive.getClassTypeStatic(), new IColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                try {
                    cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
                    defs.putUnifyAll(in1.definition.getSubParticles());
                    defs.putUnify(in2.definition.getStackForm(1.0));
                    dHadronDefinition hadron = new dHadronDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
                    out.putUnify(new cElementalInstanceStack(hadron, Math.min(in1.amount, in2.amount)));
                }
                catch (Exception e) {
                    out.putUnifyAll(in1, in2);
                    return;
                }
                if (in1.amount > in2.amount) {
                    out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
                } else if (in2.amount > in1.amount) {
                    out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 2;
            }
        });
        GT_MetaTileEntity_EM_collider.registerSimpleAspectFuse(dComplexAspectDefinition.getClassTypeStatic());
        GT_MetaTileEntity_EM_collider.registerSimpleAspectFuse(cElementalPrimitive.getClassTypeStatic());
        FUSE_HANDLERS.put(cElementalPrimitive.getClassTypeStatic() << 16 | cElementalPrimitive.getClassTypeStatic(), new IColliderHandler(){

            @Override
            public void collide(cElementalInstanceStack in1, cElementalInstanceStack in2, cElementalInstanceStackMap out) {
                IPrimitiveColliderHandler collisionHandler = PRIMITIVE_FUSE_HANDLERS.get(in1.definition.getClass().getName() + '\u0000' + in2.definition.getClass().getName());
                if (collisionHandler != null) {
                    collisionHandler.collide(in2, in1, out);
                } else {
                    out.putUnifyAll(in1, in2);
                }
            }

            @Override
            public byte getRequiredTier() {
                return 2;
            }
        });
        PRIMITIVE_FUSE_HANDLERS.put(eQuarkDefinition.class.getName() + '\u0000' + eQuarkDefinition.class.getName(), (in1, in2, out) -> {
            try {
                cElementalMutableDefinitionStackMap defs = new cElementalMutableDefinitionStackMap();
                defs.putUnify(in1.definition.getStackForm(1.0));
                defs.putUnify(in2.definition.getStackForm(1.0));
                dHadronDefinition hadron = new dHadronDefinition(defs.toImmutable_optimized_unsafeLeavesExposedElementalTree());
                out.putUnify(new cElementalInstanceStack(hadron, Math.min(in1.amount, in2.amount)));
            }
            catch (Exception e) {
                out.putUnifyAll(in1, in2);
                return;
            }
            if (in1.amount > in2.amount) {
                out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
            } else if (in2.amount > in1.amount) {
                out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
            }
        });
        PRIMITIVE_FUSE_HANDLERS.put(ePrimalAspectDefinition.class.getName() + '\u0000' + ePrimalAspectDefinition.class.getName(), (in1, in2, out) -> {
            if (GT_MetaTileEntity_EM_collider.fuseAspects(in1, in2, out)) {
                return;
            }
            if (in1.amount > in2.amount) {
                out.putUnify(new cElementalInstanceStack(in1.definition, in1.amount - in2.amount));
            } else if (in2.amount > in1.amount) {
                out.putUnify(new cElementalInstanceStack(in2.definition, in2.amount - in1.amount));
            }
        });
        MODE_STATUS = (base_EM, p) -> {
            if (base_EM.isMaster()) {
                double mode = p.get();
                if (mode == 0.0 || mode == 1.0) {
                    return LedStatus.STATUS_OK;
                }
                if (mode > 1.0) {
                    return LedStatus.STATUS_TOO_HIGH;
                }
                if (mode < 0.0) {
                    return LedStatus.STATUS_TOO_LOW;
                }
                return LedStatus.STATUS_WRONG;
            }
            return LedStatus.STATUS_OK;
        };
        MODE_NAME = (base_EM, p) -> {
            if (base_EM.isMaster()) {
                double mode = p.get();
                if (mode == 0.0) {
                    return StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.mode.0");
                }
                if (mode == 1.0) {
                    return StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.mode.1");
                }
                return StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.mode.2");
            }
            return StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.mode.3");
        };
        description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.hint.1"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.hint.2"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.hint.3"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.hint.4")};
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"         A A A         ", "        AAAAAAA        ", "      BBBBIIIBBBB      ", "     BAAAAAAAAAAAB     ", "    BAAAA     AAAAB    ", "   BAAA         AAAB   ", "  BAAA           AAAB  ", "  BAA             AAB  ", " ABAA             AABA ", "AABA               ABAA", " AIA               AIA ", "AAIA               AIAA", " AIA               AIA ", "AABA               ABAA", " ABAA             AABA ", "  BAA             AAB  ", "  BAAA           AAAB  ", "   BAAA         AAAB   ", "    BAAAABJJJBAAAAB    ", "     BAHHBBBBBHHAB     ", "      BBBBGFGBBBB      "}, {"         AAAAA         ", "       AADDDDDAA       ", "      CDDEEEEEDDC      ", "     CDEEDDDDDEEDC     ", "    CDEDD     DDEDC    ", "   CDED         DEDC   ", "  CDED           DEDC  ", " ADED             DEDA ", " ADED             DEDA ", "ADED               DEDA", "ADED               DEDA", "ADED               DEDA", "ADED               DEDA", "ADED               DEDA", " ADED             DEDA ", " ADED             DEDA ", "  CDED           DEDC  ", "   CDED         DEDC   ", "    CDEDDBJ~JBDDEDC    ", "     CDEEDDDDDEEDC     ", "      CDDEEEEEDDC      "}, {"         A A A         ", "        AAAAAAA        ", "      BBBBIIIBBBB      ", "     BAAAAAAAAAAAB     ", "    BAAAA     AAAAB    ", "   BAAA         AAAB   ", "  BAAA           AAAB  ", "  BAA             AAB  ", " ABAA             AABA ", "AABA               ABAA", " AIA               AIA ", "AAIA               AIAA", " AIA               AIA ", "AABA               ABAA", " ABAA             AABA ", "  BAA             AAB  ", "  BAAA           AAAB  ", "   BAAA         AAAB   ", "    BAAAABJJJBAAAAB    ", "     BAHHBBBBBHHAB     ", "      BBBBGFGBBBB      "}})).addElement(Character.valueOf('A'), StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)4)).addElement(Character.valueOf('B'), (IStructureElement)StructureUtility.defer(t -> t.eTier, (t, item) -> 2 - (item.field_77994_a & 1), (IStructureElement[])new IStructureElement[]{StructureUtility.error(), StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)4), StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)5)})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.defer(t -> t.eTier, (t, item) -> 2 - (item.field_77994_a & 1), (IStructureElement[])new IStructureElement[]{StructureUtility.error(), StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)4), StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)6)})).addElement(Character.valueOf('D'), StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)7)).addElement(Character.valueOf('E'), (IStructureElement)StructureUtility.defer(t -> t.eTier, (t, item) -> 2 - (item.field_77994_a & 1), (IStructureElement[])new IStructureElement[]{StructureUtility.error(), StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)8), StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)9)})).addElement(Character.valueOf('F'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiblockBase_EM::addElementalOutputToMachineList, (int)1028, (int)3, (Block)TT_Container_Casings.sBlockCasingsTT, (int)4)).addElement(Character.valueOf('G'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiblockBase_EM::addElementalMufflerToMachineList, (int)1028, (int)4, (Block)TT_Container_Casings.sBlockCasingsTT, (int)4)).addElement(Character.valueOf('H'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiblockBase_EM::addElementalInputToMachineList, (int)1028, (int)2, (Block)TT_Container_Casings.sBlockCasingsTT, (int)4)).addElement(Character.valueOf('I'), StructureUtility.ofBlock((Block)QuantumGlassBlock.INSTANCE, (int)0)).addElement(Character.valueOf('J'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiblockBase_EM::addClassicToMachineList, (int)1024, (int)1, (Block)TT_Container_Casings.sBlockCasingsTT, (int)0)).build();
    }

    public static interface IColliderHandler
    extends IPrimitiveColliderHandler {
        public byte getRequiredTier();
    }

    public static interface IPrimitiveColliderHandler {
        public void collide(cElementalInstanceStack var1, cElementalInstanceStack var2, cElementalInstanceStackMap var3);
    }
}

