/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi.base.render;

import com.github.technus.tectech.util.LightingHelper;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TT_RenderedExtendedFacingTexture
implements ITexture,
IColorModulationContainer {
    private final IIconContainer mIconContainer;
    private final boolean mAllowAlpha;
    public short[] mRGBa;

    public TT_RenderedExtendedFacingTexture(IIconContainer aIcon, short[] aRGBa, boolean aAllowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ TT_RenderedTexture");
        }
        this.mIconContainer = aIcon;
        this.mAllowAlpha = aAllowAlpha;
        this.mRGBa = aRGBa;
    }

    public TT_RenderedExtendedFacingTexture(IIconContainer aIcon, short[] aRGBa) {
        this(aIcon, aRGBa, true);
    }

    public TT_RenderedExtendedFacingTexture(IIconContainer aIcon) {
        this(aIcon, Dyes._NULL.mRGBa);
    }

    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        aRenderer.field_152631_f = true;
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingXPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.EAST.ordinal(), this.mRGBa);
        ExtendedFacing rotation = TT_RenderedExtendedFacingTexture.getExtendedFacing(aX, aY, aZ);
        this.renderFaceXPos(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.EAST.ordinal(), 0xFFFFFF);
            this.renderFaceXPos(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.field_152631_f = false;
    }

    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingXNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.WEST.ordinal(), this.mRGBa);
        ExtendedFacing rotation = TT_RenderedExtendedFacingTexture.getExtendedFacing(aX, aY, aZ);
        this.renderFaceXNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.WEST.ordinal(), 0xFFFFFF);
            this.renderFaceXNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
    }

    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingYPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.UP.ordinal(), this.mRGBa);
        ExtendedFacing rotation = TT_RenderedExtendedFacingTexture.getExtendedFacing(aX, aY, aZ);
        this.renderFaceYPos(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.UP.ordinal(), 0xFFFFFF);
            this.renderFaceYPos(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
    }

    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingYNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.DOWN.ordinal(), this.mRGBa);
        ExtendedFacing rotation = TT_RenderedExtendedFacingTexture.getExtendedFacing(aX, aY, aZ);
        this.renderFaceYNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78370_a(255, 255, 255, 255);
            this.renderFaceYNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
    }

    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingZPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.SOUTH.ordinal(), this.mRGBa);
        ExtendedFacing rotation = TT_RenderedExtendedFacingTexture.getExtendedFacing(aX, aY, aZ);
        this.renderFaceZPos(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.SOUTH.ordinal(), 0xFFFFFF);
            this.renderFaceZPos(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
    }

    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        aRenderer.field_152631_f = true;
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingZNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.NORTH.ordinal(), this.mRGBa);
        ExtendedFacing rotation = TT_RenderedExtendedFacingTexture.getExtendedFacing(aX, aY, aZ);
        this.renderFaceZNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.NORTH.ordinal(), 0xFFFFFF);
            this.renderFaceZNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.field_152631_f = false;
    }

    public void renderFaceYNeg(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing rotation) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (aRenderer.func_147744_b()) {
            icon = aRenderer.field_147840_d;
        }
        double d3 = icon.func_94214_a(aRenderer.field_147861_i * 16.0);
        double d4 = icon.func_94214_a(aRenderer.field_147859_h * 16.0);
        double d5 = icon.func_94207_b(aRenderer.field_147851_l * 16.0);
        double d6 = icon.func_94207_b(aRenderer.field_147853_m * 16.0);
        if (aRenderer.field_147859_h < 0.0 || aRenderer.field_147861_i > 1.0) {
            d3 = icon.func_94212_f();
            d4 = icon.func_94209_e();
        }
        if (aRenderer.field_147851_l < 0.0 || aRenderer.field_147853_m > 1.0) {
            d5 = icon.func_94206_g();
            d6 = icon.func_94210_h();
        }
        switch (rotation.getFlip().ordinal()) {
            case 1: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
                break;
            }
            case 2: {
                double temp = d5;
                d5 = d6;
                d6 = temp;
            }
            case 3: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
            }
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        switch (rotation.getRotation().ordinal()) {
            case 3: {
                d3 = icon.func_94214_a(aRenderer.field_147853_m * 16.0);
                d5 = icon.func_94207_b(16.0 - aRenderer.field_147861_i * 16.0);
                d4 = icon.func_94214_a(aRenderer.field_147851_l * 16.0);
                d6 = icon.func_94207_b(16.0 - aRenderer.field_147859_h * 16.0);
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
                break;
            }
            case 1: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147851_l * 16.0);
                d5 = icon.func_94207_b(aRenderer.field_147859_h * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147853_m * 16.0);
                d6 = icon.func_94207_b(aRenderer.field_147861_i * 16.0);
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
                break;
            }
            case 2: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147861_i * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147859_h * 16.0);
                d5 = icon.func_94207_b(16.0 - aRenderer.field_147851_l * 16.0);
                d6 = icon.func_94207_b(16.0 - aRenderer.field_147853_m * 16.0);
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
        }
        double d11 = x + aRenderer.field_147859_h;
        double d12 = x + aRenderer.field_147861_i;
        double d13 = y + aRenderer.field_147855_j;
        double d14 = z + aRenderer.field_147851_l;
        double d15 = z + aRenderer.field_147853_m;
        if (aRenderer.field_147838_g) {
            d11 = x + aRenderer.field_147861_i;
            d12 = x + aRenderer.field_147859_h;
        }
        if (aRenderer.field_147863_w) {
            tessellator.func_78386_a(aRenderer.field_147872_ap, aRenderer.field_147846_at, aRenderer.field_147854_ax);
            tessellator.func_78380_c(aRenderer.field_147864_al);
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
            tessellator.func_78386_a(aRenderer.field_147852_aq, aRenderer.field_147860_au, aRenderer.field_147841_ay);
            tessellator.func_78380_c(aRenderer.field_147874_am);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78386_a(aRenderer.field_147850_ar, aRenderer.field_147858_av, aRenderer.field_147839_az);
            tessellator.func_78380_c(aRenderer.field_147876_an);
            tessellator.func_78374_a(d12, d13, d14, d7, d9);
            tessellator.func_78386_a(aRenderer.field_147848_as, aRenderer.field_147856_aw, aRenderer.field_147833_aA);
            tessellator.func_78380_c(aRenderer.field_147870_ao);
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
        } else {
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78374_a(d12, d13, d14, d7, d9);
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
        }
    }

    public void renderFaceYPos(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing rotation) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (aRenderer.func_147744_b()) {
            icon = aRenderer.field_147840_d;
        }
        double d3 = icon.func_94214_a(aRenderer.field_147859_h * 16.0);
        double d4 = icon.func_94214_a(aRenderer.field_147861_i * 16.0);
        double d5 = icon.func_94207_b(aRenderer.field_147851_l * 16.0);
        double d6 = icon.func_94207_b(aRenderer.field_147853_m * 16.0);
        if (aRenderer.field_147859_h < 0.0 || aRenderer.field_147861_i > 1.0) {
            d3 = icon.func_94209_e();
            d4 = icon.func_94212_f();
        }
        if (aRenderer.field_147851_l < 0.0 || aRenderer.field_147853_m > 1.0) {
            d5 = icon.func_94206_g();
            d6 = icon.func_94210_h();
        }
        switch (rotation.getFlip().ordinal()) {
            case 1: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
                break;
            }
            case 2: {
                double temp = d5;
                d5 = d6;
                d6 = temp;
            }
            case 3: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
            }
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        switch (rotation.getRotation().ordinal()) {
            case 1: {
                d3 = icon.func_94214_a(aRenderer.field_147851_l * 16.0);
                d5 = icon.func_94207_b(16.0 - aRenderer.field_147861_i * 16.0);
                d4 = icon.func_94214_a(aRenderer.field_147853_m * 16.0);
                d6 = icon.func_94207_b(16.0 - aRenderer.field_147859_h * 16.0);
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
                break;
            }
            case 3: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147853_m * 16.0);
                d5 = icon.func_94207_b(aRenderer.field_147859_h * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147851_l * 16.0);
                d6 = icon.func_94207_b(aRenderer.field_147861_i * 16.0);
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
                break;
            }
            case 2: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147859_h * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147861_i * 16.0);
                d5 = icon.func_94207_b(16.0 - aRenderer.field_147851_l * 16.0);
                d6 = icon.func_94207_b(16.0 - aRenderer.field_147853_m * 16.0);
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
        }
        double d11 = x + aRenderer.field_147859_h;
        double d12 = x + aRenderer.field_147861_i;
        double d13 = y + aRenderer.field_147857_k;
        double d14 = z + aRenderer.field_147851_l;
        double d15 = z + aRenderer.field_147853_m;
        if (aRenderer.field_147838_g) {
            d11 = x + aRenderer.field_147861_i;
            d12 = x + aRenderer.field_147859_h;
        }
        if (aRenderer.field_147863_w) {
            tessellator.func_78386_a(aRenderer.field_147872_ap, aRenderer.field_147846_at, aRenderer.field_147854_ax);
            tessellator.func_78380_c(aRenderer.field_147864_al);
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
            tessellator.func_78386_a(aRenderer.field_147852_aq, aRenderer.field_147860_au, aRenderer.field_147841_ay);
            tessellator.func_78380_c(aRenderer.field_147874_am);
            tessellator.func_78374_a(d12, d13, d14, d7, d9);
            tessellator.func_78386_a(aRenderer.field_147850_ar, aRenderer.field_147858_av, aRenderer.field_147839_az);
            tessellator.func_78380_c(aRenderer.field_147876_an);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78386_a(aRenderer.field_147848_as, aRenderer.field_147856_aw, aRenderer.field_147833_aA);
            tessellator.func_78380_c(aRenderer.field_147870_ao);
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
        } else {
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
            tessellator.func_78374_a(d12, d13, d14, d7, d9);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
        }
    }

    public void renderFaceZNeg(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing rotation) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (aRenderer.func_147744_b()) {
            icon = aRenderer.field_147840_d;
        }
        double d3 = icon.func_94214_a(aRenderer.field_147859_h * 16.0);
        double d4 = icon.func_94214_a(aRenderer.field_147861_i * 16.0);
        if (aRenderer.field_152631_f) {
            d4 = icon.func_94214_a((1.0 - aRenderer.field_147859_h) * 16.0);
            d3 = icon.func_94214_a((1.0 - aRenderer.field_147861_i) * 16.0);
        }
        double d5 = icon.func_94207_b(16.0 - aRenderer.field_147857_k * 16.0);
        double d6 = icon.func_94207_b(16.0 - aRenderer.field_147855_j * 16.0);
        if (aRenderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (aRenderer.field_147859_h < 0.0 || aRenderer.field_147861_i > 1.0) {
            d3 = icon.func_94209_e();
            d4 = icon.func_94212_f();
        }
        if (aRenderer.field_147855_j < 0.0 || aRenderer.field_147857_k > 1.0) {
            d5 = icon.func_94206_g();
            d6 = icon.func_94210_h();
        }
        switch (rotation.getFlip().ordinal()) {
            case 1: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
                break;
            }
            case 2: {
                double temp = d5;
                d5 = d6;
                d6 = temp;
            }
            case 3: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
            }
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        switch (rotation.getRotation().ordinal()) {
            case 3: {
                d3 = icon.func_94214_a(aRenderer.field_147857_k * 16.0);
                d4 = icon.func_94214_a(aRenderer.field_147855_j * 16.0);
                d5 = icon.func_94207_b(16.0 - aRenderer.field_147859_h * 16.0);
                d6 = icon.func_94207_b(16.0 - aRenderer.field_147861_i * 16.0);
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
                break;
            }
            case 1: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147855_j * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147857_k * 16.0);
                d5 = icon.func_94207_b(aRenderer.field_147861_i * 16.0);
                d6 = icon.func_94207_b(aRenderer.field_147859_h * 16.0);
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
                break;
            }
            case 2: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147859_h * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147861_i * 16.0);
                d5 = icon.func_94207_b(aRenderer.field_147857_k * 16.0);
                d6 = icon.func_94207_b(aRenderer.field_147855_j * 16.0);
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
        }
        double d11 = x + aRenderer.field_147859_h;
        double d12 = x + aRenderer.field_147861_i;
        double d13 = y + aRenderer.field_147855_j;
        double d14 = y + aRenderer.field_147857_k;
        double d15 = z + aRenderer.field_147851_l;
        if (aRenderer.field_147838_g) {
            d11 = x + aRenderer.field_147861_i;
            d12 = x + aRenderer.field_147859_h;
        }
        if (aRenderer.field_147863_w) {
            tessellator.func_78386_a(aRenderer.field_147872_ap, aRenderer.field_147846_at, aRenderer.field_147854_ax);
            tessellator.func_78380_c(aRenderer.field_147864_al);
            tessellator.func_78374_a(d11, d14, d15, d7, d9);
            tessellator.func_78386_a(aRenderer.field_147852_aq, aRenderer.field_147860_au, aRenderer.field_147841_ay);
            tessellator.func_78380_c(aRenderer.field_147874_am);
            tessellator.func_78374_a(d12, d14, d15, d3, d5);
            tessellator.func_78386_a(aRenderer.field_147850_ar, aRenderer.field_147858_av, aRenderer.field_147839_az);
            tessellator.func_78380_c(aRenderer.field_147876_an);
            tessellator.func_78374_a(d12, d13, d15, d8, d10);
            tessellator.func_78386_a(aRenderer.field_147848_as, aRenderer.field_147856_aw, aRenderer.field_147833_aA);
            tessellator.func_78380_c(aRenderer.field_147870_ao);
            tessellator.func_78374_a(d11, d13, d15, d4, d6);
        } else {
            tessellator.func_78374_a(d11, d14, d15, d7, d9);
            tessellator.func_78374_a(d12, d14, d15, d3, d5);
            tessellator.func_78374_a(d12, d13, d15, d8, d10);
            tessellator.func_78374_a(d11, d13, d15, d4, d6);
        }
    }

    public void renderFaceZPos(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing rotation) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (aRenderer.func_147744_b()) {
            icon = aRenderer.field_147840_d;
        }
        double d3 = icon.func_94214_a(aRenderer.field_147859_h * 16.0);
        double d4 = icon.func_94214_a(aRenderer.field_147861_i * 16.0);
        double d5 = icon.func_94207_b(16.0 - aRenderer.field_147857_k * 16.0);
        double d6 = icon.func_94207_b(16.0 - aRenderer.field_147855_j * 16.0);
        if (aRenderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (aRenderer.field_147859_h < 0.0 || aRenderer.field_147861_i > 1.0) {
            d3 = icon.func_94209_e();
            d4 = icon.func_94212_f();
        }
        if (aRenderer.field_147855_j < 0.0 || aRenderer.field_147857_k > 1.0) {
            d5 = icon.func_94206_g();
            d6 = icon.func_94210_h();
        }
        switch (rotation.getFlip().ordinal()) {
            case 1: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
                break;
            }
            case 2: {
                double temp = d5;
                d5 = d6;
                d6 = temp;
            }
            case 3: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
            }
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        switch (rotation.getRotation().ordinal()) {
            case 1: {
                d3 = icon.func_94214_a(aRenderer.field_147855_j * 16.0);
                d6 = icon.func_94207_b(16.0 - aRenderer.field_147859_h * 16.0);
                d4 = icon.func_94214_a(aRenderer.field_147857_k * 16.0);
                d9 = d5 = (double)icon.func_94207_b(16.0 - aRenderer.field_147861_i * 16.0);
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
                break;
            }
            case 3: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147857_k * 16.0);
                d5 = icon.func_94207_b(aRenderer.field_147859_h * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147855_j * 16.0);
                d6 = icon.func_94207_b(aRenderer.field_147861_i * 16.0);
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
                break;
            }
            case 2: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147859_h * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147861_i * 16.0);
                d5 = icon.func_94207_b(aRenderer.field_147857_k * 16.0);
                d6 = icon.func_94207_b(aRenderer.field_147855_j * 16.0);
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
        }
        double d11 = x + aRenderer.field_147859_h;
        double d12 = x + aRenderer.field_147861_i;
        double d13 = y + aRenderer.field_147855_j;
        double d14 = y + aRenderer.field_147857_k;
        double d15 = z + aRenderer.field_147853_m;
        if (aRenderer.field_147838_g) {
            d11 = x + aRenderer.field_147861_i;
            d12 = x + aRenderer.field_147859_h;
        }
        if (aRenderer.field_147863_w) {
            tessellator.func_78386_a(aRenderer.field_147872_ap, aRenderer.field_147846_at, aRenderer.field_147854_ax);
            tessellator.func_78380_c(aRenderer.field_147864_al);
            tessellator.func_78374_a(d11, d14, d15, d3, d5);
            tessellator.func_78386_a(aRenderer.field_147852_aq, aRenderer.field_147860_au, aRenderer.field_147841_ay);
            tessellator.func_78380_c(aRenderer.field_147874_am);
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
            tessellator.func_78386_a(aRenderer.field_147850_ar, aRenderer.field_147858_av, aRenderer.field_147839_az);
            tessellator.func_78380_c(aRenderer.field_147876_an);
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
            tessellator.func_78386_a(aRenderer.field_147848_as, aRenderer.field_147856_aw, aRenderer.field_147833_aA);
            tessellator.func_78380_c(aRenderer.field_147870_ao);
            tessellator.func_78374_a(d12, d14, d15, d7, d9);
        } else {
            tessellator.func_78374_a(d11, d14, d15, d3, d5);
            tessellator.func_78374_a(d11, d13, d15, d8, d10);
            tessellator.func_78374_a(d12, d13, d15, d4, d6);
            tessellator.func_78374_a(d12, d14, d15, d7, d9);
        }
    }

    public void renderFaceXNeg(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing rotation) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (aRenderer.func_147744_b()) {
            icon = aRenderer.field_147840_d;
        }
        double d3 = icon.func_94214_a(aRenderer.field_147851_l * 16.0);
        double d4 = icon.func_94214_a(aRenderer.field_147853_m * 16.0);
        double d5 = icon.func_94207_b(16.0 - aRenderer.field_147857_k * 16.0);
        double d6 = icon.func_94207_b(16.0 - aRenderer.field_147855_j * 16.0);
        if (aRenderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (aRenderer.field_147851_l < 0.0 || aRenderer.field_147853_m > 1.0) {
            d3 = icon.func_94209_e();
            d4 = icon.func_94212_f();
        }
        if (aRenderer.field_147855_j < 0.0 || aRenderer.field_147857_k > 1.0) {
            d5 = icon.func_94206_g();
            d6 = icon.func_94210_h();
        }
        switch (rotation.getFlip().ordinal()) {
            case 1: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
                break;
            }
            case 2: {
                double temp = d5;
                d5 = d6;
                d6 = temp;
            }
            case 3: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
            }
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        switch (rotation.getRotation().ordinal()) {
            case 1: {
                d3 = icon.func_94214_a(aRenderer.field_147855_j * 16.0);
                d5 = icon.func_94207_b(16.0 - aRenderer.field_147853_m * 16.0);
                d4 = icon.func_94214_a(aRenderer.field_147857_k * 16.0);
                d6 = icon.func_94207_b(16.0 - aRenderer.field_147851_l * 16.0);
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
                break;
            }
            case 3: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147857_k * 16.0);
                d5 = icon.func_94207_b(aRenderer.field_147851_l * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147855_j * 16.0);
                d6 = icon.func_94207_b(aRenderer.field_147853_m * 16.0);
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
                break;
            }
            case 2: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147851_l * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147853_m * 16.0);
                d5 = icon.func_94207_b(aRenderer.field_147857_k * 16.0);
                d6 = icon.func_94207_b(aRenderer.field_147855_j * 16.0);
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
        }
        double d11 = x + aRenderer.field_147859_h;
        double d12 = y + aRenderer.field_147855_j;
        double d13 = y + aRenderer.field_147857_k;
        double d14 = z + aRenderer.field_147851_l;
        double d15 = z + aRenderer.field_147853_m;
        if (aRenderer.field_147838_g) {
            d14 = z + aRenderer.field_147853_m;
            d15 = z + aRenderer.field_147851_l;
        }
        if (aRenderer.field_147863_w) {
            tessellator.func_78386_a(aRenderer.field_147872_ap, aRenderer.field_147846_at, aRenderer.field_147854_ax);
            tessellator.func_78380_c(aRenderer.field_147864_al);
            tessellator.func_78374_a(d11, d13, d15, d7, d9);
            tessellator.func_78386_a(aRenderer.field_147852_aq, aRenderer.field_147860_au, aRenderer.field_147841_ay);
            tessellator.func_78380_c(aRenderer.field_147874_am);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78386_a(aRenderer.field_147850_ar, aRenderer.field_147858_av, aRenderer.field_147839_az);
            tessellator.func_78380_c(aRenderer.field_147876_an);
            tessellator.func_78374_a(d11, d12, d14, d8, d10);
            tessellator.func_78386_a(aRenderer.field_147848_as, aRenderer.field_147856_aw, aRenderer.field_147833_aA);
            tessellator.func_78380_c(aRenderer.field_147870_ao);
            tessellator.func_78374_a(d11, d12, d15, d4, d6);
        } else {
            tessellator.func_78374_a(d11, d13, d15, d7, d9);
            tessellator.func_78374_a(d11, d13, d14, d3, d5);
            tessellator.func_78374_a(d11, d12, d14, d8, d10);
            tessellator.func_78374_a(d11, d12, d15, d4, d6);
        }
    }

    public void renderFaceXPos(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing rotation) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (aRenderer.func_147744_b()) {
            icon = aRenderer.field_147840_d;
        }
        double d3 = icon.func_94214_a(aRenderer.field_147851_l * 16.0);
        double d4 = icon.func_94214_a(aRenderer.field_147853_m * 16.0);
        if (aRenderer.field_152631_f) {
            d4 = icon.func_94214_a((1.0 - aRenderer.field_147851_l) * 16.0);
            d3 = icon.func_94214_a((1.0 - aRenderer.field_147853_m) * 16.0);
        }
        double d5 = icon.func_94207_b(16.0 - aRenderer.field_147857_k * 16.0);
        double d6 = icon.func_94207_b(16.0 - aRenderer.field_147855_j * 16.0);
        if (aRenderer.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (aRenderer.field_147851_l < 0.0 || aRenderer.field_147853_m > 1.0) {
            d3 = icon.func_94209_e();
            d4 = icon.func_94212_f();
        }
        if (aRenderer.field_147855_j < 0.0 || aRenderer.field_147857_k > 1.0) {
            d5 = icon.func_94206_g();
            d6 = icon.func_94210_h();
        }
        switch (rotation.getFlip().ordinal()) {
            case 1: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
                break;
            }
            case 2: {
                double temp = d5;
                d5 = d6;
                d6 = temp;
            }
            case 3: {
                double temp = d3;
                d3 = d4;
                d4 = temp;
            }
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        switch (rotation.getRotation().ordinal()) {
            case 3: {
                d3 = icon.func_94214_a(aRenderer.field_147857_k * 16.0);
                d5 = icon.func_94207_b(16.0 - aRenderer.field_147851_l * 16.0);
                d4 = icon.func_94214_a(aRenderer.field_147855_j * 16.0);
                d6 = icon.func_94207_b(16.0 - aRenderer.field_147853_m * 16.0);
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
                break;
            }
            case 1: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147855_j * 16.0);
                d5 = icon.func_94207_b(aRenderer.field_147853_m * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147857_k * 16.0);
                d6 = icon.func_94207_b(aRenderer.field_147851_l * 16.0);
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
                break;
            }
            case 2: {
                d3 = icon.func_94214_a(16.0 - aRenderer.field_147851_l * 16.0);
                d4 = icon.func_94214_a(16.0 - aRenderer.field_147853_m * 16.0);
                d5 = icon.func_94207_b(aRenderer.field_147857_k * 16.0);
                d6 = icon.func_94207_b(aRenderer.field_147855_j * 16.0);
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
        }
        double d11 = x + aRenderer.field_147861_i;
        double d12 = y + aRenderer.field_147855_j;
        double d13 = y + aRenderer.field_147857_k;
        double d14 = z + aRenderer.field_147851_l;
        double d15 = z + aRenderer.field_147853_m;
        if (aRenderer.field_147838_g) {
            d14 = z + aRenderer.field_147853_m;
            d15 = z + aRenderer.field_147851_l;
        }
        if (aRenderer.field_147863_w) {
            tessellator.func_78386_a(aRenderer.field_147872_ap, aRenderer.field_147846_at, aRenderer.field_147854_ax);
            tessellator.func_78380_c(aRenderer.field_147864_al);
            tessellator.func_78374_a(d11, d12, d15, d8, d10);
            tessellator.func_78386_a(aRenderer.field_147852_aq, aRenderer.field_147860_au, aRenderer.field_147841_ay);
            tessellator.func_78380_c(aRenderer.field_147874_am);
            tessellator.func_78374_a(d11, d12, d14, d4, d6);
            tessellator.func_78386_a(aRenderer.field_147850_ar, aRenderer.field_147858_av, aRenderer.field_147839_az);
            tessellator.func_78380_c(aRenderer.field_147876_an);
            tessellator.func_78374_a(d11, d13, d14, d7, d9);
            tessellator.func_78386_a(aRenderer.field_147848_as, aRenderer.field_147856_aw, aRenderer.field_147833_aA);
            tessellator.func_78380_c(aRenderer.field_147870_ao);
            tessellator.func_78374_a(d11, d13, d15, d3, d5);
        } else {
            tessellator.func_78374_a(d11, d12, d15, d8, d10);
            tessellator.func_78374_a(d11, d12, d14, d4, d6);
            tessellator.func_78374_a(d11, d13, d14, d7, d9);
            tessellator.func_78374_a(d11, d13, d15, d3, d5);
        }
    }

    public short[] getRGBA() {
        return this.mRGBa;
    }

    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }

    private static ExtendedFacing getExtendedFacing(int x, int y, int z) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w != null) {
            TileEntity te = w.func_147438_o(x, y, z);
            if (te instanceof IGregTechTileEntity) {
                IMetaTileEntity meta = ((IGregTechTileEntity)te).getMetaTileEntity();
                if (meta instanceof IAlignmentProvider) {
                    return ((IAlignmentProvider)meta).getAlignment().getExtendedFacing();
                }
                return ExtendedFacing.of((ForgeDirection)ForgeDirection.getOrientation((int)meta.getBaseMetaTileEntity().getFrontFacing()));
            }
            if (te instanceof IAlignmentProvider) {
                return ((IAlignmentProvider)te).getAlignment().getExtendedFacing();
            }
        }
        return ExtendedFacing.DEFAULT;
    }
}

