/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.single;

import com.github.technus.tectech.recipe.TT_recipeAdder;
import com.github.technus.tectech.thing.metaTileEntity.Textures;
import com.github.technus.tectech.thing.metaTileEntity.single.gui.GT_Container_DataReader;
import com.github.technus.tectech.thing.metaTileEntity.single.gui.GT_GUIContainer_DataReader;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.Util;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Slot_Holo;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_DataReader
extends GT_MetaTileEntity_BasicMachine {
    private static final HashMap<Util.ItemStack_NoNBT, ArrayList<IDataRender>> RENDER_REGISTRY = new HashMap();
    public static GT_RenderedTexture READER_ONLINE;
    public static GT_RenderedTexture READER_OFFLINE;

    public GT_MetaTileEntity_DataReader(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "", 1, 1, "dataReader.png", "", new ITexture[0]);
        Util.setTier(aTier, (Object)this);
    }

    public GT_MetaTileEntity_DataReader(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, "dataReader.png", "");
        Util.setTier(aTier, (Object)this);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DataReader(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        READER_ONLINE = new GT_RenderedTexture((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/READER_ONLINE"));
        READER_OFFLINE = new GT_RenderedTexture((IIconContainer)new Textures.BlockIcons.CustomIcon("iconsets/READER_OFFLINE"));
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aBaseMetaTileEntity.getWorld() == null) {
            if (aSide == aFacing) {
                return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1], aActive ? READER_ONLINE : READER_OFFLINE};
            }
            return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1]};
        }
        if (aSide == this.mMainFacing) {
            return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1], aActive ? READER_ONLINE : READER_OFFLINE};
        }
        if (aSide == aFacing) {
            return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT)};
        }
        return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][aColorIndex + 1]};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    public int checkRecipe() {
        if (this.getOutputAt(0) != null) {
            return 0;
        }
        ItemStack input = this.getInputAt(0);
        for (IDataRender render : GT_MetaTileEntity_DataReader.getRenders(new Util.ItemStack_NoNBT(input))) {
            if (!render.canRender(input, this.mTier)) continue;
            this.mOutputItems[0] = input.func_77946_l();
            --input.field_77994_a;
            this.calculateOverclockedNess(render.getReadingEUt(), render.getReadingTime());
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        aBaseMetaTileEntity.setActive(this.getOutputAt(0) != null || this.mMaxProgresstime > 0);
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_DataReader(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_DataReader(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), this.mGUIName, GT_Utility.isStringValid((Object)this.mNEIName) ? this.mNEIName : (this.getRecipeList() != null ? this.getRecipeList().mUnlocalizedName : ""));
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.datareader.desc.0"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.datareader.desc.1"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.datareader.desc.2")};
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isInputFacing(byte aSide) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public long maxEUInput() {
        return CommonValues.V[this.mTier];
    }

    public long maxEUStore() {
        return this.maxEUInput() * 16L;
    }

    public long getMinimumStoredEU() {
        return this.maxEUInput() * 4L;
    }

    public static void addDataRender(Util.ItemStack_NoNBT stack, IDataRender render) {
        ArrayList renders = RENDER_REGISTRY.computeIfAbsent(stack, k -> new ArrayList());
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            render.loadResources();
        }
        renders.add(render);
    }

    public static List<IDataRender> getRenders(Util.ItemStack_NoNBT stack) {
        ArrayList<IDataRender> iDataRenders = RENDER_REGISTRY.get(stack);
        return iDataRenders == null ? Collections.emptyList() : iDataRenders;
    }

    public static void run() {
        GT_MetaTileEntity_DataReader.addDataRender(new Util.ItemStack_NoNBT(ItemList.Tool_DataStick.get(1L, new Object[0])), new IDataRender(){
            @SideOnly(value=Side.CLIENT)
            private ResourceLocation bg;
            @SideOnly(value=Side.CLIENT)
            private HashMap<GT_Slot_Holo, ItemStack> slots;
            private HashMap<GT_Slot_Holo, ItemStack[]> slots2;

            @Override
            @SideOnly(value=Side.CLIENT)
            public void loadResources() {
                this.bg = new ResourceLocation("tectech:textures/gui/assLineRender.png");
            }

            @Override
            public void initRender(ItemStack itemStack) {
                int i;
                this.slots = new HashMap();
                this.slots2 = new HashMap();
                this.slots.put(new GT_Slot_Holo(null, 0, 143, 55, false, false, 1), ItemList.Tool_DataStick.getWithName(1L, "Research data", new Object[0]));
                ItemStack output = ItemStack.func_77949_a((NBTTagCompound)itemStack.field_77990_d.func_74775_l("output"));
                if (output != null) {
                    this.slots.put(new GT_Slot_Holo(null, 0, 143, 19, false, false, 64), output);
                }
                for (i = 0; i < 16; ++i) {
                    ArrayList<ItemStack> array = new ArrayList<ItemStack>();
                    ItemStack input = ItemStack.func_77949_a((NBTTagCompound)itemStack.field_77990_d.func_74775_l(Integer.toString(i)));
                    if (input != null) {
                        array.add(input);
                    }
                    for (int k = 0; k < itemStack.field_77990_d.func_74762_e("a" + i); ++k) {
                        input = ItemStack.func_77949_a((NBTTagCompound)itemStack.field_77990_d.func_74775_l("a" + i + ":" + k));
                        if (input == null) continue;
                        array.add(input);
                    }
                    if (array.size() <= 0) continue;
                    this.slots2.put(new GT_Slot_Holo(null, 0, 17 + (i & 3) * 18, 19 + (i >> 2) * 18, false, false, 64), array.toArray(TT_recipeAdder.nullItem));
                }
                for (i = 0; i < 4; ++i) {
                    FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("f" + i));
                    if (fs == null) continue;
                    this.slots.put(new GT_Slot_Holo(null, 0, 107, 19 + i * 18, false, false, 1), GT_Utility.getFluidDisplayStack((FluidStack)fs, (boolean)true));
                }
            }

            @Override
            public void renderTooltips(ItemStack itemStack, int mouseX, int mouseY, GT_GUIContainer_DataReader gui) {
                for (Map.Entry<GT_Slot_Holo, ItemStack> entry : this.slots.entrySet()) {
                    gui.renderTooltipSimple(mouseX, mouseY, entry.getKey(), entry.getValue());
                }
                int time = (int)(System.currentTimeMillis() / 2000L);
                for (Map.Entry<GT_Slot_Holo, ItemStack[]> entry : this.slots2.entrySet()) {
                    gui.renderTooltipSimple(mouseX, mouseY, entry.getKey(), entry.getValue()[time % entry.getValue().length]);
                }
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderForeground(ItemStack itemStack, int mouseX, int mouseY, GT_GUIContainer_DataReader gui, FontRenderer font) {
                int time = itemStack.field_77990_d.func_74762_e("time");
                int EUt = itemStack.field_77990_d.func_74762_e("eu");
                font.func_78276_b("Assembly Line Recipe", 7, 8, 8429823);
                font.func_78276_b(GT_Utility.trans((String)"152", (String)"Total: ") + GT_Utility.formatNumbers((long)((long)time * (long)EUt)) + " EU", 7, 93, 8429823);
                font.func_78276_b(GT_Utility.trans((String)"153", (String)"Usage: ") + GT_Utility.formatNumbers((long)EUt) + " EU/t", 7, 103, 8429823);
                font.func_78276_b(GT_Utility.trans((String)"154", (String)"Voltage: ") + GT_Utility.formatNumbers((long)EUt) + " EU", 7, 113, 8429823);
                font.func_78276_b(GT_Utility.trans((String)"155", (String)"Amperage: ") + 1, 7, 123, 8429823);
                font.func_78276_b(GT_Utility.trans((String)"158", (String)"Time: ") + GT_Utility.formatNumbers((double)(0.05 * (double)time)) + GT_Utility.trans((String)"161", (String)" secs"), 7, 133, 8429823);
                for (Map.Entry<GT_Slot_Holo, ItemStack> entry : this.slots.entrySet()) {
                    gui.renderItemSimple(entry.getKey(), entry.getValue());
                }
                time = (int)(System.currentTimeMillis() / 2000L);
                for (Map.Entry<GT_Slot_Holo, ItemStack> entry : this.slots2.entrySet()) {
                    gui.renderItemSimple(entry.getKey(), ((ItemStack[])entry.getValue())[time % ((ItemStack[])entry.getValue()).length]);
                }
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderBackgroundOverlay(ItemStack itemStack, int mouseX, int mouseY, int X, int Y, GT_GUIContainer_DataReader gui) {
                gui.field_146297_k.func_110434_K().func_110577_a(this.bg);
                gui.func_73729_b(X, Y, 0, 0, 176, 151);
            }

            @Override
            public boolean canRender(ItemStack itemStack, byte tier) {
                NBTTagCompound nbtTagCompound = itemStack.field_77990_d;
                return nbtTagCompound != null && nbtTagCompound.func_74764_b("output");
            }

            @Override
            public int getReadingEUt() {
                return (int)CommonValues.V[4];
            }

            @Override
            public int getReadingTime() {
                return 128;
            }
        });
    }

    public static interface IDataRender {
        @SideOnly(value=Side.CLIENT)
        public void loadResources();

        @SideOnly(value=Side.CLIENT)
        public void initRender(ItemStack var1);

        @SideOnly(value=Side.CLIENT)
        public void renderTooltips(ItemStack var1, int var2, int var3, GT_GUIContainer_DataReader var4);

        @SideOnly(value=Side.CLIENT)
        public void renderForeground(ItemStack var1, int var2, int var3, GT_GUIContainer_DataReader var4, FontRenderer var5);

        @SideOnly(value=Side.CLIENT)
        public void renderBackgroundOverlay(ItemStack var1, int var2, int var3, int var4, int var5, GT_GUIContainer_DataReader var6);

        public boolean canRender(ItemStack var1, byte var2);

        public int getReadingEUt();

        public int getReadingTime();
    }
}

