/*
 * Decompiled with CFR 0.152.
 */
package jpsam3hklam9.des;

import jpsam3hklam9.des.DES;

class RoundKeyGenerator {
    private static final byte[] PC1 = new byte[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
    private static final byte[] PC2 = new byte[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
    private static final byte[] CIRCULAR_SHIFTS = new byte[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};

    RoundKeyGenerator() {
    }

    private int circularLeftShift(int input, int shift) {
        return input << shift & 0xFFFFFFF | input >> 28 - shift;
    }

    private long permutationChoice1(long input) {
        return DES.genericPermutation(input, PC1, 64);
    }

    private long permutationChoice2(long input) {
        return DES.genericPermutation(input, PC2, 56);
    }

    long[] generateRoundKeys(long input) {
        input = this.permutationChoice1(input);
        int halfA = (int)(input >> 28);
        int halfB = (int)(input & 0xFFFFFFFL);
        long[] roundKeys = new long[16];
        for (int i = 0; i < 16; ++i) {
            halfA = this.circularLeftShift(halfA, CIRCULAR_SHIFTS[i]);
            halfB = this.circularLeftShift(halfB, CIRCULAR_SHIFTS[i]);
            long joinedHalves = ((long)halfA & 0xFFFFFFFFL) << 28 | (long)halfB & 0xFFFFFFFFL;
            roundKeys[i] = this.permutationChoice2(joinedHalves);
        }
        return roundKeys;
    }
}

