/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi.em_machine;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.cElementalInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.cElementalInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.iHasElementalDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.dAtomDefinition;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.MultiblockControl;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.em_machine.GT_MetaTileEntity_EM_machine;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.DoubleCount;
import java.util.Arrays;

public class Behaviour_Centrifuge
implements GT_MetaTileEntity_EM_machine.IBehaviour {
    private final byte tier;
    private double maxRPM;
    private final double radius;
    private final double maxRCF;
    private final double maxForce;
    private final double maxCapacity;
    private Parameters.Group.ParameterIn settingRPM;
    private Parameters.Group.ParameterIn settingFraction;
    private static final INameFunction<GT_MetaTileEntity_EM_machine> rpmName = (gt_metaTileEntity_em_machine, iParameter) -> "RPM Setting";
    private final IStatusFunction<GT_MetaTileEntity_EM_machine> rpmStatus = (gt_metaTileEntity_em_machine, iParameter) -> {
        double v = iParameter.get();
        if (Double.isNaN(v)) {
            return LedStatus.STATUS_WRONG;
        }
        if (v <= 0.0) {
            return LedStatus.STATUS_TOO_LOW;
        }
        if (v > this.maxRPM) {
            return LedStatus.STATUS_TOO_HIGH;
        }
        return LedStatus.STATUS_OK;
    };
    private static final INameFunction<GT_MetaTileEntity_EM_machine> fractionName = (gt_metaTileEntity_em_machine, iParameter) -> "Fraction Count";
    private static final IStatusFunction<GT_MetaTileEntity_EM_machine> fractionStatus = (gt_metaTileEntity_em_machine, iParameter) -> {
        double v = iParameter.get();
        if (Double.isNaN(v)) {
            return LedStatus.STATUS_WRONG;
        }
        if ((v = (double)((int)v)) <= 1.0) {
            return LedStatus.STATUS_TOO_LOW;
        }
        if (v > 6.0) {
            return LedStatus.STATUS_TOO_HIGH;
        }
        return LedStatus.STATUS_OK;
    };
    private static final double[][] MIXING_FACTORS = new double[][]{{0.45, 0.85, 0.95, 1.0, 1.0}, {0.4, 0.75, 0.9, 0.95, 1.0}, {0.35, 0.45, 0.75, 0.9, 0.95}, {0.25, 0.3, 0.45, 0.75, 0.9}, {0.2, 0.25, 0.3, 0.45, 0.75}, {0.1, 0.15, 0.2, 0.3, 0.45}, {0.05, 0.1, 0.15, 0.2, 0.25}, {0.01, 0.05, 0.1, 0.15, 0.2}};

    public Behaviour_Centrifuge(int desiredTier) {
        this.tier = (byte)desiredTier;
        this.radius = 0.5 - (12.0 - (double)this.tier) / 64.0;
        this.maxRCF = Math.pow(Math.E, this.tier) * 12.0;
        this.maxRPM = Math.sqrt(this.maxRCF / (0.001118 * this.radius));
        double maxSafeMass = dAtomDefinition.getSomethingHeavy().getMass() * (double)(1 << this.tier);
        this.maxForce = maxSafeMass * this.maxRCF;
        this.maxCapacity = maxSafeMass * 8.6718826944E25 * this.radius;
    }

    private double getRCF(double RPM) {
        return RPM * RPM * this.radius * 0.001118;
    }

    private void addRandomly(cElementalInstanceStack me, cElementalInstanceStackMap[] toThis, int fractionCount) {
        double amountPerFraction = DoubleCount.div(me.amount, fractionCount);
        cElementalInstanceStack[] stacks = new cElementalInstanceStack[fractionCount];
        for (int i = 0; i < fractionCount; ++i) {
            stacks[i] = me.clone();
            stacks[i].amount = amountPerFraction;
            toThis[i].putReplace(stacks[i]);
        }
    }

    @Override
    public void parametersInstantiation(GT_MetaTileEntity_EM_machine te, Parameters parameters) {
        Parameters.Group hatch1 = parameters.getGroup(7);
        this.settingRPM = hatch1.makeInParameter(0, 0.0, rpmName, this.rpmStatus);
        this.settingFraction = hatch1.makeInParameter(1, 2.0, fractionName, fractionStatus);
    }

    @Override
    public boolean checkParametersInAndSetStatuses(GT_MetaTileEntity_EM_machine te, Parameters parameters) {
        return this.settingRPM.getStatus((boolean)true).isOk && this.settingFraction.getStatus((boolean)true).isOk;
    }

    @Override
    public MultiblockControl<cElementalInstanceStackMap[]> process(cElementalInstanceStackMap[] inputs, GT_MetaTileEntity_EM_machine te, Parameters parameters) {
        double RCF;
        cElementalInstanceStackMap input = inputs[0];
        if (input == null || input.isEmpty()) {
            return null;
        }
        cElementalInstanceStack[] stacks = input.values();
        double inputMass = 0.0;
        for (cElementalInstanceStack stack : stacks) {
            inputMass += Math.abs(stack.getMass());
        }
        double excessMass = 0.0;
        while (inputMass > this.maxCapacity) {
            cElementalInstanceStack randomStack = stacks[TecTech.RANDOM.nextInt(stacks.length)];
            double amountToRemove = TecTech.RANDOM.nextDouble() / 10.0 * randomStack.getAmount();
            randomStack.amount = DoubleCount.sub(randomStack.amount, amountToRemove);
            if (randomStack.amount <= 0.0) {
                input.remove(randomStack.definition);
                stacks = input.values();
            }
            double mass = Math.abs(randomStack.getDefinition().getMass()) * amountToRemove;
            excessMass += mass;
            inputMass -= mass;
        }
        inputMass = Math.abs(input.getMass());
        if (inputMass * (RCF = this.getRCF(this.settingRPM.get())) > this.maxForce) {
            return new MultiblockControl<cElementalInstanceStackMap[]>(excessMass);
        }
        int fractionCount = (int)this.settingFraction.get();
        cElementalInstanceStackMap[] outputs = new cElementalInstanceStackMap[fractionCount];
        for (int i = 0; i < fractionCount; ++i) {
            outputs[i] = new cElementalInstanceStackMap();
        }
        double mixingFactor = Math.min(1.0 - RCF / this.maxRCF * (1.0 - MIXING_FACTORS[this.tier - 5][fractionCount - 2]), 1.0);
        if (TecTechConfig.DEBUG_MODE) {
            TecTech.LOGGER.info((Object)("mixingFactor " + mixingFactor));
        }
        int mEut = (int)(Math.pow(this.settingRPM.get() / this.maxRPM, 3.0) * (double)CommonValues.V[this.tier]);
        mEut = Math.max(mEut, 512);
        mEut = -mEut;
        int mTicks = (int)(20.0 * (inputMass / this.maxCapacity) * (double)(fractionCount - 1));
        mTicks = Math.max(mTicks, 20);
        stacks = input.takeAllToNewMap().values();
        if (stacks.length > 1) {
            double amount;
            Arrays.sort(stacks, (o1, o2) -> {
                double m2;
                double m1 = o1.definition.getMass();
                if (m1 < (m2 = o2.definition.getMass())) {
                    return -1;
                }
                if (m1 > m2) {
                    return 1;
                }
                return o1.compareTo((iHasElementalDefinition)o2);
            });
            double absMassPerOutput = 0.0;
            for (cElementalInstanceStack stack : stacks) {
                double tempMass = Math.abs(stack.getMass());
                if (tempMass == 0.0) continue;
                amount = stack.amount;
                stack.amount = DoubleCount.mul(stack.amount, mixingFactor);
                this.addRandomly(stack, outputs, fractionCount);
                stack.amount = DoubleCount.sub(amount, stack.amount);
                absMassPerOutput += tempMass;
            }
            absMassPerOutput = DoubleCount.div(absMassPerOutput, fractionCount);
            if (TecTechConfig.DEBUG_MODE) {
                TecTech.LOGGER.info((Object)("absMassPerOutput " + absMassPerOutput));
            }
            block4: for (int fraction = 0; fraction < fractionCount - 1; ++fraction) {
                double remaining = absMassPerOutput;
                for (int stackNo = 0; stackNo < stacks.length; ++stackNo) {
                    if (stacks[stackNo] == null) continue;
                    double stackMass = Math.abs(stacks[stackNo].getMass());
                    amount = DoubleCount.div(remaining, Math.abs(stacks[stackNo].definition.getMass()));
                    if (stackMass == 0.0) {
                        this.addRandomly(stacks[stackNo], outputs, fractionCount);
                        stacks[stackNo] = null;
                        continue;
                    }
                    if (amount >= stacks[stackNo].amount) {
                        remaining = DoubleCount.sub(remaining, stackMass);
                        outputs[fraction].putUnify(stacks[stackNo]);
                        stacks[stackNo] = null;
                        continue;
                    }
                    if (!(amount > 0.0)) continue block4;
                    remaining = DoubleCount.sub(remaining, DoubleCount.mul(amount, stacks[stackNo].definition.getMass()));
                    cElementalInstanceStack clone = stacks[stackNo].clone();
                    clone.amount = amount;
                    outputs[fraction].putUnify(clone);
                    stacks[stackNo].amount = DoubleCount.sub(stacks[stackNo].amount, amount);
                }
            }
            for (cElementalInstanceStack stack : stacks) {
                if (stack == null) continue;
                outputs[fractionCount - 1].putUnify(stack);
            }
        } else {
            this.addRandomly(stacks[0], outputs, fractionCount);
        }
        return new MultiblockControl<cElementalInstanceStackMap[]>(outputs, mEut, 1, 0, 10000, mTicks, 0, excessMass);
    }
}

