/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.enderStorage;

import com.github.technus.tectech.mechanics.enderStorage.EnderLinkTag;
import com.github.technus.tectech.mechanics.enderStorage.EnderLinkTank;
import com.github.technus.tectech.mechanics.enderStorage.EnderWorldSavedData;
import com.github.technus.tectech.thing.cover.GT_Cover_TM_EnderFluidLink;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import eu.usrv.yamcore.network.server.AbstractServerMessageHandler;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.IFluidHandler;

public class EnderLinkCoverMessage
implements IMessage {
    EnderLinkTankWithTag messageData;

    public void fromBytes(ByteBuf pBuffer) {
        try {
            byte[] boop = pBuffer.array();
            boop = Arrays.copyOfRange(boop, 1, boop.length);
            ByteArrayInputStream is = new ByteArrayInputStream(boop);
            ObjectInputStream ois = new ObjectInputStream(is);
            Object data = ois.readObject();
            this.messageData = (EnderLinkTankWithTag)data;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void toBytes(ByteBuf pBuffer) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.messageData);
            oos.flush();
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            pBuffer.writeBytes((InputStream)is, baos.toByteArray().length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class EnderLinkTankWithTag
    extends EnderLinkTank {
        private final EnderLinkTag tag;

        public EnderLinkTankWithTag(EnderLinkTag tag, IFluidHandler fluidHandler) {
            super(fluidHandler);
            this.tag = tag;
        }

        public EnderLinkTag getTag() {
            return this.tag;
        }
    }

    public static class ClientHandler
    extends AbstractClientMessageHandler<EnderLinkCoverData> {
        public IMessage handleClientMessage(EntityPlayer pPlayer, EnderLinkCoverData pMessage, MessageContext pCtx) {
            if (pMessage.messageData != null) {
                GT_Cover_TM_EnderFluidLink.setEnderLinkTag(pMessage.messageData.getTag());
            }
            return null;
        }
    }

    public static class ServerUpdateHandler
    extends AbstractServerMessageHandler<EnderLinkCoverUpdate> {
        public IMessage handleServerMessage(EntityPlayer pPlayer, EnderLinkCoverUpdate pMessage, MessageContext pCtx) {
            if (pMessage.messageData != null) {
                EnderLinkTag tag = pMessage.messageData.getTag();
                IFluidHandler handler = pMessage.messageData.getFluidHandler();
                if (tag.getUUID() == null) {
                    EnderWorldSavedData.bindEnderLinkTag(handler, tag);
                } else if (handler instanceof BaseMetaTileEntity) {
                    BaseMetaTileEntity baseTile = (BaseMetaTileEntity)handler;
                    if (tag.getUUID().equals(baseTile.getOwnerUuid())) {
                        EnderWorldSavedData.bindEnderLinkTag(handler, tag);
                    }
                }
            }
            return null;
        }
    }

    public static class ServerHandler
    extends AbstractServerMessageHandler<EnderLinkCoverQuery> {
        public IMessage handleServerMessage(EntityPlayer pPlayer, EnderLinkCoverQuery pMessage, MessageContext pCtx) {
            EnderLinkCoverData reply = null;
            if (pMessage.messageData != null) {
                reply = new EnderLinkCoverData(EnderWorldSavedData.getEnderLinkTag(pMessage.messageData.getFluidHandler()), pMessage.messageData.getFluidHandler());
            }
            return reply;
        }
    }

    public static class EnderLinkCoverData
    extends EnderLinkCoverMessage {
        public EnderLinkCoverData() {
        }

        public EnderLinkCoverData(EnderLinkTag tag, IFluidHandler fluidHandler) {
            this.messageData = new EnderLinkTankWithTag(tag, fluidHandler);
        }
    }

    public static class EnderLinkCoverUpdate
    extends EnderLinkCoverMessage {
        public EnderLinkCoverUpdate() {
        }

        public EnderLinkCoverUpdate(EnderLinkTag tag, IFluidHandler fluidHandler) {
            this.messageData = new EnderLinkTankWithTag(tag, fluidHandler);
        }
    }

    public static class EnderLinkCoverQuery
    extends EnderLinkCoverMessage {
        public EnderLinkCoverQuery() {
        }

        public EnderLinkCoverQuery(EnderLinkTag tag, IFluidHandler fluidHandler) {
            this.messageData = new EnderLinkTankWithTag(tag, fluidHandler);
        }
    }
}

