/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.nei.NEI_TT_Config;
import com.github.technus.tectech.recipe.TT_recipe;
import com.github.technus.tectech.recipe.TT_recipeAdder;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TT_NEI_ScannerHandler
extends TemplateRecipeHandler {
    protected final TT_recipe.GT_Recipe_MapTT mRecipeMap;

    public TT_NEI_ScannerHandler(TT_recipe.GT_Recipe_MapTT aRecipeMap) {
        this.mRecipeMap = aRecipeMap;
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 13, 36, 18), this.getOverlayIdentifier(), new Object[0]));
        if (!NEI_TT_Config.sIsAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)TecTech.instance, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("tectech@" + this.getRecipeName() + '@' + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
    }

    public List<GT_Recipe> getSortedRecipes() {
        ArrayList<GT_Recipe> result = new ArrayList<GT_Recipe>(this.mRecipeMap.mRecipeList);
        Collections.sort(result);
        return result;
    }

    public static void drawText(int aX, int aY, String aString, int aColor) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(aString, aX, aY, aColor);
    }

    public TemplateRecipeHandler newInstance() {
        NEI_TT_Config.TT_SH = new TT_NEI_ScannerHandler(this.mRecipeMap);
        return NEI_TT_Config.TT_SH;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (GT_Recipe tRecipe : this.getSortedRecipes()) {
                if (tRecipe.mHidden) continue;
                this.arecipes.add(new CachedDefaultRecipe(tRecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        FluidStack tFluid;
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation((ItemStack)aResult);
        ArrayList<ItemStack> tResults = new ArrayList<ItemStack>();
        tResults.add(aResult);
        tResults.add(GT_OreDictUnificator.get((boolean)true, (ItemStack)aResult));
        if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tResults.add(GT_OreDictUnificator.get((OrePrefixes)tPrefix, (Object)tPrefixMaterial.mMaterial.mMaterial, (long)1L));
            }
        }
        if ((tFluid = GT_Utility.getFluidForFilledItem((ItemStack)aResult, (boolean)true)) != null) {
            tResults.add(GT_Utility.getFluidDisplayStack((FluidStack)tFluid, (boolean)false));
            for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!tData.fluid.isFluidEqual(tFluid)) continue;
                tResults.add(GT_Utility.copy((Object[])new Object[]{tData.filledContainer}));
            }
        }
        block2: for (GT_Recipe tRecipe : this.getSortedRecipes()) {
            if (tRecipe.mHidden) continue;
            CachedDefaultRecipe tNEIRecipe = new CachedDefaultRecipe(tRecipe);
            for (ItemStack tStack : tResults) {
                if (!tNEIRecipe.contains(tNEIRecipe.mOutputs, tStack)) continue;
                this.arecipes.add(tNEIRecipe);
                continue block2;
            }
        }
    }

    public void loadUsageRecipes(ItemStack aInput) {
        FluidStack tFluid;
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation((ItemStack)aInput);
        ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
        tInputs.add(aInput);
        tInputs.add(GT_OreDictUnificator.get((boolean)false, (ItemStack)aInput));
        if (tPrefixMaterial != null && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tInputs.add(GT_OreDictUnificator.get((OrePrefixes)tPrefix, (Object)tPrefixMaterial.mMaterial.mMaterial, (long)1L));
            }
        }
        if ((tFluid = GT_Utility.getFluidForFilledItem((ItemStack)aInput, (boolean)true)) != null) {
            tInputs.add(GT_Utility.getFluidDisplayStack((FluidStack)tFluid, (boolean)false));
            for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!tData.fluid.isFluidEqual(tFluid)) continue;
                tInputs.add(GT_Utility.copy((Object[])new Object[]{tData.filledContainer}));
            }
        }
        block2: for (GT_Recipe tRecipe : this.getSortedRecipes()) {
            if (tRecipe.mHidden) continue;
            CachedDefaultRecipe tNEIRecipe = new CachedDefaultRecipe(tRecipe);
            for (ItemStack tStack : tInputs) {
                if (!tNEIRecipe.contains(tNEIRecipe.mInputs, tStack)) continue;
                this.arecipes.add(tNEIRecipe);
                continue block2;
            }
        }
    }

    public String getOverlayIdentifier() {
        return this.mRecipeMap.mNEIName;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-4, (int)-8, (int)1, (int)3, (int)174, (int)78);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return GT_LanguageManager.getTranslation((String)this.mRecipeMap.mUnlocalizedName);
    }

    public String getGuiTexture() {
        return this.mRecipeMap.mNEIGUIPath;
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack aStack, List<String> currenttip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof CachedDefaultRecipe) {
            CachedDefaultRecipe tRecipe = (CachedDefaultRecipe)tObject;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!(tStack instanceof FixedPositionedStack) || ((FixedPositionedStack)tStack).mChance <= 0 || ((FixedPositionedStack)tStack).mChance == 10000) break;
                currenttip.add(this.trans("150", "Chance: ") + ((FixedPositionedStack)tStack).mChance / 100 + '.' + (((FixedPositionedStack)tStack).mChance % 100 < 10 ? "0" + ((FixedPositionedStack)tStack).mChance % 100 : Integer.valueOf(((FixedPositionedStack)tStack).mChance % 100)) + '%');
                break;
            }
            for (PositionedStack tStack : tRecipe.mInputs) {
                if (aStack != tStack.item) continue;
                if (gregtech.api.enums.ItemList.Display_Fluid.isStackEqual((Object)tStack.item, true, true) || tStack.item.field_77994_a != 0) break;
                currenttip.add(this.trans("151", "Does not get consumed in the process"));
                break;
            }
        }
        return currenttip;
    }

    public void drawExtras(int aRecipeIndex) {
        int tEUt = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mEUt;
        int computation = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mDuration;
        String[] recipeDesc = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.getNeiDesc();
        if (recipeDesc == null) {
            int tSpecial = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mSpecialValue;
            short ampere = (short)(tSpecial & 0xFFFF);
            short minComputationPerSec = (short)(tSpecial >>> 16);
            if (tEUt != 0) {
                TT_NEI_ScannerHandler.drawText(10, 73, this.trans("152", "Max EU: ") + GT_Utility.formatNumbers((long)((long)(1 + (computation - minComputationPerSec) / minComputationPerSec) * (long)tEUt * (long)ampere * 20L)) + " EU", -16777216);
                TT_NEI_ScannerHandler.drawText(10, 83, this.trans("153", "Usage: ") + GT_Utility.formatNumbers((long)((long)tEUt * (long)ampere)) + " EU/t", -16777216);
                if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                    TT_NEI_ScannerHandler.drawText(10, 93, this.trans("154", "Voltage: ") + GT_Utility.formatNumbers((long)tEUt) + " EU", -16777216);
                    TT_NEI_ScannerHandler.drawText(10, 103, this.trans("155", "Amperage: ") + GT_Utility.formatNumbers((long)ampere), -16777216);
                } else {
                    TT_NEI_ScannerHandler.drawText(10, 93, this.trans("156", "Voltage: unspecified"), -16777216);
                    TT_NEI_ScannerHandler.drawText(10, 103, this.trans("157", "Amperage: unspecified"), -16777216);
                }
            }
            TT_NEI_ScannerHandler.drawText(10, 113, "Computation: " + GT_Utility.formatNumbers((long)computation), -16777216);
            TT_NEI_ScannerHandler.drawText(10, 123, "Min Computation: " + GT_Utility.formatNumbers((long)minComputationPerSec) + " /s", -16777216);
        } else {
            int i = 0;
            for (String descLine : recipeDesc) {
                TT_NEI_ScannerHandler.drawText(10, 73 + 10 * i, descLine, -16777216);
                ++i;
            }
        }
    }

    public String trans(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization((String)("Interaction_DESCRIPTION_Index_" + aKey), (String)aEnglish, (boolean)false);
    }

    public class CachedDefaultRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final GT_Recipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        public CachedDefaultRecipe(GT_Recipe aRecipe) {
            super((TemplateRecipeHandler)TT_NEI_ScannerHandler.this);
            this.mRecipe = aRecipe;
            this.mOutputs = new ArrayList<PositionedStack>();
            this.mInputs = new ArrayList<PositionedStack>();
            int tStartIndex = 0;
            if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 23));
            }
            if (aRecipe.mSpecialItems != null) {
                this.mInputs.add(new FixedPositionedStack(aRecipe.mSpecialItems, 120, 52));
            }
            if (aRecipe.getOutput(tStartIndex) != null) {
                this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 23, aRecipe.getOutputChance(tStartIndex)));
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(TT_NEI_ScannerHandler.this.cycleticks / 10, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }
    }

    public static class FixedPositionedStack
    extends PositionedStack {
        public final int mChance;
        public boolean permutated = false;

        public FixedPositionedStack(Object object, int x, int y) {
            this(object, x, y, 0);
        }

        public FixedPositionedStack(Object object, int x, int y, int aChance) {
            super(object, x, y, true);
            this.mChance = aChance;
        }

        public void generatePermutations() {
            if (this.permutated) {
                return;
            }
            ArrayList<ItemStack> tDisplayStacks = new ArrayList<ItemStack>();
            for (ItemStack tStack : this.items) {
                if (!GT_Utility.isStackValid((Object)tStack)) continue;
                if (tStack.func_77960_j() == Short.MAX_VALUE) {
                    List permutations = ItemList.itemMap.get((Object)tStack.func_77973_b());
                    if (!permutations.isEmpty()) {
                        for (ItemStack stack : permutations) {
                            tDisplayStacks.add(GT_Utility.copyAmount((long)tStack.field_77994_a, (Object[])new Object[]{stack}));
                        }
                        continue;
                    }
                    ItemStack base = new ItemStack(tStack.func_77973_b(), tStack.field_77994_a);
                    base.field_77990_d = tStack.field_77990_d;
                    tDisplayStacks.add(base);
                    continue;
                }
                tDisplayStacks.add(GT_Utility.copy((Object[])new Object[]{tStack}));
            }
            this.items = tDisplayStacks.toArray(TT_recipeAdder.nullItem);
            if (this.items.length == 0) {
                this.items = new ItemStack[]{new ItemStack((Block)Blocks.field_150480_ab)};
            }
            this.permutated = true;
            this.setPermutationToRender(0);
        }
    }

    @Deprecated
    public static class GT_RectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
            return false;
        }

        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public boolean canHandle(GuiContainer gui) {
            return false;
        }

        public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
            return currenttip;
        }

        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        }

        public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
        }
    }
}

